/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.impl;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.InnerClassesAttribute;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.powermock.core.IndicateReloadClass;
import org.powermock.core.MockGateway;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.TransformStrategy;

public abstract class AbstractMainMockTransformer
implements MockTransformer {
    private static final String VOID = "";
    private static final int METHOD_CODE_LENGTH_LIMIT = 65536;
    protected final TransformStrategy strategy;

    public AbstractMainMockTransformer(TransformStrategy strategy) {
        this.strategy = strategy;
    }

    protected String allowMockingOfPackagePrivateClasses(CtClass clazz) {
        String name = clazz.getName();
        if (this.strategy != TransformStrategy.INST_REDEFINE) {
            try {
                int modifiers = clazz.getModifiers();
                if (!(!Modifier.isPackage((int)modifiers) || name.startsWith("java.") || clazz.isInterface() && clazz.getDeclaringClass() != null)) {
                    clazz.setModifiers(Modifier.setPublic((int)modifiers));
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return name;
    }

    protected void suppressStaticInitializerIfRequested(CtClass clazz, String name) throws CannotCompileException {
        if (this.strategy == TransformStrategy.CLASSLOADER && MockGateway.staticConstructorCall(name) != MockGateway.PROCEED) {
            CtConstructor classInitializer = clazz.makeClassInitializer();
            classInitializer.setBody("{}");
        }
    }

    protected void removeFinalModifierFromClass(CtClass clazz) {
        if (this.strategy != TransformStrategy.INST_REDEFINE) {
            ClassFile classFile;
            AttributeInfo attribute;
            if (Modifier.isFinal((int)clazz.getModifiers())) {
                clazz.setModifiers(clazz.getModifiers() ^ 0x10);
            }
            if ((attribute = (classFile = clazz.getClassFile2()).getAttribute("InnerClasses")) != null && attribute instanceof InnerClassesAttribute) {
                InnerClassesAttribute ica = (InnerClassesAttribute)attribute;
                String name = classFile.getName();
                int n = ica.tableLength();
                for (int i = 0; i < n; ++i) {
                    int accessFlags;
                    if (!name.equals(ica.innerClass(i)) || !Modifier.isFinal((int)(accessFlags = ica.accessFlags(i)))) continue;
                    ica.setAccessFlags(i, accessFlags ^ 0x10);
                }
            }
        }
    }

    protected void allowMockingOfStaticAndFinalAndNativeMethods(CtClass clazz) throws NotFoundException, CannotCompileException {
        if (this.strategy != TransformStrategy.INST_TRANSFORM) {
            for (CtMethod m : clazz.getDeclaredMethods()) {
                this.modifyMethod(m);
            }
        }
    }

    protected void removeFinalModifierFromAllStaticFinalFields(CtClass clazz) {
        if (this.strategy != TransformStrategy.INST_REDEFINE) {
            for (CtField f : clazz.getDeclaredFields()) {
                int modifiers = f.getModifiers();
                if (!Modifier.isFinal((int)modifiers) || !Modifier.isStatic((int)modifiers)) continue;
                f.setModifiers(modifiers ^ 0x10);
            }
        }
    }

    protected void setAllConstructorsToPublic(CtClass clazz) {
        if (this.strategy == TransformStrategy.CLASSLOADER) {
            for (CtConstructor c : clazz.getDeclaredConstructors()) {
                int modifiers = c.getModifiers();
                if (Modifier.isPublic((int)modifiers)) continue;
                c.setModifiers(Modifier.setPublic((int)modifiers));
            }
        }
    }

    protected CtClass ensureJvmMethodSizeLimit(CtClass clazz) throws CannotCompileException, NotFoundException {
        for (CtMethod method : clazz.getDeclaredMethods()) {
            if (!this.isMethodSizeExceeded(method)) continue;
            String code = "{throw new IllegalAccessException(\"Method was too large and after instrumentation exceeded JVM limit. PowerMock modified the method to allow JVM to load the class. You can use PowerMock API to suppress or mock this method behaviour.\");}";
            method.setBody(code);
            this.modifyMethod(method);
        }
        return clazz;
    }

    private boolean isMethodSizeExceeded(CtMethod method) {
        CodeAttribute codeAttribute = method.getMethodInfo().getCodeAttribute();
        return codeAttribute != null && codeAttribute.getCodeLength() >= 65536;
    }

    private void modifyMethod(CtMethod method) throws NotFoundException, CannotCompileException {
        if (!Modifier.isAbstract((int)method.getModifiers())) {
            CtClass returnTypeAsCtClass = method.getReturnType();
            String returnTypeAsString = this.getReturnTypeAsString(method);
            if (Modifier.isNative((int)method.getModifiers())) {
                String methodName = method.getName();
                String returnValue = "($r)value";
                if (returnTypeAsCtClass.equals(CtClass.voidType)) {
                    returnValue = VOID;
                }
                String classOrInstance = "this";
                if (Modifier.isStatic((int)method.getModifiers())) {
                    classOrInstance = "$class";
                }
                method.setModifiers(method.getModifiers() - 256);
                String code = "Object value = " + MockGateway.class.getName() + ".methodCall(" + classOrInstance + ", \"" + method.getName() + "\", $args, $sig, \"" + returnTypeAsString + "\");" + "if (value != " + MockGateway.class.getName() + ".PROCEED) " + "return " + returnValue + "; " + "throw new java.lang.UnsupportedOperationException(\"" + methodName + " is native\");";
                method.setBody("{" + code + "}");
                return;
            }
            String returnValue = this.getCorrectReturnValueType(returnTypeAsCtClass);
            String classOrInstance = "this";
            if (Modifier.isStatic((int)method.getModifiers())) {
                classOrInstance = "$class";
            }
            String code = "Object value = " + MockGateway.class.getName() + ".methodCall(" + classOrInstance + ", \"" + method.getName() + "\", $args, $sig, \"" + returnTypeAsString + "\");" + "if (value != " + MockGateway.class.getName() + ".PROCEED) " + "return " + returnValue + "; ";
            method.insertBefore("{ " + code + "}");
        }
    }

    private String getReturnTypeAsString(CtMethod method) throws NotFoundException {
        CtClass returnType = method.getReturnType();
        String returnTypeAsString = VOID;
        if (!returnType.equals(CtClass.voidType)) {
            returnTypeAsString = returnType.getName();
        }
        return returnTypeAsString;
    }

    private String getCorrectReturnValueType(CtClass returnTypeAsCtClass) {
        String returnTypeAsString = returnTypeAsCtClass.getName();
        String returnValue = returnTypeAsCtClass.equals(CtClass.voidType) ? VOID : (returnTypeAsCtClass.isPrimitive() ? (returnTypeAsString.equals("char") ? "((java.lang.Character)value).charValue()" : (returnTypeAsString.equals("boolean") ? "((java.lang.Boolean)value).booleanValue()" : "((java.lang.Number)value)." + returnTypeAsString + "Value()")) : "(" + returnTypeAsString + ")value");
        return returnValue;
    }

    @Override
    public CtClass transform(CtClass clazz) throws Exception {
        if (clazz.isFrozen()) {
            clazz.defrost();
        }
        return this.transformMockClass(clazz);
    }

    protected abstract CtClass transformMockClass(CtClass var1) throws CannotCompileException, NotFoundException;

    protected final class PowerMockExpressionEditor
    extends ExprEditor {
        private final CtClass clazz;

        protected PowerMockExpressionEditor(CtClass clazz) {
            this.clazz = clazz;
        }

        public void edit(FieldAccess f) throws CannotCompileException {
            if (f.isReader()) {
                CtClass returnTypeAsCtClass;
                try {
                    returnTypeAsCtClass = f.getField().getType();
                }
                catch (NotFoundException e) {
                    return;
                }
                StringBuilder code = new StringBuilder();
                code.append("{Object value =  ").append(MockGateway.class.getName()).append(".fieldCall(").append("$0,$class,\"").append(f.getFieldName()).append("\",$type);");
                code.append("if(value == ").append(MockGateway.class.getName()).append(".PROCEED) {");
                code.append("\t$_ = $proceed($$);");
                code.append("} else {");
                code.append("\t$_ = ").append(AbstractMainMockTransformer.this.getCorrectReturnValueType(returnTypeAsCtClass)).append(";");
                code.append("}}");
                f.replace(code.toString());
            }
        }

        public void edit(MethodCall m) throws CannotCompileException {
            try {
                CtMethod method = m.getMethod();
                CtClass declaringClass = method.getDeclaringClass();
                if (declaringClass != null && this.shouldTreatAsSystemClassCall(declaringClass)) {
                    StringBuilder code = new StringBuilder();
                    code.append("{Object classOrInstance = null; if($0!=null){classOrInstance = $0;} else { classOrInstance = $class;}");
                    code.append("Object value =  ").append(MockGateway.class.getName()).append(".methodCall(").append("classOrInstance,\"").append(m.getMethodName()).append("\",$args, $sig,\"").append(AbstractMainMockTransformer.this.getReturnTypeAsString(method)).append("\");");
                    code.append("if(value == ").append(MockGateway.class.getName()).append(".PROCEED) {");
                    code.append("\t$_ = $proceed($$);");
                    code.append("} else {");
                    String correctReturnValueType = AbstractMainMockTransformer.this.getCorrectReturnValueType(method.getReturnType());
                    if (!AbstractMainMockTransformer.VOID.equals(correctReturnValueType)) {
                        code.append("\t$_ = ").append(correctReturnValueType).append(";");
                    }
                    code.append("}}");
                    m.replace(code.toString());
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }

        private boolean shouldTreatAsSystemClassCall(CtClass declaringClass) {
            String className = declaringClass.getName();
            return className.startsWith("java.");
        }

        public void edit(ConstructorCall c) throws CannotCompileException {
            if (AbstractMainMockTransformer.this.strategy != TransformStrategy.INST_REDEFINE && !c.getClassName().startsWith("java.lang")) {
                CtClass superclass;
                try {
                    superclass = this.clazz.getSuperclass();
                }
                catch (NotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.addNewDeferConstructor(this.clazz);
                StringBuilder code = new StringBuilder();
                code.append("{Object value =").append(MockGateway.class.getName()).append(".constructorCall($class, $args, $sig);");
                code.append("if (value != ").append(MockGateway.class.getName()).append(".PROCEED){");
                if (superclass.getName().equals(Object.class.getName())) {
                    code.append(" super();");
                } else {
                    code.append(" super((" + IndicateReloadClass.class.getName() + ") null);");
                }
                code.append("} else {");
                code.append("   $proceed($$);");
                code.append("}}");
                c.replace(code.toString());
            }
        }

        private void addNewDeferConstructor(CtClass clazz) throws CannotCompileException {
            CtClass constructorType;
            CtClass superClass;
            try {
                superClass = clazz.getSuperclass();
            }
            catch (NotFoundException e1) {
                throw new IllegalArgumentException("Internal error: Failed to get superclass for " + clazz.getName() + " when about to create a new default constructor.");
            }
            ClassPool classPool = clazz.getClassPool();
            try {
                constructorType = classPool.get(IndicateReloadClass.class.getName());
            }
            catch (NotFoundException e) {
                throw new IllegalArgumentException("Internal error: failed to get the " + IndicateReloadClass.class.getName() + " when added defer constructor.");
            }
            clazz.defrost();
            if (superClass.getName().equals(Object.class.getName())) {
                try {
                    clazz.addConstructor(CtNewConstructor.make((CtClass[])new CtClass[]{constructorType}, (CtClass[])new CtClass[0], (String)"{super();}", (CtClass)clazz));
                }
                catch (DuplicateMemberException duplicateMemberException) {}
            } else {
                this.addNewDeferConstructor(superClass);
                try {
                    clazz.addConstructor(CtNewConstructor.make((CtClass[])new CtClass[]{constructorType}, (CtClass[])new CtClass[0], (String)"{super($$);}", (CtClass)clazz));
                }
                catch (DuplicateMemberException duplicateMemberException) {
                    // empty catch block
                }
            }
        }

        public void edit(NewExpr e) throws CannotCompileException {
            StringBuilder code = new StringBuilder();
            code.append("Object instance =").append(MockGateway.class.getName()).append(".newInstanceCall($type,$args,$sig);");
            code.append("if(instance != ").append(MockGateway.class.getName()).append(".PROCEED) {");
            code.append("\tif(instance instanceof java.lang.reflect.Constructor) {");
            code.append("\t\t$_ = ($r) sun.reflect.ReflectionFactory.getReflectionFactory().newConstructorForSerialization($type, java.lang.Object.class.getDeclaredConstructor(null)).newInstance(null);");
            code.append("\t} else {");
            code.append("\t\t$_ = ($r) instance;");
            code.append("\t}");
            code.append("} else {");
            code.append("\t$_ = $proceed($$);");
            code.append("}");
            e.replace(code.toString());
        }
    }
}

