/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.collections.NottableStringHashMap;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.KeyAndValue;
import org.mockserver.model.KeysAndValues;

public class HashMapMatcher
extends NotMatcher<KeysAndValues<? extends KeyAndValue, ? extends KeysAndValues>> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableStringHashMap matcher;
    private final KeysAndValues keysAndValues;
    private final boolean controlPlaneMatcher;
    private Boolean allKeysNotted;
    private Boolean allKeysOptional;

    HashMapMatcher(MockServerLogger mockServerLogger, KeysAndValues<? extends KeyAndValue, ? extends KeysAndValues> keysAndValues, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.keysAndValues = keysAndValues;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = keysAndValues != null ? new NottableStringHashMap(this.mockServerLogger, this.controlPlaneMatcher, keysAndValues.getEntries()) : null;
    }

    @Override
    public boolean matches(MatchDifference context, KeysAndValues<? extends KeyAndValue, ? extends KeysAndValues> matched) {
        boolean result;
        if (this.matcher == null || this.matcher.isEmpty()) {
            result = true;
        } else if (matched == null || matched.isEmpty()) {
            if (this.allKeysNotted == null) {
                this.allKeysNotted = this.matcher.allKeysNotted();
            }
            if (this.allKeysOptional == null) {
                this.allKeysOptional = this.matcher.allKeysOptional();
            }
            result = this.allKeysNotted != false || this.allKeysOptional != false;
        } else {
            result = new NottableStringHashMap(this.mockServerLogger, this.controlPlaneMatcher, matched.getEntries()).containsAll(this.matcher);
        }
        if (!result && context != null) {
            context.addDifference(this.mockServerLogger, "map subset match failed expected:{}found:{}failed because:{}", this.keysAndValues, matched != null ? matched : "none", matched != null ? "map is not a subset" : "none is not a subset");
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || this.matcher.isEmpty();
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

