/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Objects;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.MediaType;
import org.mockserver.serialization.Base64Converter;

public class BinaryBody
extends BodyWithContentType<byte[]> {
    private int hashCode;
    private final byte[] bytes;
    private final Base64Converter base64Converter = new Base64Converter();

    public BinaryBody(byte[] bytes) {
        this(bytes, null);
    }

    public BinaryBody(byte[] bytes, MediaType contentType) {
        super(Body.Type.BINARY, contentType);
        this.bytes = bytes;
    }

    public static BinaryBody binary(byte[] body) {
        return new BinaryBody(body);
    }

    public static BinaryBody binary(byte[] body, MediaType contentType) {
        return new BinaryBody(body, contentType);
    }

    @Override
    public byte[] getValue() {
        return this.bytes;
    }

    @Override
    @JsonIgnore
    public byte[] getRawBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        return this.bytes != null ? this.base64Converter.bytesToBase64String(this.bytes) : null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryBody that = (BinaryBody)o;
        return Arrays.equals(this.bytes, that.bytes) && Objects.equals(this.base64Converter, that.base64Converter);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int result = Objects.hash(super.hashCode(), this.base64Converter);
            this.hashCode = 31 * result + Arrays.hashCode(this.bytes);
        }
        return this.hashCode;
    }
}

