/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.regex.Matcher;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.ParametrizedMatcher;
import net.javacrumbs.jsonunit.core.internal.Context;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.Node;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;

class HamcrestHandler {
    private final Configuration configuration;
    private final DifferenceReporter valueDifferenceReporter;
    private final DifferenceReporter structureDifferenceReporter;

    HamcrestHandler(Configuration configuration, DifferenceReporter valueDifferenceReporter, DifferenceReporter structureDifferenceReporter) {
        this.configuration = configuration;
        this.valueDifferenceReporter = valueDifferenceReporter;
        this.structureDifferenceReporter = structureDifferenceReporter;
    }

    void matchHamcrestMatcher(Context context, Node actualNode, Matcher patternMatcher, String matcherName) {
        org.hamcrest.Matcher<?> matcher = this.configuration.getMatcher(matcherName);
        if (matcher != null) {
            Object value;
            if (matcher instanceof ParametrizedMatcher) {
                ((ParametrizedMatcher)matcher).setParameter(patternMatcher.group(2));
            }
            if (!matcher.matches(value = actualNode.getValue())) {
                StringDescription description = new StringDescription();
                matcher.describeMismatch(value, (Description)description);
                this.valueDifferenceReporter.differenceFound(context, "Matcher \"%s\" does not match value %s in node \"%s\". %s", matcherName, Diff.quoteTextValue(actualNode), context.getActualPath(), description);
            }
        } else {
            this.structureDifferenceReporter.differenceFound(context, "Matcher \"%s\" not found.", matcherName);
        }
    }

    @FunctionalInterface
    static interface DifferenceReporter {
        public void differenceFound(Context var1, String var2, Object ... var3);
    }
}

