/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jetbrains.annotations.NotNull;

class Utils {
    Utils() {
    }

    static String readAsString(Reader resourceReader) throws IOException {
        int numCharsRead;
        if (resourceReader instanceof JsonStringReader) {
            return ((JsonStringReader)resourceReader).getString();
        }
        StringBuilder builder = new StringBuilder();
        char[] arr = new char[8192];
        while ((numCharsRead = resourceReader.read(arr, 0, arr.length)) != -1) {
            builder.append(arr, 0, numCharsRead);
        }
        resourceReader.close();
        return builder.toString();
    }

    static Reader toReader(String string) {
        return new JsonStringReader(string);
    }

    static void closeQuietly(Reader resourceReader) {
        if (resourceReader != null) {
            try {
                resourceReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class JsonStringReader
    extends StringReader {
        private final String string;

        public JsonStringReader(@NotNull String s) {
            super(s);
            this.string = s;
        }

        public String getString() {
            return this.string;
        }
    }
}

