/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.framework.PackagePermissionCollection;

public final class PackagePermission
extends BasicPermission {
    static final long serialVersionUID = -5107705877071099135L;
    public static final String EXPORT = "export";
    public static final String IMPORT = "import";
    private static final int ACTION_EXPORT = 1;
    private static final int ACTION_IMPORT = 2;
    private static final int ACTION_ALL = 3;
    private static final int ACTION_NONE = 0;
    private transient int action_mask = 0;
    private String actions = null;

    public PackagePermission(String name, String actions) {
        this(name, PackagePermission.getMask(actions));
    }

    PackagePermission(String name, int mask) {
        super(name);
        this.init(mask);
    }

    private void init(int mask) {
        if (mask == 0 || (mask & 3) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
    }

    private static int getMask(String actions) {
        boolean seencomma = false;
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        char[] a = actions.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            return mask;
        }
        while (i != -1) {
            int matchlen;
            char c;
            while (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (!(i < 5 || a[i - 5] != 'i' && a[i - 5] != 'I' || a[i - 4] != 'm' && a[i - 4] != 'M' || a[i - 3] != 'p' && a[i - 3] != 'P' || a[i - 2] != 'o' && a[i - 2] != 'O' || a[i - 1] != 'r' && a[i - 1] != 'R' || a[i] != 't' && a[i] != 'T')) {
                matchlen = 6;
                mask |= 2;
            } else if (!(i < 5 || a[i - 5] != 'e' && a[i - 5] != 'E' || a[i - 4] != 'x' && a[i - 4] != 'X' || a[i - 3] != 'p' && a[i - 3] != 'P' || a[i - 2] != 'o' && a[i - 2] != 'O' || a[i - 1] != 'r' && a[i - 1] != 'R' || a[i] != 't' && a[i] != 'T')) {
                matchlen = 6;
                mask |= 3;
            } else {
                throw new IllegalArgumentException("invalid permission: " + actions);
            }
            seencomma = false;
            while (i >= matchlen && !seencomma) {
                switch (a[i - matchlen]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + actions);
                    }
                }
                --i;
            }
            i -= matchlen;
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    public boolean implies(Permission p) {
        if (p instanceof PackagePermission) {
            PackagePermission target = (PackagePermission)p;
            return (this.action_mask & target.action_mask) == target.action_mask && super.implies(p);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            if ((this.action_mask & 1) == 1) {
                sb.append(EXPORT);
                comma = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(IMPORT);
            }
            this.actions = sb.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new PackagePermissionCollection();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PackagePermission)) {
            return false;
        }
        PackagePermission p = (PackagePermission)obj;
        return this.action_mask == p.action_mask && this.getName().equals(p.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(PackagePermission.getMask(this.actions));
    }
}

