/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.helpers.BubbleSort;

public class BubbleSortTest {
    @Test
    public void testSmoke() {
        int[] a = new int[]{5, 3, 2, 7};
        BubbleSort.sort(a);
        int i = 0;
        Assert.assertEquals((long)2L, (long)a[i++]);
        Assert.assertEquals((long)3L, (long)a[i++]);
        Assert.assertEquals((long)5L, (long)a[i++]);
        Assert.assertEquals((long)7L, (long)a[i++]);
    }

    @Test
    public void testEmpty() {
        int[] a = new int[]{};
        BubbleSort.sort(a);
    }

    @Test
    public void testSorted() {
        int[] a = new int[]{3, 30, 300, 3000};
        BubbleSort.sort(a);
        int i = 0;
        Assert.assertEquals((long)3L, (long)a[i++]);
        Assert.assertEquals((long)30L, (long)a[i++]);
        Assert.assertEquals((long)300L, (long)a[i++]);
        Assert.assertEquals((long)3000L, (long)a[i++]);
    }

    @Test
    public void testInverted() {
        int[] a = new int[]{3000, 300, 30, 3};
        BubbleSort.sort(a);
        int i = 0;
        Assert.assertEquals((long)3L, (long)a[i++]);
        Assert.assertEquals((long)30L, (long)a[i++]);
        Assert.assertEquals((long)300L, (long)a[i++]);
        Assert.assertEquals((long)3000L, (long)a[i++]);
    }

    @Test
    public void testWithSameEntry() {
        int[] a = new int[]{10, 20, 10, 20};
        BubbleSort.sort(a);
        int i = 0;
        Assert.assertEquals((long)10L, (long)a[i++]);
        Assert.assertEquals((long)10L, (long)a[i++]);
        Assert.assertEquals((long)20L, (long)a[i++]);
        Assert.assertEquals((long)20L, (long)a[i++]);
    }

    @Test
    public void testRandom() {
        int len = 100;
        Random random = new Random(156L);
        int[] a = new int[len];
        int[] witness = new int[len];
        for (int i = 0; i < len; ++i) {
            int r;
            a[i] = r = random.nextInt();
            witness[i] = r;
        }
        BubbleSort.sort(a);
        Arrays.sort(witness);
        Assert.assertTrue((boolean)Arrays.equals(witness, a));
    }
}

