/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpGeneratorServerTest {
    @Test
    public void test09() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        ByteBuffer content = BufferUtil.toBuffer((String)"0123456789");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, content, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_0_9, 200, null, new HttpFields(), 10L);
        info.getFields().add("Content-Type", "test/data");
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, false, null, null, content, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String response = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        response = response + BufferUtil.toString((ByteBuffer)content);
        BufferUtil.clear((ByteBuffer)content);
        result = gen.generateResponse(null, false, null, null, content, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.SHUTDOWN_OUT, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertEquals((long)10L, (long)gen.getContentPrepared());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"200 OK")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length: 10")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"0123456789"));
    }

    @Test
    public void testSimple() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        ByteBuffer content = BufferUtil.toBuffer((String)"0123456789");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, content, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), 10L);
        info.getFields().add("Content-Type", "test/data");
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, false, null, null, content, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        result = gen.generateResponse(info, false, header, null, content, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String response = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        response = response + BufferUtil.toString((ByteBuffer)content);
        BufferUtil.clear((ByteBuffer)content);
        result = gen.generateResponse(null, false, null, null, content, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertEquals((long)10L, (long)gen.getContentPrepared());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 10"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0123456789"));
    }

    @Test
    public void testHeaderOverflow() throws Exception {
        HttpGenerator gen = new HttpGenerator();
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 302, null, new HttpFields(), 0L);
        info.getFields().add("Location", "http://somewhere/else");
        HttpGenerator.Result result = gen.generateResponse(info, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        ByteBuffer header = BufferUtil.allocate((int)16);
        result = gen.generateResponse(info, false, header, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.HEADER_OVERFLOW, (Object)result);
        header = BufferUtil.allocate((int)8096);
        result = gen.generateResponse(info, false, header, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String response = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertEquals((long)0L, (long)gen.getContentPrepared());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 302 Found"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Location: http://somewhere/else"));
    }

    @Test
    public void test204() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        ByteBuffer content = BufferUtil.toBuffer((String)"0123456789");
        HttpGenerator gen = new HttpGenerator();
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 204, "Foo", new HttpFields(), 10L);
        info.getFields().add("Content-Type", "test/data");
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        HttpGenerator.Result result = gen.generateResponse(info, false, header, null, content, true);
        Assertions.assertEquals((Object)gen.isNoContent(), (Object)true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String responseheaders = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, content, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        MatcherAssert.assertThat((Object)responseheaders, (Matcher)Matchers.containsString((String)"HTTP/1.1 204 Foo"));
        MatcherAssert.assertThat((Object)responseheaders, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)responseheaders, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length: 10")));
    }

    @Test
    public void testComplexChars() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        ByteBuffer content = BufferUtil.toBuffer((String)"0123456789");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, content, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, "\u00d8\u00c6", new HttpFields(), 10L);
        info.getFields().add("Content-Type", "test/data;\r\nextra=value");
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, false, null, null, content, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        result = gen.generateResponse(info, false, header, null, content, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String response = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        response = response + BufferUtil.toString((ByteBuffer)content);
        BufferUtil.clear((ByteBuffer)content);
        result = gen.generateResponse(null, false, null, null, content, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertEquals((long)10L, (long)gen.getContentPrepared());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 \u00d8\u00c6"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Type: test/data;  extra=value"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 10"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0123456789"));
    }

    @Test
    public void testSendServerXPoweredBy() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), -1L);
        HttpFields fields = new HttpFields();
        fields.add(HttpHeader.SERVER, "SomeServer");
        fields.add(HttpHeader.X_POWERED_BY, "SomePower");
        MetaData.Response infoF = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, fields, -1L);
        HttpGenerator gen = new HttpGenerator(true, true);
        gen.generateResponse(info, false, header, null, null, true);
        String head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Server: Jetty(9.x.x)"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"X-Powered-By: Jetty(9.x.x)"));
        gen.reset();
        gen.generateResponse(infoF, false, header, null, null, true);
        head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Server: Jetty(9.x.x)")));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Server: SomeServer"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"X-Powered-By: Jetty(9.x.x)"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"X-Powered-By: SomePower"));
        gen.reset();
        gen = new HttpGenerator(false, false);
        gen.generateResponse(info, false, header, null, null, true);
        head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Server: Jetty(9.x.x)")));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"X-Powered-By: Jetty(9.x.x)")));
        gen.reset();
        gen.generateResponse(infoF, false, header, null, null, true);
        head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Server: Jetty(9.x.x)")));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Server: SomeServer"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"X-Powered-By: Jetty(9.x.x)")));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"X-Powered-By: SomePower"));
        gen.reset();
    }

    @Test
    public void testResponseIncorrectContentLength() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), 10L);
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        info.getFields().add("Content-Length", "11");
        result = gen.generateResponse(info, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        BadMessageException e = (BadMessageException)Assertions.assertThrows(BadMessageException.class, () -> gen.generateResponse(info, false, header, null, null, true));
        Assertions.assertEquals((int)500, (int)e._code);
    }

    @Test
    public void testResponseNoContentPersistent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), 0L);
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        result = gen.generateResponse(info, false, header, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertEquals((long)0L, (long)gen.getContentPrepared());
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Content-Length: 0"));
    }

    @Test
    public void testResponseKnownNoContentNotPersistent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), 0L);
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        info.getFields().add("Connection", "close");
        result = gen.generateResponse(info, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        result = gen.generateResponse(info, false, header, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.SHUTDOWN_OUT, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertEquals((long)0L, (long)gen.getContentPrepared());
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Connection: close"));
    }

    @Test
    public void testResponseUpgrade() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)8096);
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 101, null, new HttpFields(), -1L);
        info.getFields().add("Upgrade", "WebSocket");
        info.getFields().add("Connection", "Upgrade");
        info.getFields().add("Sec-WebSocket-Accept", "123456789==");
        result = gen.generateResponse(info, false, header, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String head = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(info, false, null, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        Assertions.assertEquals((long)0L, (long)gen.getContentPrepared());
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.startsWith((String)"HTTP/1.1 101 Switching Protocols"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Upgrade: WebSocket\r\n"));
        MatcherAssert.assertThat((Object)head, (Matcher)Matchers.containsString((String)"Connection: Upgrade\r\n"));
    }

    @Test
    public void testResponseWithChunkedContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer chunk = BufferUtil.allocate((int)12);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World! ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog. ");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), -1L);
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(info, false, header, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, false, null, chunk, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.endsWith((String)"\r\n\r\nD\r\nHello World! \r\n2E\r\nThe quick brown fox jumped over the lazy dog. \r\n0\r\n\r\n"));
    }

    @Test
    public void testResponseWithHintedChunkedContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer chunk = BufferUtil.allocate((int)12);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World! ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog. ");
        HttpGenerator gen = new HttpGenerator();
        gen.setPersistent(false);
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), -1L);
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        info.getFields().add(HttpHeader.TRANSFER_ENCODING, HttpHeaderValue.CHUNKED);
        result = gen.generateResponse(info, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(info, false, header, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, false, null, null, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_CHUNK, (Object)result);
        result = gen.generateResponse(null, false, null, chunk, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.SHUTDOWN_OUT, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.endsWith((String)"\r\n\r\nD\r\nHello World! \r\n2E\r\nThe quick brown fox jumped over the lazy dog. \r\n0\r\n\r\n"));
    }

    @Test
    public void testResponseWithContentAndTrailer() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer chunk = BufferUtil.allocate((int)12);
        ByteBuffer trailer = BufferUtil.allocate((int)4096);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World! ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog. ");
        HttpGenerator gen = new HttpGenerator();
        gen.setPersistent(false);
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), -1L);
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        info.getFields().add(HttpHeader.TRANSFER_ENCODING, HttpHeaderValue.CHUNKED);
        info.setTrailerSupplier((Supplier)new Supplier<HttpFields>(){

            @Override
            public HttpFields get() {
                HttpFields trailer = new HttpFields();
                trailer.add("T-Name0", "T-ValueA");
                trailer.add("T-Name0", "T-ValueB");
                trailer.add("T-Name1", "T-ValueC");
                return trailer;
            }
        });
        result = gen.generateResponse(info, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(info, false, header, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, false, null, null, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_CHUNK, (Object)result);
        result = gen.generateResponse(null, false, null, chunk, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)chunk);
        BufferUtil.clear((ByteBuffer)chunk);
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_CHUNK_TRAILER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, false, null, trailer, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)trailer);
        BufferUtil.clear((ByteBuffer)trailer);
        result = gen.generateResponse(null, false, null, trailer, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.SHUTDOWN_OUT, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.endsWith((String)"\r\n\r\nD\r\nHello World! \r\n2E\r\nThe quick brown fox jumped over the lazy dog. \r\n0\r\nT-Name0: T-ValueA\r\nT-Name0: T-ValueB\r\nT-Name1: T-ValueC\r\n\r\n"));
    }

    @Test
    public void testResponseWithTrailer() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer chunk = BufferUtil.allocate((int)12);
        ByteBuffer trailer = BufferUtil.allocate((int)4096);
        HttpGenerator gen = new HttpGenerator();
        gen.setPersistent(false);
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), -1L);
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        info.getFields().add(HttpHeader.TRANSFER_ENCODING, HttpHeaderValue.CHUNKED);
        info.setTrailerSupplier((Supplier)new Supplier<HttpFields>(){

            @Override
            public HttpFields get() {
                HttpFields trailer = new HttpFields();
                trailer.add("T-Name0", "T-ValueA");
                trailer.add("T-Name0", "T-ValueB");
                trailer.add("T-Name1", "T-ValueC");
                return trailer;
            }
        });
        result = gen.generateResponse(info, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(info, false, header, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_CHUNK_TRAILER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, false, null, chunk, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_CHUNK_TRAILER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, false, null, trailer, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)trailer);
        BufferUtil.clear((ByteBuffer)trailer);
        result = gen.generateResponse(null, false, null, trailer, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.SHUTDOWN_OUT, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.endsWith((String)"\r\n\r\n0\r\nT-Name0: T-ValueA\r\nT-Name0: T-ValueB\r\nT-Name1: T-ValueC\r\n\r\n"));
    }

    @Test
    public void testResponseWithKnownContentLengthFromMetaData() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World! ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog. ");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), 59L);
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(info, false, header, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, false, null, null, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"chunked")));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 59"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n\r\nHello World! The quick brown fox jumped over the lazy dog. "));
    }

    @Test
    public void testResponseWithKnownContentLengthFromHeader() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World! ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog. ");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(null, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), -1L);
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        info.getFields().add("Content-Length", "" + (content0.remaining() + content1.remaining()));
        result = gen.generateResponse(info, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(info, false, header, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        String out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, false, null, null, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"chunked")));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 59"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n\r\nHello World! The quick brown fox jumped over the lazy dog. "));
    }

    @Test
    public void test100ThenResponseWithContent() throws Exception {
        ByteBuffer header = BufferUtil.allocate((int)4096);
        ByteBuffer content0 = BufferUtil.toBuffer((String)"Hello World! ");
        ByteBuffer content1 = BufferUtil.toBuffer((String)"The quick brown fox jumped over the lazy dog. ");
        HttpGenerator gen = new HttpGenerator();
        HttpGenerator.Result result = gen.generateResponse(HttpGenerator.CONTINUE_100_INFO, false, null, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(HttpGenerator.CONTINUE_100_INFO, false, header, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING_1XX, (Object)gen.getState());
        String out = BufferUtil.toString((ByteBuffer)header);
        result = gen.generateResponse(null, false, null, null, null, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 100 Continue"));
        result = gen.generateResponse(null, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_INFO, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_1, 200, null, new HttpFields(), (long)(BufferUtil.length((ByteBuffer)content0) + BufferUtil.length((ByteBuffer)content1)));
        info.getFields().add("Last-Modified", DateGenerator.__01Jan1970);
        result = gen.generateResponse(info, false, null, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.NEED_HEADER, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.START, (Object)gen.getState());
        result = gen.generateResponse(info, false, header, null, content0, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = BufferUtil.toString((ByteBuffer)header);
        BufferUtil.clear((ByteBuffer)header);
        out = out + BufferUtil.toString((ByteBuffer)content0);
        BufferUtil.clear((ByteBuffer)content0);
        result = gen.generateResponse(null, false, null, null, content1, false);
        Assertions.assertEquals((Object)HttpGenerator.Result.FLUSH, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMMITTED, (Object)gen.getState());
        out = out + BufferUtil.toString((ByteBuffer)content1);
        BufferUtil.clear((ByteBuffer)content1);
        result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.CONTINUE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.COMPLETING, (Object)gen.getState());
        result = gen.generateResponse(null, false, null, null, null, true);
        Assertions.assertEquals((Object)HttpGenerator.Result.DONE, (Object)result);
        Assertions.assertEquals((Object)HttpGenerator.State.END, (Object)gen.getState());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Last-Modified: Thu, 01 Jan 1970 00:00:00 GMT"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"chunked")));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"Content-Length: 59"));
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"\r\n\r\nHello World! The quick brown fox jumped over the lazy dog. "));
    }

    @Test
    public void testConnectionKeepAliveWithAdditionalCustomValue() throws Exception {
        HttpGenerator generator = new HttpGenerator();
        HttpFields fields = new HttpFields();
        fields.put(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
        String customValue = "test";
        fields.add(HttpHeader.CONNECTION, customValue);
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_0, 200, "OK", fields, -1L);
        ByteBuffer header = BufferUtil.allocate((int)4096);
        HttpGenerator.Result result = generator.generateResponse(info, false, header, null, null, true);
        Assertions.assertSame((Object)HttpGenerator.Result.FLUSH, (Object)result);
        String headers = BufferUtil.toString((ByteBuffer)header);
        MatcherAssert.assertThat((Object)headers, (Matcher)Matchers.containsString((String)HttpHeaderValue.KEEP_ALIVE.asString()));
        MatcherAssert.assertThat((Object)headers, (Matcher)Matchers.containsString((String)customValue));
    }

    @Test
    public void testKeepAliveWithClose() throws Exception {
        HttpGenerator generator = new HttpGenerator();
        HttpFields fields = new HttpFields();
        fields.put(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString() + ", other, " + HttpHeaderValue.CLOSE.asString());
        MetaData.Response info = new MetaData.Response(HttpVersion.HTTP_1_0, 200, "OK", fields, -1L);
        ByteBuffer header = BufferUtil.allocate((int)4096);
        HttpGenerator.Result result = generator.generateResponse(info, false, header, null, null, true);
        Assertions.assertSame((Object)HttpGenerator.Result.FLUSH, (Object)result);
        String headers = BufferUtil.toString((ByteBuffer)header);
        MatcherAssert.assertThat((Object)headers, (Matcher)Matchers.containsString((String)"Connection: other, close\r\n"));
        MatcherAssert.assertThat((Object)headers, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"keep-alive")));
    }
}

