/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.matchers;

import java.util.Locale;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class HttpFieldsContainsHeaderValue
extends TypeSafeMatcher<HttpFields> {
    private final String keyName;
    private final String value;

    public HttpFieldsContainsHeaderValue(String keyName, String value) {
        this.keyName = keyName;
        this.value = value;
    }

    public HttpFieldsContainsHeaderValue(HttpHeader header, String value) {
        this(header.asString(), value);
    }

    public void describeTo(Description description) {
        description.appendText("expecting http header ").appendValue((Object)this.keyName).appendText(" with value ").appendValue((Object)this.value);
    }

    protected boolean matchesSafely(HttpFields fields) {
        HttpField field = fields.getField(this.keyName);
        if (field == null) {
            return false;
        }
        if (field.contains(this.value)) {
            return true;
        }
        if (this.value == field.getValue()) {
            return true;
        }
        String lcValue = this.value.toLowerCase(Locale.ENGLISH);
        for (String value : field.getValues()) {
            if (!value.toLowerCase(Locale.ENGLISH).contains(lcValue)) continue;
            return true;
        }
        return false;
    }
}

