/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.AnnotationAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.AnnotationValueFilter;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;

public interface MethodAttributeAppender {
    public void apply(MethodVisitor var1, MethodDescription var2, AnnotationValueFilter var3);

    public static class Compound
    implements MethodAttributeAppender {
        private final List<? extends MethodAttributeAppender> methodAttributeAppenders;

        public Compound(MethodAttributeAppender ... methodAttributeAppender) {
            this(Arrays.asList(methodAttributeAppender));
        }

        public Compound(List<? extends MethodAttributeAppender> methodAttributeAppenders) {
            this.methodAttributeAppenders = methodAttributeAppenders;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            for (MethodAttributeAppender methodAttributeAppender : this.methodAttributeAppenders) {
                methodAttributeAppender.apply(methodVisitor, methodDescription, annotationValueFilter);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodAttributeAppenders.equals(((Compound)other).methodAttributeAppenders);
        }

        public int hashCode() {
            return this.methodAttributeAppenders.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.Compound{methodAttributeAppenders=" + this.methodAttributeAppenders + '}';
        }
    }

    public static class ForReceiverType
    implements MethodAttributeAppender,
    Factory {
        private final TypeDescription.Generic receiverType;

        public ForReceiverType(TypeDescription.Generic receiverType) {
            this.receiverType = receiverType;
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            this.receiverType.accept(AnnotationAppender.ForTypeAnnotations.ofReceiverType(new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethod(methodVisitor)), annotationValueFilter));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.receiverType.equals(((ForReceiverType)other).receiverType);
        }

        public int hashCode() {
            return this.receiverType.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.ForReceiverType{receiverType=" + this.receiverType + '}';
        }
    }

    public static class Explicit
    implements MethodAttributeAppender,
    Factory {
        private final Target target;
        private final List<? extends AnnotationDescription> annotations;

        public Explicit(int parameterIndex, List<? extends AnnotationDescription> annotations) {
            this(new Target.OnMethodParameter(parameterIndex), annotations);
        }

        public Explicit(List<? extends AnnotationDescription> annotations) {
            this(Target.OnMethod.INSTANCE, annotations);
        }

        protected Explicit(Target target, List<? extends AnnotationDescription> annotations) {
            this.target = target;
            this.annotations = annotations;
        }

        public static Factory of(MethodDescription methodDescription) {
            ParameterList<?> parameters = methodDescription.getParameters();
            ArrayList<Explicit> methodAttributeAppenders = new ArrayList<Explicit>(parameters.size() + 1);
            methodAttributeAppenders.add(new Explicit(methodDescription.getDeclaredAnnotations()));
            for (ParameterDescription parameter : parameters) {
                methodAttributeAppenders.add(new Explicit(parameter.getIndex(), (List<? extends AnnotationDescription>)parameter.getDeclaredAnnotations()));
            }
            return new Factory.Compound(methodAttributeAppenders);
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender appender = new AnnotationAppender.Default(this.target.make(methodVisitor, methodDescription));
            for (AnnotationDescription annotationDescription : this.annotations) {
                appender = appender.append(annotationDescription, annotationValueFilter);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotations.equals(((Explicit)other).annotations) && this.target.equals(((Explicit)other).target);
        }

        public int hashCode() {
            return 31 * this.annotations.hashCode() + this.target.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.Explicit{annotations=" + this.annotations + ", target=" + this.target + '}';
        }

        protected static interface Target {
            public AnnotationAppender.Target make(MethodVisitor var1, MethodDescription var2);

            public static class OnMethodParameter
            implements Target {
                private final int parameterIndex;

                protected OnMethodParameter(int parameterIndex) {
                    this.parameterIndex = parameterIndex;
                }

                @Override
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    if (this.parameterIndex >= methodDescription.getParameters().size()) {
                        throw new IllegalArgumentException("Method " + methodDescription + " has less then " + this.parameterIndex + " parameters");
                    }
                    return new AnnotationAppender.Target.OnMethodParameter(methodVisitor, this.parameterIndex);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.parameterIndex == ((OnMethodParameter)other).parameterIndex;
                }

                public int hashCode() {
                    return this.parameterIndex;
                }

                public String toString() {
                    return "MethodAttributeAppender.Explicit.Target.OnMethodParameter{parameterIndex=" + this.parameterIndex + '}';
                }
            }

            public static enum OnMethod implements Target
            {
                INSTANCE;


                @Override
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    return new AnnotationAppender.Target.OnMethod(methodVisitor);
                }

                public String toString() {
                    return "MethodAttributeAppender.Explicit.Target.OnMethod." + this.name();
                }
            }
        }
    }

    public static enum ForInstrumentedMethod implements MethodAttributeAppender,
    Factory
    {
        EXCLUDING_RECEIVER{

            @Override
            protected AnnotationAppender appendReceiver(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, MethodDescription methodDescription) {
                return annotationAppender;
            }
        }
        ,
        INCLUDING_RECEIVER{

            @Override
            protected AnnotationAppender appendReceiver(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, MethodDescription methodDescription) {
                TypeDescription.Generic receiverType = methodDescription.getReceiverType();
                return receiverType == null ? annotationAppender : receiverType.accept(AnnotationAppender.ForTypeAnnotations.ofReceiverType(annotationAppender, annotationValueFilter));
            }
        };


        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethod(methodVisitor));
            annotationAppender = methodDescription.getReturnType().accept(AnnotationAppender.ForTypeAnnotations.ofMethodReturnType(annotationAppender, annotationValueFilter));
            annotationAppender = AnnotationAppender.ForTypeAnnotations.ofTypeVariable(annotationAppender, annotationValueFilter, false, methodDescription.getTypeVariables());
            for (AnnotationDescription annotation : methodDescription.getDeclaredAnnotations()) {
                annotationAppender = annotationAppender.append(annotation, annotationValueFilter);
            }
            for (ParameterDescription parameterDescription : methodDescription.getParameters()) {
                AnnotationAppender parameterAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethodParameter(methodVisitor, parameterDescription.getIndex()));
                parameterAppender = parameterDescription.getType().accept(AnnotationAppender.ForTypeAnnotations.ofMethodParameterType(parameterAppender, annotationValueFilter, parameterDescription.getIndex()));
                for (AnnotationDescription annotation : parameterDescription.getDeclaredAnnotations()) {
                    parameterAppender = parameterAppender.append(annotation, annotationValueFilter);
                }
            }
            annotationAppender = this.appendReceiver(annotationAppender, annotationValueFilter, methodDescription);
            int exceptionTypeIndex = 0;
            for (TypeDescription.Generic exceptionType : methodDescription.getExceptionTypes()) {
                annotationAppender = exceptionType.accept(AnnotationAppender.ForTypeAnnotations.ofExceptionType(annotationAppender, annotationValueFilter, exceptionTypeIndex++));
            }
        }

        protected abstract AnnotationAppender appendReceiver(AnnotationAppender var1, AnnotationValueFilter var2, MethodDescription var3);

        public String toString() {
            return "MethodAttributeAppender.ForInstrumentedMethod." + this.name();
        }
    }

    public static interface Factory {
        public MethodAttributeAppender make(TypeDescription var1);

        public static class Compound
        implements Factory {
            private final List<? extends Factory> factories;

            public Compound(Factory ... factory) {
                this(Arrays.asList(factory));
            }

            public Compound(List<? extends Factory> factories) {
                this.factories = factories;
            }

            @Override
            public MethodAttributeAppender make(TypeDescription typeDescription) {
                ArrayList<MethodAttributeAppender> methodAttributeAppenders = new ArrayList<MethodAttributeAppender>(this.factories.size());
                for (Factory factory : this.factories) {
                    methodAttributeAppenders.add(factory.make(typeDescription));
                }
                return new nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.attribute.MethodAttributeAppender$Compound(methodAttributeAppenders);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.factories.equals(((Compound)other).factories);
            }

            public int hashCode() {
                return this.factories.hashCode();
            }

            public String toString() {
                return "MethodAttributeAppender.Factory.Compound{factories=" + this.factories + '}';
            }
        }
    }

    public static enum NoOp implements MethodAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
        }

        public String toString() {
            return "MethodAttributeAppender.NoOp." + this.name();
        }
    }
}

