/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDefinition;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.MethodDelegationBinder;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation.RuntimeType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.FieldAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface FieldValue {
    public String value();

    public Class<?> definingType() default void.class;

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<FieldValue>
    {
        INSTANCE;

        private static final MethodDescription.InDefinedShape DEFINING_TYPE;
        private static final MethodDescription.InDefinedShape FIELD_NAME;

        @Override
        public Class<FieldValue> getHandledType() {
            return FieldValue.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<FieldValue> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
            FieldLocator.Resolution resolution = FieldLocator.of(annotation.getValue(DEFINING_TYPE, TypeDescription.class), implementationTarget.getInstrumentedType()).resolve(annotation.getValue(FIELD_NAME, String.class), source.isStatic());
            if (resolution.isResolved()) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(resolution.getFieldDescription().isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.REFERENCE.loadOffset(0), FieldAccess.forField(resolution.getFieldDescription()).getter(), assigner.assign(resolution.getFieldDescription().getType(), target.getType(), RuntimeType.Verifier.check(target)));
                return stackManipulation.isValid() ? new MethodDelegationBinder.ParameterBinding.Anonymous(stackManipulation) : MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
        }

        public String toString() {
            return "FieldValue.Binder." + this.name();
        }

        static {
            MethodList<MethodDescription.InDefinedShape> methodList = new TypeDescription.ForLoadedType(FieldValue.class).getDeclaredMethods();
            DEFINING_TYPE = (MethodDescription.InDefinedShape)((MethodList)methodList.filter(ElementMatchers.named("definingType"))).getOnly();
            FIELD_NAME = (MethodDescription.InDefinedShape)((MethodList)methodList.filter(ElementMatchers.named("value"))).getOnly();
        }

        protected static abstract class FieldLocator {
            protected FieldLocator() {
            }

            protected static FieldLocator of(TypeDescription typeDescription, TypeDescription instrumentedType) {
                return typeDescription.represents(Void.TYPE) ? new ForFieldInHierarchy(instrumentedType) : ForSpecificType.of(typeDescription, instrumentedType);
            }

            protected abstract Resolution resolve(String var1, boolean var2);

            protected static class Impossible
            extends FieldLocator {
                protected Impossible() {
                }

                @Override
                protected Resolution resolve(String fieldName, boolean staticMethod) {
                    return Resolution.Unresolved.INSTANCE;
                }

                public int hashCode() {
                    return 31;
                }

                public boolean equals(Object other) {
                    return other != null && other.getClass() == this.getClass();
                }

                public String toString() {
                    return "FieldValue.Binder.FieldLocator.Impossible{}";
                }
            }

            protected static class ForSpecificType
            extends FieldLocator {
                private final TypeDescription typeDescription;
                private final TypeDescription instrumentedType;

                protected ForSpecificType(TypeDescription typeDescription, TypeDescription instrumentedType) {
                    this.typeDescription = typeDescription;
                    this.instrumentedType = instrumentedType;
                }

                protected static FieldLocator of(TypeDescription typeDescription, TypeDescription instrumentedType) {
                    if (typeDescription.isInterface() || typeDescription.isPrimitive() || typeDescription.isArray()) {
                        throw new IllegalStateException(typeDescription + " is not capable of declaring a field");
                    }
                    return instrumentedType.isAssignableTo(typeDescription) ? new ForSpecificType(typeDescription, instrumentedType) : new Impossible();
                }

                @Override
                protected Resolution resolve(String fieldName, boolean staticMethod) {
                    FieldList fieldList = (FieldList)this.typeDescription.getDeclaredFields().filter(ElementMatchers.named(fieldName));
                    if (fieldList.size() > 1) {
                        throw new IllegalStateException("Ambiguous fields: " + fieldList);
                    }
                    return fieldList.isEmpty() || !((FieldDescription)fieldList.getOnly()).isVisibleTo(this.instrumentedType) || staticMethod && !((FieldDescription)fieldList.getOnly()).isStatic() ? Resolution.Unresolved.INSTANCE : new Resolution.Resolved((FieldDescription)fieldList.getOnly());
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ForSpecificType)) {
                        return false;
                    }
                    ForSpecificType that = (ForSpecificType)other;
                    return this.typeDescription.equals(that.typeDescription) && this.instrumentedType.equals(that.instrumentedType);
                }

                public int hashCode() {
                    int result = this.typeDescription.hashCode();
                    result = 31 * result + this.instrumentedType.hashCode();
                    return result;
                }

                public String toString() {
                    return "FieldValue.Binder.FieldLocator.ForSpecificType{typeDescription=" + this.typeDescription + ", instrumentedType=" + this.instrumentedType + '}';
                }
            }

            protected static class ForFieldInHierarchy
            extends FieldLocator {
                private final TypeDescription instrumentedType;

                protected ForFieldInHierarchy(TypeDescription instrumentedType) {
                    this.instrumentedType = instrumentedType;
                }

                @Override
                protected Resolution resolve(String fieldName, boolean staticMethod) {
                    for (TypeDefinition currentType : this.instrumentedType) {
                        FieldList fieldList = (FieldList)currentType.getDeclaredFields().filter(ElementMatchers.named(fieldName));
                        if (fieldList.size() > 1) {
                            throw new IllegalStateException("Ambiguous fields: " + fieldList);
                        }
                        if (fieldList.isEmpty() || !((FieldDescription)fieldList.getOnly()).isVisibleTo(this.instrumentedType) || staticMethod && !((FieldDescription)fieldList.getOnly()).isStatic()) continue;
                        return new Resolution.Resolved((FieldDescription)fieldList.getOnly());
                    }
                    return Resolution.Unresolved.INSTANCE;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ForFieldInHierarchy)) {
                        return false;
                    }
                    ForFieldInHierarchy that = (ForFieldInHierarchy)other;
                    return this.instrumentedType.equals(that.instrumentedType);
                }

                public int hashCode() {
                    return this.instrumentedType.hashCode();
                }

                public String toString() {
                    return "FieldValue.Binder.FieldLocator.ForFieldInHierarchy{instrumentedType=" + this.instrumentedType + '}';
                }
            }

            protected static interface Resolution {
                public FieldDescription getFieldDescription();

                public boolean isResolved();

                public static class Resolved
                implements Resolution {
                    private final FieldDescription fieldDescription;

                    public Resolved(FieldDescription fieldDescription) {
                        this.fieldDescription = fieldDescription;
                    }

                    @Override
                    public FieldDescription getFieldDescription() {
                        return this.fieldDescription;
                    }

                    @Override
                    public boolean isResolved() {
                        return true;
                    }

                    public boolean equals(Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof Resolved)) {
                            return false;
                        }
                        Resolved resolved = (Resolved)other;
                        return this.fieldDescription.equals(resolved.fieldDescription);
                    }

                    public int hashCode() {
                        return this.fieldDescription.hashCode();
                    }

                    public String toString() {
                        return "FieldValue.Binder.FieldLocator.Resolution.Resolved{fieldDescription=" + this.fieldDescription + '}';
                    }
                }

                public static enum Unresolved implements Resolution
                {
                    INSTANCE;


                    @Override
                    public FieldDescription getFieldDescription() {
                        throw new IllegalStateException("Cannot resolve field for unresolved lookup");
                    }

                    @Override
                    public boolean isResolved() {
                        return false;
                    }

                    public String toString() {
                        return "FieldValue.Binder.FieldLocator.Resolution.Unresolved." + this.name();
                    }
                }
            }
        }
    }
}

