/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.collection;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackSize;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;

public enum ArrayAccess {
    BYTE(51, 84, StackSize.SINGLE),
    SHORT(53, 86, StackSize.SINGLE),
    CHARACTER(52, 85, StackSize.SINGLE),
    INTEGER(46, 79, StackSize.SINGLE),
    LONG(47, 80, StackSize.DOUBLE),
    FLOAT(48, 81, StackSize.SINGLE),
    DOUBLE(49, 82, StackSize.DOUBLE),
    REFERENCE(50, 83, StackSize.SINGLE);

    private final int loadOpcode;
    private final int storeOpcode;
    private final StackSize stackSize;

    private ArrayAccess(int loadOpcode, int storeOpcode, StackSize stackSize) {
        this.loadOpcode = loadOpcode;
        this.storeOpcode = storeOpcode;
        this.stackSize = stackSize;
    }

    public static ArrayAccess of(TypeDescription componentType) {
        if (componentType.represents(Boolean.TYPE) || componentType.represents(Byte.TYPE)) {
            return BYTE;
        }
        if (componentType.represents(Short.TYPE)) {
            return SHORT;
        }
        if (componentType.represents(Character.TYPE)) {
            return CHARACTER;
        }
        if (componentType.represents(Integer.TYPE)) {
            return INTEGER;
        }
        if (componentType.represents(Long.TYPE)) {
            return LONG;
        }
        if (componentType.represents(Float.TYPE)) {
            return FLOAT;
        }
        if (componentType.represents(Double.TYPE)) {
            return DOUBLE;
        }
        if (componentType.represents(Void.TYPE)) {
            throw new IllegalArgumentException("void is no legal array type");
        }
        return REFERENCE;
    }

    public StackManipulation load() {
        return new Loader();
    }

    public StackManipulation store() {
        return new Putter();
    }

    public String toString() {
        return "ArrayAccess." + this.name();
    }

    protected class Putter
    implements StackManipulation {
        protected Putter() {
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitInsn(ArrayAccess.this.storeOpcode);
            return ArrayAccess.this.stackSize.toDecreasingSize().aggregate(new StackManipulation.Size(-2, 0));
        }

        private ArrayAccess getArrayAccess() {
            return ArrayAccess.this;
        }

        public int hashCode() {
            return ArrayAccess.this.hashCode();
        }

        public boolean equals(Object other) {
            return this == other || other != null && other.getClass() == this.getClass() && this.getArrayAccess() == ((Putter)other).getArrayAccess();
        }

        public String toString() {
            return "ArrayAccess.Putter{arrayAccess=" + (Object)((Object)ArrayAccess.this) + '}';
        }
    }

    protected class Loader
    implements StackManipulation {
        protected Loader() {
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitInsn(ArrayAccess.this.loadOpcode);
            return ArrayAccess.this.stackSize.toIncreasingSize().aggregate(new StackManipulation.Size(-2, 0));
        }

        private ArrayAccess getArrayAccess() {
            return ArrayAccess.this;
        }

        public int hashCode() {
            return ArrayAccess.this.hashCode();
        }

        public boolean equals(Object other) {
            return this == other || other != null && other.getClass() == this.getClass() && this.getArrayAccess() == ((Loader)other).getArrayAccess();
        }

        public String toString() {
            return "ArrayAccess.Loader{arrayAccess=" + (Object)((Object)ArrayAccess.this) + '}';
        }
    }
}

