/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.perf;

import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;
import org.eclipse.jetty.toolchain.perf.MeasureConverter;

public class HistogramSnapshot
implements MeasureConverter {
    private final Histogram histogram;
    private final long buckets;
    private final String name;
    private final String unit;
    private final MeasureConverter converter;

    public HistogramSnapshot(Histogram histogram) {
        this(histogram, 32L);
    }

    public HistogramSnapshot(Histogram histogram, long buckets) {
        this(histogram, buckets, "Measures", "ms", null);
    }

    public HistogramSnapshot(Histogram histogram, long buckets, String name, String unit, MeasureConverter converter) {
        this.histogram = histogram;
        this.buckets = buckets;
        this.name = name;
        this.unit = unit;
        this.converter = converter == null ? this : converter;
    }

    @Override
    public long convert(long measure) {
        return TimeUnit.NANOSECONDS.toMillis(measure);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        long range = this.histogram.getMaxValue();
        long maxBucketCount = 0L;
        for (HistogramIterationValue value : this.histogram.linearBucketValues(range / this.buckets)) {
            long bucketCount = value.getCountAddedInThisIterationStep();
            if (bucketCount <= maxBucketCount) continue;
            maxBucketCount = bucketCount;
        }
        double previousPercentile = 0.0;
        for (HistogramIterationValue value : this.histogram.linearBucketValues(range / this.buckets)) {
            long j;
            long point;
            long bucketCount = value.getCountAddedInThisIterationStep();
            long l = point = maxBucketCount == 0L ? 0L : Math.round((double)bucketCount / (double)maxBucketCount * (double)this.buckets);
            if (point == this.buckets) {
                --point;
            }
            for (j = 0L; j < point; ++j) {
                builder.append(" ");
            }
            builder.append("@");
            for (j = point + 1L; j < this.buckets; ++j) {
                builder.append(" ");
            }
            builder.append("  _  ");
            builder.append(String.format("%,d %s (%d, %.2f%%)", this.converter.convert(value.getValueIteratedTo()), this.unit, bucketCount, 100.0 * (double)bucketCount / (double)this.histogram.getTotalCount()));
            double percentile = value.getPercentile();
            if (previousPercentile < 50.0 && percentile >= 50.0) {
                builder.append(" ^50%");
            }
            if (previousPercentile < 85.0 && percentile >= 85.0) {
                builder.append(" ^85%");
            }
            if (previousPercentile < 95.0 && percentile >= 95.0) {
                builder.append(" ^95%");
            }
            if (previousPercentile < 99.0 && percentile >= 99.0) {
                builder.append(" ^99%");
            }
            if (previousPercentile < 99.9 && percentile >= 99.9) {
                builder.append(" ^99.9%");
            }
            previousPercentile = percentile;
            builder.append(System.lineSeparator());
        }
        builder.append(String.format("%s: %d samples | min/avg/50th%%/99th%%/max = %,d/%,d/%,d/%,d/%,d %s", this.name, this.histogram.getTotalCount(), this.converter.convert(this.histogram.getMinValue()), this.converter.convert(Math.round(this.histogram.getMean())), this.converter.convert(this.histogram.getValueAtPercentile(50.0)), this.converter.convert(this.histogram.getValueAtPercentile(99.0)), this.converter.convert(this.histogram.getMaxValue()), this.unit));
        return builder.toString();
    }
}

