/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.h2.java.Expr;
import org.h2.java.FieldObj;
import org.h2.java.MethodObj;
import org.h2.java.Statement;
import org.h2.java.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassObj {
    String superClassName;
    ArrayList<String> interfaceNames = new ArrayList();
    String name;
    boolean isInterface;
    boolean isPublic;
    boolean isPrimitive;
    int primitiveType;
    ArrayList<ClassObj> imports = new ArrayList();
    LinkedHashMap<String, FieldObj> instanceFields = new LinkedHashMap();
    LinkedHashMap<String, FieldObj> staticFields = new LinkedHashMap();
    LinkedHashMap<String, ArrayList<MethodObj>> methods = new LinkedHashMap();
    ArrayList<Statement> nativeCode = new ArrayList();
    int id;
    Type baseType = new Type();

    ClassObj() {
        this.baseType.classObj = this;
    }

    void addMethod(MethodObj methodObj) {
        ArrayList<MethodObj> arrayList = this.methods.get(methodObj.name);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.methods.put(methodObj.name, arrayList);
        } else {
            methodObj.name = methodObj.name + "_" + (arrayList.size() + 1);
        }
        arrayList.add(methodObj);
    }

    void addInstanceField(FieldObj fieldObj) {
        this.instanceFields.put(fieldObj.name, fieldObj);
    }

    void addStaticField(FieldObj fieldObj) {
        this.staticFields.put(fieldObj.name, fieldObj);
    }

    public String toString() {
        if (this.isPrimitive) {
            return "j" + this.name;
        }
        return this.name;
    }

    MethodObj getMethod(String string, ArrayList<Expr> arrayList) {
        ArrayList<MethodObj> arrayList2 = this.methods.get(string);
        if (arrayList2 == null) {
            throw new RuntimeException("Method not found: " + this.name);
        }
        if (arrayList2.size() == 1) {
            return arrayList2.get(0);
        }
        for (MethodObj methodObj : arrayList2) {
            if (!methodObj.isVarArgs && methodObj.parameters.size() != arrayList.size()) continue;
            boolean bl = true;
            int n = 0;
            for (FieldObj fieldObj : methodObj.parameters.values()) {
                Expr expr;
                Type type;
                if ((type = (expr = arrayList.get(n++)).getType()) == null) {
                    System.out.println(expr.getType());
                }
                if (type.equals(fieldObj.type)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return methodObj;
        }
        throw new RuntimeException("Method not found: " + this.name);
    }
}

