// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDevtoolsClientSharedMetrics_h
#define mozilla_GleanDevtoolsClientSharedMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace devtools_accessibility {
  /**
   * generated from devtools.accessibility.opened_count
   * Number of times the DevTools Accessibility tool has been opened. This metric was generated to correspond to the Legacy Telemetry scalar devtools.accessibility.opened_count.
   */
  constexpr impl::CounterMetric opened_count(1022);

  /**
   * generated from devtools.accessibility.picker_used_count
   * Number of times the picker tool has been used in DevTools Accessibility panel. This metric was generated to correspond to the Legacy Telemetry scalar devtools.accessibility.picker_used_count.
   */
  constexpr impl::CounterMetric picker_used_count(1023);
}

namespace devtools {
  /**
   * generated from devtools.aboutdebugging_opened_count
   * Number of times about:debugging has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_ABOUTDEBUGGING_OPENED_COUNT.
   */
  constexpr impl::CounterMetric aboutdebugging_opened_count(1029);

  /**
   * generated from devtools.aboutdebugging_time_active
   * How long has about:debugging been active? (seconds) (bug 1204601)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_ABOUTDEBUGGING_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric aboutdebugging_time_active(1030);

  /**
   * generated from devtools.accessibility_picker_time_active
   * How long has the picker tool in accessibility panel been active (seconds).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_ACCESSIBILITY_PICKER_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric accessibility_picker_time_active(1031);

  /**
   * generated from devtools.accessibility_service_time_active
   * How long has the platform accessibility been active (seconds) in accessibility panel.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_ACCESSIBILITY_SERVICE_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric accessibility_service_time_active(1032);

  /**
   * generated from devtools.accessibility_time_active
   * How long has the accessibility panel been active (seconds).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_ACCESSIBILITY_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric accessibility_time_active(1033);

  /**
   * generated from devtools.animationinspector_opened_count
   * Number of times the DevTools Animation Inspector has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_ANIMATIONINSPECTOR_OPENED_COUNT.
   */
  constexpr impl::CounterMetric animationinspector_opened_count(1034);

  /**
   * generated from devtools.animationinspector_time_active
   * How long has the animation inspector been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_ANIMATIONINSPECTOR_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric animationinspector_time_active(1035);

  /**
   * generated from devtools.browserconsole_opened_count
   * Number of times the DevTools Browser Console has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_BROWSERCONSOLE_OPENED_COUNT.
   */
  constexpr impl::CounterMetric browserconsole_opened_count(1036);

  /**
   * generated from devtools.browserconsole_time_active
   * How long has the browser console been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_BROWSERCONSOLE_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric browserconsole_time_active(1037);

  /**
   * generated from devtools.changesview_time_active
   * How long has the Changes panel been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_CHANGESVIEW_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric changesview_time_active(1038);

  /**
   * generated from devtools.compatibilityview_opened_count
   * Number of times about:debugging has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_COMPATIBILITYVIEW_OPENED_COUNT.
   */
  constexpr impl::CounterMetric compatibilityview_opened_count(1039);

  /**
   * generated from devtools.compatibilityview_time_active
   * How long has the compatibility view been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_COMPATIBILITYVIEW_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric compatibilityview_time_active(1040);

  /**
   * generated from devtools.computedview_opened_count
   * Number of times the DevTools Computed View has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_COMPUTEDVIEW_OPENED_COUNT.
   */
  constexpr impl::CounterMetric computedview_opened_count(1041);

  /**
   * generated from devtools.computedview_time_active
   * How long has the computed view been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_COMPUTEDVIEW_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric computedview_time_active(1042);

  /**
   * generated from devtools.custom_opened_count
   * Number of times a custom developer tool has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_CUSTOM_OPENED_COUNT.
   */
  constexpr impl::CounterMetric custom_opened_count(1043);

  /**
   * generated from devtools.custom_time_active
   * How long has a custom developer tool been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_CUSTOM_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric custom_time_active(1044);

  /**
   * generated from devtools.dom_opened_count
   * Number of times the DevTools DOM Inspector has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_DOM_OPENED_COUNT.
   */
  constexpr impl::CounterMetric dom_opened_count(1045);

  /**
   * generated from devtools.dom_time_active
   * How long has the DOM inspector been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_DOM_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric dom_time_active(1046);

  /**
   * generated from devtools.entry_point
   */
  enum class EntryPointLabel: uint16_t {
    eKeyshortcut = 0,
    eSystemmenu = 1,
    eHamburgermenu = 2,
    eContextmenu = 3,
    eCommandline = 4,
    eSessionrestore = 5,
    eSlowscript = 6,
    e__Other__,
  };
  /**
   * Records how the user is triggering Developer Tools startup.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DEVTOOLS_ENTRY_POINT.
   */
  constexpr impl::Labeled<impl::CounterMetric, EntryPointLabel> entry_point(1047);

  /**
   * generated from devtools.eyedropper_opened_count
   * Number of times the DevTools Eyedropper tool has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_EYEDROPPER_OPENED_COUNT.
   */
  constexpr impl::CounterMetric eyedropper_opened_count(1048);

  /**
   * generated from devtools.flexbox_highlighter_time_active
   * How long has the flexbox highlighter been active (seconds).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_FLEXBOX_HIGHLIGHTER_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric flexbox_highlighter_time_active(1049);

  /**
   * generated from devtools.fontinspector_opened_count
   * Number of times the DevTools Font Inspector has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_FONTINSPECTOR_OPENED_COUNT.
   */
  constexpr impl::CounterMetric fontinspector_opened_count(1050);

  /**
   * generated from devtools.fontinspector_time_active
   * How long has the font inspector been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_FONTINSPECTOR_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric fontinspector_time_active(1051);

  /**
   * generated from devtools.grid_highlighter_time_active
   * How long has the grid highlighter been active (seconds).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_GRID_HIGHLIGHTER_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric grid_highlighter_time_active(1052);

  /**
   * generated from devtools.inspector_opened_count
   * Number of times the DevTools Inspector has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_INSPECTOR_OPENED_COUNT.
   */
  constexpr impl::CounterMetric inspector_opened_count(1053);

  /**
   * generated from devtools.inspector_time_active
   * How long has the inspector been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_INSPECTOR_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric inspector_time_active(1054);

  /**
   * generated from devtools.jsbrowserdebugger_opened_count
   * Number of times the DevTools Browser Debugger has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_JSBROWSERDEBUGGER_OPENED_COUNT.
   */
  constexpr impl::CounterMetric jsbrowserdebugger_opened_count(1055);

  /**
   * generated from devtools.jsbrowserdebugger_time_active
   * How long has the JS browser debugger been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_JSBROWSERDEBUGGER_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric jsbrowserdebugger_time_active(1056);

  /**
   * generated from devtools.jsdebugger_opened_count
   * Number of times the DevTools Debugger has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_JSDEBUGGER_OPENED_COUNT.
   */
  constexpr impl::CounterMetric jsdebugger_opened_count(1057);

  /**
   * generated from devtools.jsdebugger_time_active
   * How long has the JS debugger been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_JSDEBUGGER_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric jsdebugger_time_active(1058);

  /**
   * generated from devtools.jsprofiler_opened_count
   * Number of times the DevTools JS Profiler has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_JSPROFILER_OPENED_COUNT.
   */
  constexpr impl::CounterMetric jsprofiler_opened_count(1059);

  /**
   * generated from devtools.jsprofiler_time_active
   * How long has the JS profiler been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_JSPROFILER_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric jsprofiler_time_active(1060);

  /**
   * generated from devtools.layoutview_opened_count
   * Number of times the DevTools Layout View has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_LAYOUTVIEW_OPENED_COUNT.
   */
  constexpr impl::CounterMetric layoutview_opened_count(1061);

  /**
   * generated from devtools.layoutview_time_active
   * How long has the layout view been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_LAYOUTVIEW_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric layoutview_time_active(1062);

  /**
   * generated from devtools.memory_opened_count
   * Number of times the DevTools Memory Tool has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_MEMORY_OPENED_COUNT.
   */
  constexpr impl::CounterMetric memory_opened_count(1063);

  /**
   * generated from devtools.memory_time_active
   * How long has the Memory Tool been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_MEMORY_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric memory_time_active(1064);

  /**
   * generated from devtools.menu_eyedropper_opened_count
   * Number of times the DevTools Eyedropper has been opened via the DevTools menu.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_MENU_EYEDROPPER_OPENED_COUNT.
   */
  constexpr impl::CounterMetric menu_eyedropper_opened_count(1065);

  /**
   * generated from devtools.netmonitor_opened_count
   * Number of times the DevTools Network Monitor has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_NETMONITOR_OPENED_COUNT.
   */
  constexpr impl::CounterMetric netmonitor_opened_count(1066);

  /**
   * generated from devtools.netmonitor_time_active
   * How long has the network monitor been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_NETMONITOR_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric netmonitor_time_active(1067);

  /**
   * generated from devtools.options_opened_count
   * Number of times the DevTools options panel has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_OPTIONS_OPENED_COUNT.
   */
  constexpr impl::CounterMetric options_opened_count(1068);

  /**
   * generated from devtools.options_time_active
   * How long has the options panel been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_OPTIONS_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric options_time_active(1069);

  /**
   * generated from devtools.picker_eyedropper_opened_count
   * Number of times the DevTools Eyedropper has been opened via the color picker.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_PICKER_EYEDROPPER_OPENED_COUNT.
   */
  constexpr impl::CounterMetric picker_eyedropper_opened_count(1070);

  /**
   * generated from devtools.responsive_opened_count
   * Number of times the DevTools Responsive Design Mode tool has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_RESPONSIVE_OPENED_COUNT.
   */
  constexpr impl::CounterMetric responsive_opened_count(1071);

  /**
   * generated from devtools.responsive_time_active
   * How long has the responsive view been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_RESPONSIVE_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric responsive_time_active(1072);

  /**
   * generated from devtools.ruleview_opened_count
   * Number of times the DevTools Rule View has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_RULEVIEW_OPENED_COUNT.
   */
  constexpr impl::CounterMetric ruleview_opened_count(1073);

  /**
   * generated from devtools.ruleview_time_active
   * How long has the rule view been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_RULEVIEW_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric ruleview_time_active(1074);

  /**
   * generated from devtools.storage_opened_count
   * Number of times the DevTools Storage Inspector has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_STORAGE_OPENED_COUNT.
   */
  constexpr impl::CounterMetric storage_opened_count(1075);

  /**
   * generated from devtools.storage_time_active
   * How long has the storage inspector been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_STORAGE_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric storage_time_active(1076);

  /**
   * generated from devtools.styleeditor_opened_count
   * Number of times the DevTools Style Editor has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_STYLEEDITOR_OPENED_COUNT.
   */
  constexpr impl::CounterMetric styleeditor_opened_count(1077);

  /**
   * generated from devtools.styleeditor_time_active
   * How long has the style editor been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_STYLEEDITOR_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric styleeditor_time_active(1078);

  /**
   * generated from devtools.toolbox_opened_count
   * Number of times the DevTools toolbox has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_TOOLBOX_OPENED_COUNT.
   */
  constexpr impl::CounterMetric toolbox_opened_count(1079);

  /**
   * generated from devtools.toolbox_time_active
   * How long has the toolbox been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_TOOLBOX_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric toolbox_time_active(1080);

  /**
   * generated from devtools.webconsole_opened_count
   * Number of times the DevTools Web Console has been opened.
   * This metric was generated to correspond to the Legacy Telemetry count histogram DEVTOOLS_WEBCONSOLE_OPENED_COUNT.
   */
  constexpr impl::CounterMetric webconsole_opened_count(1081);

  /**
   * generated from devtools.webconsole_time_active
   * How long has the web console been active (seconds)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_WEBCONSOLE_TIME_ACTIVE_SECONDS.
   */
  constexpr impl::TimingDistributionMetric webconsole_time_active(1082);
}

namespace devtools_changesview {
  /**
   * generated from devtools.changesview.opened_count
   * Number of times the Changes panel has been opened. This metric was generated to correspond to the Legacy Telemetry scalar devtools.changesview.opened_count.
   */
  constexpr impl::CounterMetric opened_count(1107);
}

namespace devtools_main {
  /**
   * generated from devtools.main.activate_responsive_design
   */
  struct ActivateResponsiveDesignExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User activates the responsive_design or split_console in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.activate#responsive_design.
   */
  constexpr impl::EventMetric<ActivateResponsiveDesignExtra> activate_responsive_design(1108);

  /**
   * generated from devtools.main.activate_split_console
   */
  struct ActivateSplitConsoleExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User activates the responsive_design or split_console in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.activate#split_console.
   */
  constexpr impl::EventMetric<ActivateSplitConsoleExtra> activate_split_console(1109);

  /**
   * generated from devtools.main.add_breakpoint_debugger
   */
  struct AddBreakpointDebuggerExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has added a breakpoint to a script. This event was generated to correspond to the Legacy Telemetry event devtools.main.add_breakpoint#debugger.
   */
  constexpr impl::EventMetric<AddBreakpointDebuggerExtra> add_breakpoint_debugger(1110);

  /**
   * generated from devtools.main.blackbox_debugger
   */
  struct BlackboxDebuggerExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User clicked the blackbox button to blackbox a script. This event was generated to correspond to the Legacy Telemetry event devtools.main.blackbox#debugger.
   */
  constexpr impl::EventMetric<BlackboxDebuggerExtra> blackbox_debugger(1111);

  /**
   * generated from devtools.main.close_adbg_aboutdebugging
   */
  struct CloseAdbgAboutdebuggingExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes about:debugging. This event was generated to correspond to the Legacy Telemetry event devtools.main.close_adbg#aboutdebugging.
   */
  constexpr impl::EventMetric<CloseAdbgAboutdebuggingExtra> close_adbg_aboutdebugging(1112);

  /**
   * generated from devtools.main.close_tools
   */
  struct CloseToolsExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.close#tools.
   */
  constexpr impl::EventMetric<CloseToolsExtra> close_tools(1113);

  /**
   * generated from devtools.main.connection_attempt_aboutdebugging
   */
  struct ConnectionAttemptAboutdebuggingExtra {
    mozilla::Maybe<nsCString> connectionId;
    mozilla::Maybe<nsCString> connectionType;
    mozilla::Maybe<nsCString> runtimeId;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> status;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (connectionId) {
        extraKeys.AppendElement()->AssignASCII("connection_id");
        extraValues.EmplaceBack(connectionId.value());
      }
      if (connectionType) {
        extraKeys.AppendElement()->AssignASCII("connection_type");
        extraValues.EmplaceBack(connectionType.value());
      }
      if (runtimeId) {
        extraKeys.AppendElement()->AssignASCII("runtime_id");
        extraValues.EmplaceBack(runtimeId.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (status) {
        extraKeys.AppendElement()->AssignASCII("status");
        extraValues.EmplaceBack(status.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User is trying to connect to a remote runtime. This event was generated to correspond to the Legacy Telemetry event devtools.main.connection_attempt#aboutdebugging.
   */
  constexpr impl::EventMetric<ConnectionAttemptAboutdebuggingExtra> connection_attempt_aboutdebugging(1114);

  /**
   * generated from devtools.main.continue_debugger
   */
  struct ContinueDebuggerExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has pressed the continue button on a paused script. This event was generated to correspond to the Legacy Telemetry event devtools.main.continue#debugger.
   */
  constexpr impl::EventMetric<ContinueDebuggerExtra> continue_debugger(1115);

  /**
   * generated from devtools.main.deactivate_responsive_design
   */
  struct DeactivateResponsiveDesignExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User deactivates the responsive_design or split_console in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.deactivate#responsive_design.
   */
  constexpr impl::EventMetric<DeactivateResponsiveDesignExtra> deactivate_responsive_design(1116);

  /**
   * generated from devtools.main.deactivate_split_console
   */
  struct DeactivateSplitConsoleExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User deactivates the responsive_design or split_console in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.deactivate#split_console.
   */
  constexpr impl::EventMetric<DeactivateSplitConsoleExtra> deactivate_split_console(1117);

  /**
   * generated from devtools.main.device_added_aboutdebugging
   */
  struct DeviceAddedAboutdebuggingExtra {
    mozilla::Maybe<nsCString> connectionType;
    mozilla::Maybe<nsCString> deviceName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (connectionType) {
        extraKeys.AppendElement()->AssignASCII("connection_type");
        extraValues.EmplaceBack(connectionType.value());
      }
      if (deviceName) {
        extraKeys.AppendElement()->AssignASCII("device_name");
        extraValues.EmplaceBack(deviceName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A new device was detected in about:debugging This event was generated to correspond to the Legacy Telemetry event devtools.main.device_added#aboutdebugging.
   */
  constexpr impl::EventMetric<DeviceAddedAboutdebuggingExtra> device_added_aboutdebugging(1118);

  /**
   * generated from devtools.main.device_removed_aboutdebugging
   */
  struct DeviceRemovedAboutdebuggingExtra {
    mozilla::Maybe<nsCString> connectionType;
    mozilla::Maybe<nsCString> deviceName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (connectionType) {
        extraKeys.AppendElement()->AssignASCII("connection_type");
        extraValues.EmplaceBack(connectionType.value());
      }
      if (deviceName) {
        extraKeys.AppendElement()->AssignASCII("device_name");
        extraValues.EmplaceBack(deviceName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A previously listed device was removed in about:debugging This event was generated to correspond to the Legacy Telemetry event devtools.main.device_removed#aboutdebugging.
   */
  constexpr impl::EventMetric<DeviceRemovedAboutdebuggingExtra> device_removed_aboutdebugging(1119);

  /**
   * generated from devtools.main.edit_html_inspector
   */
  struct EditHtmlInspectorExtra {
    mozilla::Maybe<nsCString> madeChanges;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> timeOpen;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (madeChanges) {
        extraKeys.AppendElement()->AssignASCII("made_changes");
        extraValues.EmplaceBack(madeChanges.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (timeOpen) {
        extraKeys.AppendElement()->AssignASCII("time_open");
        extraValues.EmplaceBack(timeOpen.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User is editing HTML via the context menu item in the markup view. This event was generated to correspond to the Legacy Telemetry event devtools.main.edit_html#inspector.
   */
  constexpr impl::EventMetric<EditHtmlInspectorExtra> edit_html_inspector(1120);

  /**
   * generated from devtools.main.edit_resend_netmonitor
   */
  struct EditResendNetmonitorExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has executed edit / resend in the netmonitor. This event was generated to correspond to the Legacy Telemetry event devtools.main.edit_resend#netmonitor.
   */
  constexpr impl::EventMetric<EditResendNetmonitorExtra> edit_resend_netmonitor(1121);

  /**
   * generated from devtools.main.edit_rule_ruleview
   */
  struct EditRuleRuleviewExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User is editing a CSS rule by clicking on or next to a CSS property, enabling / disabling a rule or creating a new property. This event was generated to correspond to the Legacy Telemetry event devtools.main.edit_rule#ruleview.
   */
  constexpr impl::EventMetric<EditRuleRuleviewExtra> edit_rule_ruleview(1122);

  /**
   * generated from devtools.main.enter_accessibility
   */
  struct EnterAccessibilityExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#accessibility.
   */
  constexpr impl::EventMetric<EnterAccessibilityExtra> enter_accessibility(1123);

  /**
   * generated from devtools.main.enter_application
   */
  struct EnterApplicationExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#application.
   */
  constexpr impl::EventMetric<EnterApplicationExtra> enter_application(1124);

  /**
   * generated from devtools.main.enter_dom
   */
  struct EnterDomExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#dom.
   */
  constexpr impl::EventMetric<EnterDomExtra> enter_dom(1125);

  /**
   * generated from devtools.main.enter_fake_tool4242
   */
  struct EnterFakeTool4242Extra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#fakeTool4242.
   */
  constexpr impl::EventMetric<EnterFakeTool4242Extra> enter_fake_tool4242(1126);

  /**
   * generated from devtools.main.enter_inspector
   */
  struct EnterInspectorExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#inspector.
   */
  constexpr impl::EventMetric<EnterInspectorExtra> enter_inspector(1127);

  /**
   * generated from devtools.main.enter_jsdebugger
   */
  struct EnterJsdebuggerExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#jsdebugger.
   */
  constexpr impl::EventMetric<EnterJsdebuggerExtra> enter_jsdebugger(1128);

  /**
   * generated from devtools.main.enter_memory
   */
  struct EnterMemoryExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#memory.
   */
  constexpr impl::EventMetric<EnterMemoryExtra> enter_memory(1129);

  /**
   * generated from devtools.main.enter_netmonitor
   */
  struct EnterNetmonitorExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#netmonitor.
   */
  constexpr impl::EventMetric<EnterNetmonitorExtra> enter_netmonitor(1130);

  /**
   * generated from devtools.main.enter_options
   */
  struct EnterOptionsExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#options.
   */
  constexpr impl::EventMetric<EnterOptionsExtra> enter_options(1131);

  /**
   * generated from devtools.main.enter_other
   */
  struct EnterOtherExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#other.
   */
  constexpr impl::EventMetric<EnterOtherExtra> enter_other(1132);

  /**
   * generated from devtools.main.enter_performance
   */
  struct EnterPerformanceExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#performance.
   */
  constexpr impl::EventMetric<EnterPerformanceExtra> enter_performance(1133);

  /**
   * generated from devtools.main.enter_storage
   */
  struct EnterStorageExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#storage.
   */
  constexpr impl::EventMetric<EnterStorageExtra> enter_storage(1134);

  /**
   * generated from devtools.main.enter_styleeditor
   */
  struct EnterStyleeditorExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#styleeditor.
   */
  constexpr impl::EventMetric<EnterStyleeditorExtra> enter_styleeditor(1135);

  /**
   * generated from devtools.main.enter_test_blank_panel
   */
  struct EnterTestBlankPanelExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#testBlankPanel.
   */
  constexpr impl::EventMetric<EnterTestBlankPanelExtra> enter_test_blank_panel(1136);

  /**
   * generated from devtools.main.enter_test_tool
   */
  struct EnterTestToolExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#testTool.
   */
  constexpr impl::EventMetric<EnterTestToolExtra> enter_test_tool(1137);

  /**
   * generated from devtools.main.enter_test_tool1072208
   */
  struct EnterTestTool1072208Extra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#testTool1072208.
   */
  constexpr impl::EventMetric<EnterTestTool1072208Extra> enter_test_tool1072208(1138);

  /**
   * generated from devtools.main.enter_testtool1
   */
  struct EnterTesttool1Extra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#testtool1.
   */
  constexpr impl::EventMetric<EnterTesttool1Extra> enter_testtool1(1139);

  /**
   * generated from devtools.main.enter_testtool2
   */
  struct EnterTesttool2Extra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#testtool2.
   */
  constexpr impl::EventMetric<EnterTesttool2Extra> enter_testtool2(1140);

  /**
   * generated from devtools.main.enter_webconsole
   */
  struct EnterWebconsoleExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#webconsole.
   */
  constexpr impl::EventMetric<EnterWebconsoleExtra> enter_webconsole(1141);

  /**
   * generated from devtools.main.enter_whatsnew
   */
  struct EnterWhatsnewExtra {
    mozilla::Maybe<nsCString> cold;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> messageCount;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> startState;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (cold) {
        extraKeys.AppendElement()->AssignASCII("cold");
        extraValues.EmplaceBack(cold.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (messageCount) {
        extraKeys.AppendElement()->AssignASCII("message_count");
        extraValues.EmplaceBack(messageCount.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (startState) {
        extraKeys.AppendElement()->AssignASCII("start_state");
        extraValues.EmplaceBack(startState.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.enter#whatsnew.
   */
  constexpr impl::EventMetric<EnterWhatsnewExtra> enter_whatsnew(1142);

  /**
   * generated from devtools.main.execute_js_webconsole
   */
  struct ExecuteJsWebconsoleExtra {
    mozilla::Maybe<nsCString> input;
    mozilla::Maybe<nsCString> lines;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (input) {
        extraKeys.AppendElement()->AssignASCII("input");
        extraValues.EmplaceBack(input.value());
      }
      if (lines) {
        extraKeys.AppendElement()->AssignASCII("lines");
        extraValues.EmplaceBack(lines.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has executed some JS in the Web Console. This event was generated to correspond to the Legacy Telemetry event devtools.main.execute_js#webconsole.
   */
  constexpr impl::EventMetric<ExecuteJsWebconsoleExtra> execute_js_webconsole(1143);

  /**
   * generated from devtools.main.exit_accessibility
   */
  struct ExitAccessibilityExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#accessibility.
   */
  constexpr impl::EventMetric<ExitAccessibilityExtra> exit_accessibility(1144);

  /**
   * generated from devtools.main.exit_application
   */
  struct ExitApplicationExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#application.
   */
  constexpr impl::EventMetric<ExitApplicationExtra> exit_application(1145);

  /**
   * generated from devtools.main.exit_dom
   */
  struct ExitDomExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#dom.
   */
  constexpr impl::EventMetric<ExitDomExtra> exit_dom(1146);

  /**
   * generated from devtools.main.exit_fake_tool4242
   */
  struct ExitFakeTool4242Extra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#fakeTool4242.
   */
  constexpr impl::EventMetric<ExitFakeTool4242Extra> exit_fake_tool4242(1147);

  /**
   * generated from devtools.main.exit_inspector
   */
  struct ExitInspectorExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#inspector.
   */
  constexpr impl::EventMetric<ExitInspectorExtra> exit_inspector(1148);

  /**
   * generated from devtools.main.exit_jsdebugger
   */
  struct ExitJsdebuggerExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#jsdebugger.
   */
  constexpr impl::EventMetric<ExitJsdebuggerExtra> exit_jsdebugger(1149);

  /**
   * generated from devtools.main.exit_memory
   */
  struct ExitMemoryExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#memory.
   */
  constexpr impl::EventMetric<ExitMemoryExtra> exit_memory(1150);

  /**
   * generated from devtools.main.exit_netmonitor
   */
  struct ExitNetmonitorExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#netmonitor.
   */
  constexpr impl::EventMetric<ExitNetmonitorExtra> exit_netmonitor(1151);

  /**
   * generated from devtools.main.exit_options
   */
  struct ExitOptionsExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#options.
   */
  constexpr impl::EventMetric<ExitOptionsExtra> exit_options(1152);

  /**
   * generated from devtools.main.exit_other
   */
  struct ExitOtherExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#other.
   */
  constexpr impl::EventMetric<ExitOtherExtra> exit_other(1153);

  /**
   * generated from devtools.main.exit_performance
   */
  struct ExitPerformanceExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#performance.
   */
  constexpr impl::EventMetric<ExitPerformanceExtra> exit_performance(1154);

  /**
   * generated from devtools.main.exit_storage
   */
  struct ExitStorageExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#storage.
   */
  constexpr impl::EventMetric<ExitStorageExtra> exit_storage(1155);

  /**
   * generated from devtools.main.exit_styleeditor
   */
  struct ExitStyleeditorExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#styleeditor.
   */
  constexpr impl::EventMetric<ExitStyleeditorExtra> exit_styleeditor(1156);

  /**
   * generated from devtools.main.exit_test_blank_panel
   */
  struct ExitTestBlankPanelExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#testBlankPanel.
   */
  constexpr impl::EventMetric<ExitTestBlankPanelExtra> exit_test_blank_panel(1157);

  /**
   * generated from devtools.main.exit_test_tool
   */
  struct ExitTestToolExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#testTool.
   */
  constexpr impl::EventMetric<ExitTestToolExtra> exit_test_tool(1158);

  /**
   * generated from devtools.main.exit_test_tool1072208
   */
  struct ExitTestTool1072208Extra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#testTool1072208.
   */
  constexpr impl::EventMetric<ExitTestTool1072208Extra> exit_test_tool1072208(1159);

  /**
   * generated from devtools.main.exit_testtool1
   */
  struct ExitTesttool1Extra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#testtool1.
   */
  constexpr impl::EventMetric<ExitTesttool1Extra> exit_testtool1(1160);

  /**
   * generated from devtools.main.exit_testtool2
   */
  struct ExitTesttool2Extra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#testtool2.
   */
  constexpr impl::EventMetric<ExitTesttool2Extra> exit_testtool2(1161);

  /**
   * generated from devtools.main.exit_webconsole
   */
  struct ExitWebconsoleExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#webconsole.
   */
  constexpr impl::EventMetric<ExitWebconsoleExtra> exit_webconsole(1162);

  /**
   * generated from devtools.main.exit_whatsnew
   */
  struct ExitWhatsnewExtra {
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> nextPanel;
    mozilla::Maybe<nsCString> panelName;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (nextPanel) {
        extraKeys.AppendElement()->AssignASCII("next_panel");
        extraValues.EmplaceBack(nextPanel.value());
      }
      if (panelName) {
        extraKeys.AppendElement()->AssignASCII("panel_name");
        extraValues.EmplaceBack(panelName.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User closes a tool in the devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.exit#whatsnew.
   */
  constexpr impl::EventMetric<ExitWhatsnewExtra> exit_whatsnew(1163);

  /**
   * generated from devtools.main.filters_changed_netmonitor
   */
  struct FiltersChangedNetmonitorExtra {
    mozilla::Maybe<nsCString> active;
    mozilla::Maybe<nsCString> inactive;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> trigger;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (active) {
        extraKeys.AppendElement()->AssignASCII("active");
        extraValues.EmplaceBack(active.value());
      }
      if (inactive) {
        extraKeys.AppendElement()->AssignASCII("inactive");
        extraValues.EmplaceBack(inactive.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has changed filters in the web console. This event was generated to correspond to the Legacy Telemetry event devtools.main.filters_changed#netmonitor.
   */
  constexpr impl::EventMetric<FiltersChangedNetmonitorExtra> filters_changed_netmonitor(1164);

  /**
   * generated from devtools.main.filters_changed_webconsole
   */
  struct FiltersChangedWebconsoleExtra {
    mozilla::Maybe<nsCString> active;
    mozilla::Maybe<nsCString> inactive;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> trigger;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (active) {
        extraKeys.AppendElement()->AssignASCII("active");
        extraValues.EmplaceBack(active.value());
      }
      if (inactive) {
        extraKeys.AppendElement()->AssignASCII("inactive");
        extraValues.EmplaceBack(inactive.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has changed filters in the web console. This event was generated to correspond to the Legacy Telemetry event devtools.main.filters_changed#webconsole.
   */
  constexpr impl::EventMetric<FiltersChangedWebconsoleExtra> filters_changed_webconsole(1165);

  /**
   * generated from devtools.main.inspect_aboutdebugging
   */
  struct InspectAboutdebuggingExtra {
    mozilla::Maybe<nsCString> runtimeType;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> targetType;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (runtimeType) {
        extraKeys.AppendElement()->AssignASCII("runtime_type");
        extraValues.EmplaceBack(runtimeType.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (targetType) {
        extraKeys.AppendElement()->AssignASCII("target_type");
        extraValues.EmplaceBack(targetType.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has clicked on the inspect button of one of the debug targets of aboutdebugging. This event was generated to correspond to the Legacy Telemetry event devtools.main.inspect#aboutdebugging.
   */
  constexpr impl::EventMetric<InspectAboutdebuggingExtra> inspect_aboutdebugging(1166);

  /**
   * generated from devtools.main.jump_to_definition_webconsole
   */
  struct JumpToDefinitionWebconsoleExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has clicked "Jump to definition" icon (next to logged functions) in the web console. This event was generated to correspond to the Legacy Telemetry event devtools.main.jump_to_definition#webconsole.
   */
  constexpr impl::EventMetric<JumpToDefinitionWebconsoleExtra> jump_to_definition_webconsole(1167);

  /**
   * generated from devtools.main.jump_to_source_webconsole
   */
  struct JumpToSourceWebconsoleExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has clicked a link to a source file in the web console. This event was generated to correspond to the Legacy Telemetry event devtools.main.jump_to_source#webconsole.
   */
  constexpr impl::EventMetric<JumpToSourceWebconsoleExtra> jump_to_source_webconsole(1168);

  /**
   * generated from devtools.main.object_expanded_webconsole
   */
  struct ObjectExpandedWebconsoleExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has expanded an object in the web console. This event was generated to correspond to the Legacy Telemetry event devtools.main.object_expanded#webconsole.
   */
  constexpr impl::EventMetric<ObjectExpandedWebconsoleExtra> object_expanded_webconsole(1169);

  /**
   * generated from devtools.main.open_adbg_aboutdebugging
   */
  struct OpenAdbgAboutdebuggingExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens about:debugging. This event was generated to correspond to the Legacy Telemetry event devtools.main.open_adbg#aboutdebugging.
   */
  constexpr impl::EventMetric<OpenAdbgAboutdebuggingExtra> open_adbg_aboutdebugging(1170);

  /**
   * generated from devtools.main.open_tools
   */
  struct OpenToolsExtra {
    mozilla::Maybe<nsCString> entrypoint;
    mozilla::Maybe<nsCString> firstPanel;
    mozilla::Maybe<nsCString> host;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> shortcut;
    mozilla::Maybe<nsCString> splitconsole;
    mozilla::Maybe<nsCString> value;
    mozilla::Maybe<nsCString> width;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (entrypoint) {
        extraKeys.AppendElement()->AssignASCII("entrypoint");
        extraValues.EmplaceBack(entrypoint.value());
      }
      if (firstPanel) {
        extraKeys.AppendElement()->AssignASCII("first_panel");
        extraValues.EmplaceBack(firstPanel.value());
      }
      if (host) {
        extraKeys.AppendElement()->AssignASCII("host");
        extraValues.EmplaceBack(host.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (shortcut) {
        extraKeys.AppendElement()->AssignASCII("shortcut");
        extraValues.EmplaceBack(shortcut.value());
      }
      if (splitconsole) {
        extraKeys.AppendElement()->AssignASCII("splitconsole");
        extraValues.EmplaceBack(splitconsole.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      if (width) {
        extraKeys.AppendElement()->AssignASCII("width");
        extraValues.EmplaceBack(width.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User opens devtools toolbox. This event was generated to correspond to the Legacy Telemetry event devtools.main.open#tools.
   */
  constexpr impl::EventMetric<OpenToolsExtra> open_tools(1171);

  /**
   * generated from devtools.main.pause_debugger
   */
  struct PauseDebuggerExtra {
    mozilla::Maybe<nsCString> libStacks;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (libStacks) {
        extraKeys.AppendElement()->AssignASCII("lib_stacks");
        extraValues.EmplaceBack(libStacks.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Debugger has paused in a script due to a breakpoint or exception. This event was generated to correspond to the Legacy Telemetry event devtools.main.pause#debugger.
   */
  constexpr impl::EventMetric<PauseDebuggerExtra> pause_debugger(1172);

  /**
   * generated from devtools.main.pause_on_exceptions_debugger
   */
  struct PauseOnExceptionsDebuggerExtra {
    mozilla::Maybe<nsCString> caughtExceptio;
    mozilla::Maybe<nsCString> exceptions;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (caughtExceptio) {
        extraKeys.AppendElement()->AssignASCII("caught_exceptio");
        extraValues.EmplaceBack(caughtExceptio.value());
      }
      if (exceptions) {
        extraKeys.AppendElement()->AssignASCII("exceptions");
        extraValues.EmplaceBack(exceptions.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has changed pausing behaviour in the debugger. This event was generated to correspond to the Legacy Telemetry event devtools.main.pause_on_exceptions#debugger.
   */
  constexpr impl::EventMetric<PauseOnExceptionsDebuggerExtra> pause_on_exceptions_debugger(1173);

  /**
   * generated from devtools.main.persist_changed_netmonitor
   */
  struct PersistChangedNetmonitorExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has changed log persist status. This event was generated to correspond to the Legacy Telemetry event devtools.main.persist_changed#netmonitor.
   */
  constexpr impl::EventMetric<PersistChangedNetmonitorExtra> persist_changed_netmonitor(1174);

  /**
   * generated from devtools.main.persist_changed_webconsole
   */
  struct PersistChangedWebconsoleExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has changed log persist status. This event was generated to correspond to the Legacy Telemetry event devtools.main.persist_changed#webconsole.
   */
  constexpr impl::EventMetric<PersistChangedWebconsoleExtra> persist_changed_webconsole(1175);

  /**
   * generated from devtools.main.pretty_print_debugger
   */
  struct PrettyPrintDebuggerExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User clicked the pretty print button to pretty print a script. This event was generated to correspond to the Legacy Telemetry event devtools.main.pretty_print#debugger.
   */
  constexpr impl::EventMetric<PrettyPrintDebuggerExtra> pretty_print_debugger(1176);

  /**
   * generated from devtools.main.remove_breakpoint_debugger
   */
  struct RemoveBreakpointDebuggerExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has removed a breakpoint from a script. This event was generated to correspond to the Legacy Telemetry event devtools.main.remove_breakpoint#debugger.
   */
  constexpr impl::EventMetric<RemoveBreakpointDebuggerExtra> remove_breakpoint_debugger(1177);

  /**
   * generated from devtools.main.reverse_search_webconsole
   */
  struct ReverseSearchWebconsoleExtra {
    mozilla::Maybe<nsCString> functionality;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (functionality) {
        extraKeys.AppendElement()->AssignASCII("functionality");
        extraValues.EmplaceBack(functionality.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has toggled, navigated or evaluated expressions from reverse search . This event was generated to correspond to the Legacy Telemetry event devtools.main.reverse_search#webconsole.
   */
  constexpr impl::EventMetric<ReverseSearchWebconsoleExtra> reverse_search_webconsole(1178);

  /**
   * generated from devtools.main.runtime_added_aboutdebugging
   */
  struct RuntimeAddedAboutdebuggingExtra {
    mozilla::Maybe<nsCString> connectionType;
    mozilla::Maybe<nsCString> deviceName;
    mozilla::Maybe<nsCString> runtimeId;
    mozilla::Maybe<nsCString> runtimeName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (connectionType) {
        extraKeys.AppendElement()->AssignASCII("connection_type");
        extraValues.EmplaceBack(connectionType.value());
      }
      if (deviceName) {
        extraKeys.AppendElement()->AssignASCII("device_name");
        extraValues.EmplaceBack(deviceName.value());
      }
      if (runtimeId) {
        extraKeys.AppendElement()->AssignASCII("runtime_id");
        extraValues.EmplaceBack(runtimeId.value());
      }
      if (runtimeName) {
        extraKeys.AppendElement()->AssignASCII("runtime_name");
        extraValues.EmplaceBack(runtimeName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A new remote runtime has been detected in about:debugging This event was generated to correspond to the Legacy Telemetry event devtools.main.runtime_added#aboutdebugging.
   */
  constexpr impl::EventMetric<RuntimeAddedAboutdebuggingExtra> runtime_added_aboutdebugging(1179);

  /**
   * generated from devtools.main.runtime_connected_aboutdebugging
   */
  struct RuntimeConnectedAboutdebuggingExtra {
    mozilla::Maybe<nsCString> connectionType;
    mozilla::Maybe<nsCString> deviceName;
    mozilla::Maybe<nsCString> runtimeId;
    mozilla::Maybe<nsCString> runtimeName;
    mozilla::Maybe<nsCString> runtimeOs;
    mozilla::Maybe<nsCString> runtimeVersion;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (connectionType) {
        extraKeys.AppendElement()->AssignASCII("connection_type");
        extraValues.EmplaceBack(connectionType.value());
      }
      if (deviceName) {
        extraKeys.AppendElement()->AssignASCII("device_name");
        extraValues.EmplaceBack(deviceName.value());
      }
      if (runtimeId) {
        extraKeys.AppendElement()->AssignASCII("runtime_id");
        extraValues.EmplaceBack(runtimeId.value());
      }
      if (runtimeName) {
        extraKeys.AppendElement()->AssignASCII("runtime_name");
        extraValues.EmplaceBack(runtimeName.value());
      }
      if (runtimeOs) {
        extraKeys.AppendElement()->AssignASCII("runtime_os");
        extraValues.EmplaceBack(runtimeOs.value());
      }
      if (runtimeVersion) {
        extraKeys.AppendElement()->AssignASCII("runtime_version");
        extraValues.EmplaceBack(runtimeVersion.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Connection was established with a remote runtime in about:debugging This event was generated to correspond to the Legacy Telemetry event devtools.main.runtime_connected#aboutdebugging.
   */
  constexpr impl::EventMetric<RuntimeConnectedAboutdebuggingExtra> runtime_connected_aboutdebugging(1180);

  /**
   * generated from devtools.main.runtime_disconnected_aboutdebugging
   */
  struct RuntimeDisconnectedAboutdebuggingExtra {
    mozilla::Maybe<nsCString> connectionType;
    mozilla::Maybe<nsCString> deviceName;
    mozilla::Maybe<nsCString> runtimeId;
    mozilla::Maybe<nsCString> runtimeName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (connectionType) {
        extraKeys.AppendElement()->AssignASCII("connection_type");
        extraValues.EmplaceBack(connectionType.value());
      }
      if (deviceName) {
        extraKeys.AppendElement()->AssignASCII("device_name");
        extraValues.EmplaceBack(deviceName.value());
      }
      if (runtimeId) {
        extraKeys.AppendElement()->AssignASCII("runtime_id");
        extraValues.EmplaceBack(runtimeId.value());
      }
      if (runtimeName) {
        extraKeys.AppendElement()->AssignASCII("runtime_name");
        extraValues.EmplaceBack(runtimeName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Connection was lost with a remote runtime in about debugging This event was generated to correspond to the Legacy Telemetry event devtools.main.runtime_disconnected#aboutdebugging.
   */
  constexpr impl::EventMetric<RuntimeDisconnectedAboutdebuggingExtra> runtime_disconnected_aboutdebugging(1181);

  /**
   * generated from devtools.main.runtime_removed_aboutdebugging
   */
  struct RuntimeRemovedAboutdebuggingExtra {
    mozilla::Maybe<nsCString> connectionType;
    mozilla::Maybe<nsCString> deviceName;
    mozilla::Maybe<nsCString> runtimeId;
    mozilla::Maybe<nsCString> runtimeName;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (connectionType) {
        extraKeys.AppendElement()->AssignASCII("connection_type");
        extraValues.EmplaceBack(connectionType.value());
      }
      if (deviceName) {
        extraKeys.AppendElement()->AssignASCII("device_name");
        extraValues.EmplaceBack(deviceName.value());
      }
      if (runtimeId) {
        extraKeys.AppendElement()->AssignASCII("runtime_id");
        extraValues.EmplaceBack(runtimeId.value());
      }
      if (runtimeName) {
        extraKeys.AppendElement()->AssignASCII("runtime_name");
        extraValues.EmplaceBack(runtimeName.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * A previously listed runtime was removed in about:debugging This event was generated to correspond to the Legacy Telemetry event devtools.main.runtime_removed#aboutdebugging.
   */
  constexpr impl::EventMetric<RuntimeRemovedAboutdebuggingExtra> runtime_removed_aboutdebugging(1182);

  /**
   * generated from devtools.main.select_page_aboutdebugging
   */
  struct SelectPageAboutdebuggingExtra {
    mozilla::Maybe<nsCString> pageType;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (pageType) {
        extraKeys.AppendElement()->AssignASCII("page_type");
        extraValues.EmplaceBack(pageType.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User navigates to a new page of an application such as about:debugging This event was generated to correspond to the Legacy Telemetry event devtools.main.select_page#aboutdebugging.
   */
  constexpr impl::EventMetric<SelectPageAboutdebuggingExtra> select_page_aboutdebugging(1183);

  /**
   * generated from devtools.main.select_page_application
   */
  struct SelectPageApplicationExtra {
    mozilla::Maybe<nsCString> pageType;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (pageType) {
        extraKeys.AppendElement()->AssignASCII("page_type");
        extraValues.EmplaceBack(pageType.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User navigates to a new page of an application such as about:debugging This event was generated to correspond to the Legacy Telemetry event devtools.main.select_page#application.
   */
  constexpr impl::EventMetric<SelectPageApplicationExtra> select_page_application(1184);

  /**
   * generated from devtools.main.select_ws_frame_netmonitor
   */
  struct SelectWsFrameNetmonitorExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has selected a WebSocket frame. This event was generated to correspond to the Legacy Telemetry event devtools.main.select_ws_frame#netmonitor.
   */
  constexpr impl::EventMetric<SelectWsFrameNetmonitorExtra> select_ws_frame_netmonitor(1185);

  /**
   * generated from devtools.main.show_profiler_aboutdebugging
   */
  struct ShowProfilerAboutdebuggingExtra {
    mozilla::Maybe<nsCString> runtimeId;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (runtimeId) {
        extraKeys.AppendElement()->AssignASCII("runtime_id");
        extraValues.EmplaceBack(runtimeId.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has clicked on the "Open Profiler" button in a runtime page of about:debugging This event was generated to correspond to the Legacy Telemetry event devtools.main.show_profiler#aboutdebugging.
   */
  constexpr impl::EventMetric<ShowProfilerAboutdebuggingExtra> show_profiler_aboutdebugging(1186);

  /**
   * generated from devtools.main.sidepanel_changed_inspector
   */
  struct SidepanelChangedInspectorExtra {
    mozilla::Maybe<nsCString> newpanel;
    mozilla::Maybe<nsCString> oldpanel;
    mozilla::Maybe<nsCString> os;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newpanel) {
        extraKeys.AppendElement()->AssignASCII("newpanel");
        extraValues.EmplaceBack(newpanel.value());
      }
      if (oldpanel) {
        extraKeys.AppendElement()->AssignASCII("oldpanel");
        extraValues.EmplaceBack(oldpanel.value());
      }
      if (os) {
        extraKeys.AppendElement()->AssignASCII("os");
        extraValues.EmplaceBack(os.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has switched sidepanel tabs. This event was generated to correspond to the Legacy Telemetry event devtools.main.sidepanel_changed#inspector.
   */
  constexpr impl::EventMetric<SidepanelChangedInspectorExtra> sidepanel_changed_inspector(1187);

  /**
   * generated from devtools.main.sidepanel_changed_netmonitor
   */
  struct SidepanelChangedNetmonitorExtra {
    mozilla::Maybe<nsCString> newpanel;
    mozilla::Maybe<nsCString> oldpanel;
    mozilla::Maybe<nsCString> os;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (newpanel) {
        extraKeys.AppendElement()->AssignASCII("newpanel");
        extraValues.EmplaceBack(newpanel.value());
      }
      if (oldpanel) {
        extraKeys.AppendElement()->AssignASCII("oldpanel");
        extraValues.EmplaceBack(oldpanel.value());
      }
      if (os) {
        extraKeys.AppendElement()->AssignASCII("os");
        extraValues.EmplaceBack(os.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has switched sidepanel tabs. This event was generated to correspond to the Legacy Telemetry event devtools.main.sidepanel_changed#netmonitor.
   */
  constexpr impl::EventMetric<SidepanelChangedNetmonitorExtra> sidepanel_changed_netmonitor(1188);

  /**
   * generated from devtools.main.start_worker_application
   */
  struct StartWorkerApplicationExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User manually starts a service worker This event was generated to correspond to the Legacy Telemetry event devtools.main.start_worker#application.
   */
  constexpr impl::EventMetric<StartWorkerApplicationExtra> start_worker_application(1189);

  /**
   * generated from devtools.main.throttle_changed_netmonitor
   */
  struct ThrottleChangedNetmonitorExtra {
    mozilla::Maybe<nsCString> mode;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (mode) {
        extraKeys.AppendElement()->AssignASCII("mode");
        extraValues.EmplaceBack(mode.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has changed the throttle setting in the netmonitor. This event was generated to correspond to the Legacy Telemetry event devtools.main.throttle_changed#netmonitor.
   */
  constexpr impl::EventMetric<ThrottleChangedNetmonitorExtra> throttle_changed_netmonitor(1190);

  /**
   * generated from devtools.main.tool_timer_animationinspector
   */
  struct ToolTimerAnimationinspectorExtra {
    mozilla::Maybe<nsCString> os;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> timeOpen;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (os) {
        extraKeys.AppendElement()->AssignASCII("os");
        extraValues.EmplaceBack(os.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (timeOpen) {
        extraKeys.AppendElement()->AssignASCII("time_open");
        extraValues.EmplaceBack(timeOpen.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The amount of time a tool was opened for. This event was generated to correspond to the Legacy Telemetry event devtools.main.tool_timer#animationinspector.
   */
  constexpr impl::EventMetric<ToolTimerAnimationinspectorExtra> tool_timer_animationinspector(1191);

  /**
   * generated from devtools.main.tool_timer_changesview
   */
  struct ToolTimerChangesviewExtra {
    mozilla::Maybe<nsCString> os;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> timeOpen;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (os) {
        extraKeys.AppendElement()->AssignASCII("os");
        extraValues.EmplaceBack(os.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (timeOpen) {
        extraKeys.AppendElement()->AssignASCII("time_open");
        extraValues.EmplaceBack(timeOpen.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The amount of time a tool was opened for. This event was generated to correspond to the Legacy Telemetry event devtools.main.tool_timer#changesview.
   */
  constexpr impl::EventMetric<ToolTimerChangesviewExtra> tool_timer_changesview(1192);

  /**
   * generated from devtools.main.tool_timer_compatibilityview
   */
  struct ToolTimerCompatibilityviewExtra {
    mozilla::Maybe<nsCString> os;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> timeOpen;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (os) {
        extraKeys.AppendElement()->AssignASCII("os");
        extraValues.EmplaceBack(os.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (timeOpen) {
        extraKeys.AppendElement()->AssignASCII("time_open");
        extraValues.EmplaceBack(timeOpen.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The amount of time a tool was opened for. This event was generated to correspond to the Legacy Telemetry event devtools.main.tool_timer#compatibilityview.
   */
  constexpr impl::EventMetric<ToolTimerCompatibilityviewExtra> tool_timer_compatibilityview(1193);

  /**
   * generated from devtools.main.tool_timer_computedview
   */
  struct ToolTimerComputedviewExtra {
    mozilla::Maybe<nsCString> os;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> timeOpen;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (os) {
        extraKeys.AppendElement()->AssignASCII("os");
        extraValues.EmplaceBack(os.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (timeOpen) {
        extraKeys.AppendElement()->AssignASCII("time_open");
        extraValues.EmplaceBack(timeOpen.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The amount of time a tool was opened for. This event was generated to correspond to the Legacy Telemetry event devtools.main.tool_timer#computedview.
   */
  constexpr impl::EventMetric<ToolTimerComputedviewExtra> tool_timer_computedview(1194);

  /**
   * generated from devtools.main.tool_timer_fontinspector
   */
  struct ToolTimerFontinspectorExtra {
    mozilla::Maybe<nsCString> os;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> timeOpen;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (os) {
        extraKeys.AppendElement()->AssignASCII("os");
        extraValues.EmplaceBack(os.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (timeOpen) {
        extraKeys.AppendElement()->AssignASCII("time_open");
        extraValues.EmplaceBack(timeOpen.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The amount of time a tool was opened for. This event was generated to correspond to the Legacy Telemetry event devtools.main.tool_timer#fontinspector.
   */
  constexpr impl::EventMetric<ToolTimerFontinspectorExtra> tool_timer_fontinspector(1195);

  /**
   * generated from devtools.main.tool_timer_layoutview
   */
  struct ToolTimerLayoutviewExtra {
    mozilla::Maybe<nsCString> os;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> timeOpen;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (os) {
        extraKeys.AppendElement()->AssignASCII("os");
        extraValues.EmplaceBack(os.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (timeOpen) {
        extraKeys.AppendElement()->AssignASCII("time_open");
        extraValues.EmplaceBack(timeOpen.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The amount of time a tool was opened for. This event was generated to correspond to the Legacy Telemetry event devtools.main.tool_timer#layoutview.
   */
  constexpr impl::EventMetric<ToolTimerLayoutviewExtra> tool_timer_layoutview(1196);

  /**
   * generated from devtools.main.tool_timer_ruleview
   */
  struct ToolTimerRuleviewExtra {
    mozilla::Maybe<nsCString> os;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> timeOpen;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (os) {
        extraKeys.AppendElement()->AssignASCII("os");
        extraValues.EmplaceBack(os.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (timeOpen) {
        extraKeys.AppendElement()->AssignASCII("time_open");
        extraValues.EmplaceBack(timeOpen.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The amount of time a tool was opened for. This event was generated to correspond to the Legacy Telemetry event devtools.main.tool_timer#ruleview.
   */
  constexpr impl::EventMetric<ToolTimerRuleviewExtra> tool_timer_ruleview(1197);

  /**
   * generated from devtools.main.unregister_worker_application
   */
  struct UnregisterWorkerApplicationExtra {
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User manually unregisters a service worker registration This event was generated to correspond to the Legacy Telemetry event devtools.main.unregister_worker#application.
   */
  constexpr impl::EventMetric<UnregisterWorkerApplicationExtra> unregister_worker_application(1198);

  /**
   * generated from devtools.main.update_conn_prompt_aboutdebugging
   */
  struct UpdateConnPromptAboutdebuggingExtra {
    mozilla::Maybe<nsCString> promptEnabled;
    mozilla::Maybe<nsCString> runtimeId;
    mozilla::Maybe<nsCString> sessionId;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (promptEnabled) {
        extraKeys.AppendElement()->AssignASCII("prompt_enabled");
        extraValues.EmplaceBack(promptEnabled.value());
      }
      if (runtimeId) {
        extraKeys.AppendElement()->AssignASCII("runtime_id");
        extraValues.EmplaceBack(runtimeId.value());
      }
      if (sessionId) {
        extraKeys.AppendElement()->AssignASCII("session_id");
        extraValues.EmplaceBack(sessionId.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User has clicked on the "Enable/Disable connection prompt" button in a runtime page of about:debugging This event was generated to correspond to the Legacy Telemetry event devtools.main.update_conn_prompt#aboutdebugging.
   */
  constexpr impl::EventMetric<UpdateConnPromptAboutdebuggingExtra> update_conn_prompt_aboutdebugging(1199);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDevtoolsClientSharedMetrics_h
