/* THIS FILE IS AUTOGENERATED FROM Blob.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_BlobBinding_h
#define mozilla_dom_BlobBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

class Blob;
struct BlobPropertyBagAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class EndingType : uint8_t {
  Transparent,
  Native,
  EndGuard_
};

namespace EndingTypeValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(EndingType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(EndingType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace EndingTypeValues

bool
ToJSValue(JSContext* aCx, EndingType aArgument, JS::MutableHandle<JS::Value> aValue);


struct BlobPropertyBag : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR EndingType mEndings;
  MOZ_INIT_OUTSIDE_CTOR nsString mType;

  BlobPropertyBag();

  explicit inline BlobPropertyBag(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  BlobPropertyBag(BlobPropertyBag&& aOther) = default;

  explicit inline BlobPropertyBag(const BlobPropertyBag& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  BlobPropertyBag&
  operator=(const BlobPropertyBag& aOther);

private:
  static bool
  InitIds(JSContext* cx, BlobPropertyBagAtoms* atomsCache);
};

namespace binding_detail {
struct FastBlobPropertyBag : public BlobPropertyBag
{
  inline FastBlobPropertyBag()
    : BlobPropertyBag(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Blob_Binding {

  typedef mozilla::dom::Blob NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::Blob* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Blob,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Blob,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Blob,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Blob_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_BlobBinding_h
