/* THIS FILE IS AUTOGENERATED FROM Console.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ConsoleBinding_h
#define mozilla_dom_ConsoleBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Console;
struct ConsoleCounterAtoms;
struct ConsoleCounterErrorAtoms;
struct ConsoleEventAtoms;
class ConsoleInstance;
class ConsoleInstanceDumpCallback;
struct ConsoleInstanceOptionsAtoms;
struct ConsoleProfileEventAtoms;
struct ConsoleStackEntryAtoms;
struct ConsoleTimerErrorAtoms;
struct ConsoleTimerLogOrEndAtoms;
struct ConsoleTimerStartAtoms;
struct NativePropertyHooks;
class OwningUnsignedLongLongOrString;
class ProtoAndIfaceCache;
class UnsignedLongLongOrString;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class ConsoleLogLevel : uint8_t {
  All,
  Debug,
  Log,
  Info,
  Clear,
  Trace,
  TimeLog,
  TimeEnd,
  Time,
  Group,
  GroupEnd,
  Profile,
  ProfileEnd,
  Dir,
  Dirxml,
  Warn,
  Error,
  Off,
  EndGuard_
};

namespace ConsoleLogLevelValues {
extern const EnumEntry strings[19];

static constexpr size_t Count = 18;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ConsoleLogLevel::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ConsoleLogLevel stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ConsoleLogLevelValues

bool
ToJSValue(JSContext* aCx, ConsoleLogLevel aArgument, JS::MutableHandle<JS::Value> aValue);


enum class ConsoleLevel : uint8_t {
  Log,
  Warning,
  Error,
  EndGuard_
};

namespace ConsoleLevelValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ConsoleLevel::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(ConsoleLevel stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace ConsoleLevelValues

bool
ToJSValue(JSContext* aCx, ConsoleLevel aArgument, JS::MutableHandle<JS::Value> aValue);


struct ConsoleCounter : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mCount;
  MOZ_INIT_OUTSIDE_CTOR nsString mLabel;

  ConsoleCounter();

  explicit inline ConsoleCounter(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ConsoleCounter(ConsoleCounter&& aOther) = default;

  explicit inline ConsoleCounter(const ConsoleCounter& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ConsoleCounter&
  operator=(const ConsoleCounter& aOther);

  bool
  operator==(const ConsoleCounter& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ConsoleCounterAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleCounter : public ConsoleCounter
{
  inline FastConsoleCounter()
    : ConsoleCounter(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleCounterError : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mError;
  MOZ_INIT_OUTSIDE_CTOR nsString mLabel;

  ConsoleCounterError();

  explicit inline ConsoleCounterError(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ConsoleCounterError(ConsoleCounterError&& aOther) = default;

  explicit inline ConsoleCounterError(const ConsoleCounterError& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ConsoleCounterError&
  operator=(const ConsoleCounterError& aOther);

  bool
  operator==(const ConsoleCounterError& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ConsoleCounterErrorAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleCounterError : public ConsoleCounterError
{
  inline FastConsoleCounterError()
    : ConsoleCounterError(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ConsoleInstanceDumpCallback : public CallbackFunction
{
public:
  explicit inline ConsoleInstanceDumpCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline ConsoleInstanceDumpCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline ConsoleInstanceDumpCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline ConsoleInstanceDumpCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const nsAString& message, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "ConsoleInstanceDumpCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, message, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const nsAString& message, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "ConsoleInstanceDumpCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, message, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const nsAString& message, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, message, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const nsAString& message, const char* aExecutionReason = nullptr)
  {
    return Call(message, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const ConsoleInstanceDumpCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const nsAString& message, ErrorResult& aRv);
};


namespace binding_detail {
class FastConsoleInstanceDumpCallback : public ConsoleInstanceDumpCallback
{
public:
  explicit inline FastConsoleInstanceDumpCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : ConsoleInstanceDumpCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    ConsoleInstanceDumpCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    ConsoleInstanceDumpCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct ConsoleInstanceOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mConsoleID;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<ConsoleInstanceDumpCallback>> mDump;
  MOZ_INIT_OUTSIDE_CTOR nsString mInnerID;
  MOZ_INIT_OUTSIDE_CTOR Optional<ConsoleLogLevel> mMaxLogLevel;
  MOZ_INIT_OUTSIDE_CTOR nsString mMaxLogLevelPref;
  MOZ_INIT_OUTSIDE_CTOR nsString mPrefix;

  ConsoleInstanceOptions();

  explicit inline ConsoleInstanceOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ConsoleInstanceOptions(ConsoleInstanceOptions&& aOther) = default;

private:
  ConsoleInstanceOptions(const ConsoleInstanceOptions&) = delete;
  ConsoleInstanceOptions& operator=(const ConsoleInstanceOptions&) = delete;

  static bool
  InitIds(JSContext* cx, ConsoleInstanceOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mDump, "mDump", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mDump);
  }
};

namespace binding_detail {
struct FastConsoleInstanceOptions : public ConsoleInstanceOptions
{
  inline FastConsoleInstanceOptions()
    : ConsoleInstanceOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleProfileEvent : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mAction;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<JS::Value>> mArguments;
  MOZ_INIT_OUTSIDE_CTOR bool mChromeContext;

  ConsoleProfileEvent();

  explicit inline ConsoleProfileEvent(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ConsoleProfileEvent(ConsoleProfileEvent&& aOther) = default;

private:
  ConsoleProfileEvent(const ConsoleProfileEvent&) = delete;
  ConsoleProfileEvent& operator=(const ConsoleProfileEvent&) = delete;

  static bool
  InitIds(JSContext* cx, ConsoleProfileEventAtoms* atomsCache);

public:
  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastConsoleProfileEvent : public ConsoleProfileEvent
{
  inline FastConsoleProfileEvent()
    : ConsoleProfileEvent(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleStackEntry : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mAsyncCause;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mColumnNumber;
  MOZ_INIT_OUTSIDE_CTOR nsString mFilename;
  MOZ_INIT_OUTSIDE_CTOR nsString mFunctionName;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mLineNumber;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSourceId;

  ConsoleStackEntry();

  explicit inline ConsoleStackEntry(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ConsoleStackEntry(ConsoleStackEntry&& aOther) = default;

  explicit inline ConsoleStackEntry(const ConsoleStackEntry& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ConsoleStackEntry&
  operator=(const ConsoleStackEntry& aOther);

  bool
  operator==(const ConsoleStackEntry& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ConsoleStackEntryAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleStackEntry : public ConsoleStackEntry
{
  inline FastConsoleStackEntry()
    : ConsoleStackEntry(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleTimerError : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mError;
  MOZ_INIT_OUTSIDE_CTOR nsString mName;

  ConsoleTimerError();

  explicit inline ConsoleTimerError(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ConsoleTimerError(ConsoleTimerError&& aOther) = default;

  explicit inline ConsoleTimerError(const ConsoleTimerError& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ConsoleTimerError&
  operator=(const ConsoleTimerError& aOther);

  bool
  operator==(const ConsoleTimerError& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ConsoleTimerErrorAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleTimerError : public ConsoleTimerError
{
  inline FastConsoleTimerError()
    : ConsoleTimerError(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleTimerLogOrEnd : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR double mDuration;
  MOZ_INIT_OUTSIDE_CTOR nsString mName;

  ConsoleTimerLogOrEnd();

  explicit inline ConsoleTimerLogOrEnd(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ConsoleTimerLogOrEnd(ConsoleTimerLogOrEnd&& aOther) = default;

  explicit inline ConsoleTimerLogOrEnd(const ConsoleTimerLogOrEnd& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ConsoleTimerLogOrEnd&
  operator=(const ConsoleTimerLogOrEnd& aOther);

  bool
  operator==(const ConsoleTimerLogOrEnd& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ConsoleTimerLogOrEndAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleTimerLogOrEnd : public ConsoleTimerLogOrEnd
{
  inline FastConsoleTimerLogOrEnd()
    : ConsoleTimerLogOrEnd(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ConsoleTimerStart : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mName;

  ConsoleTimerStart();

  explicit inline ConsoleTimerStart(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ConsoleTimerStart(ConsoleTimerStart&& aOther) = default;

  explicit inline ConsoleTimerStart(const ConsoleTimerStart& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ConsoleTimerStart&
  operator=(const ConsoleTimerStart& aOther);

  bool
  operator==(const ConsoleTimerStart& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ConsoleTimerStartAtoms* atomsCache);
};

namespace binding_detail {
struct FastConsoleTimerStart : public ConsoleTimerStart
{
  inline FastConsoleTimerStart()
    : ConsoleTimerStart(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UnsignedLongLongOrString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnsignedLongLong,
    eString
  };
public:
  enum class Type
  {
    eUnsignedLongLong = TypeOrUninit::eUnsignedLongLong,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<uint64_t > mUnsignedLongLong;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  UnsignedLongLongOrString(const UnsignedLongLongOrString&) = delete;
  UnsignedLongLongOrString& operator=(const UnsignedLongLongOrString&) = delete;
public:
  explicit inline UnsignedLongLongOrString()
    : mType(eUninitialized)
  {
  }

  inline ~UnsignedLongLongOrString()
  {
    Uninit();
  }

  inline uint64_t&
  RawSetAsUnsignedLongLong()
  {
    if (mType == eUnsignedLongLong) {
      return mValue.mUnsignedLongLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnsignedLongLong;
    return mValue.mUnsignedLongLong.SetValue();
  }

  inline uint64_t&
  SetAsUnsignedLongLong()
  {
    if (mType == eUnsignedLongLong) {
      return mValue.mUnsignedLongLong.Value();
    }
    Uninit();
    mType = eUnsignedLongLong;
    return mValue.mUnsignedLongLong.SetValue();
  }

  inline bool
  IsUnsignedLongLong() const
  {
    return mType == eUnsignedLongLong;
  }

  inline uint64_t&
  GetAsUnsignedLongLong()
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLongLong(), "Wrong type!");
    return mValue.mUnsignedLongLong.Value();
  }

  inline uint64_t
  GetAsUnsignedLongLong() const
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLongLong(), "Wrong type!");
    return mValue.mUnsignedLongLong.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnsignedLongLong: {
        DestroyUnsignedLongLong();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUnsignedLongLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnsignedLongLong()
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLongLong(), "Wrong type!");
    mValue.mUnsignedLongLong.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnsignedLongLongOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUnsignedLongLong,
    eString
  };
public:
  enum class Type
  {
    eUnsignedLongLong = TypeOrUninit::eUnsignedLongLong,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<uint64_t > mUnsignedLongLong;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUnsignedLongLongOrString()
    : mType(eUninitialized)
  {
  }

  OwningUnsignedLongLongOrString(OwningUnsignedLongLongOrString&& aOther);

  explicit inline OwningUnsignedLongLongOrString(const OwningUnsignedLongLongOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnsignedLongLongOrString()
  {
    Uninit();
  }

  uint64_t&
  RawSetAsUnsignedLongLong();

  uint64_t&
  SetAsUnsignedLongLong();

  inline bool
  IsUnsignedLongLong() const
  {
    return mType == eUnsignedLongLong;
  }

  inline uint64_t&
  GetAsUnsignedLongLong()
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLongLong(), "Wrong type!");
    return mValue.mUnsignedLongLong.Value();
  }

  inline uint64_t const &
  GetAsUnsignedLongLong() const
  {
    MOZ_RELEASE_ASSERT(IsUnsignedLongLong(), "Wrong type!");
    return mValue.mUnsignedLongLong.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUnsignedLongLongOrString&
  operator=(OwningUnsignedLongLongOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUnsignedLongLongOrString&
  operator=(const OwningUnsignedLongLongOrString& aOther);

private:
  bool
  TrySetToUnsignedLongLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnsignedLongLong();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};


struct ConsoleEvent : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningUnsignedLongLongOrString> mID;
  MOZ_INIT_OUTSIDE_CTOR nsString mAddonId;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<JS::Value>> mArguments;
  MOZ_INIT_OUTSIDE_CTOR bool mChromeContext;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mColumnNumber;
  MOZ_INIT_OUTSIDE_CTOR nsString mConsoleID;
  MOZ_INIT_OUTSIDE_CTOR JS::Value mCounter;
  MOZ_INIT_OUTSIDE_CTOR nsString mFilename;
  MOZ_INIT_OUTSIDE_CTOR nsString mFunctionName;
  MOZ_INIT_OUTSIDE_CTOR nsString mGroupName;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningUnsignedLongLongOrString> mInnerID;
  MOZ_INIT_OUTSIDE_CTOR nsString mLevel;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mLineNumber;
  MOZ_INIT_OUTSIDE_CTOR double mMicroSecondTimeStamp;
  MOZ_INIT_OUTSIDE_CTOR nsString mPrefix;
  MOZ_INIT_OUTSIDE_CTOR bool mPrivate;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSourceId;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mStyles;
  MOZ_INIT_OUTSIDE_CTOR double mTimeStamp;
  MOZ_INIT_OUTSIDE_CTOR JS::Value mTimer;

  ConsoleEvent();

  explicit inline ConsoleEvent(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ConsoleEvent(ConsoleEvent&& aOther) = default;

private:
  ConsoleEvent(const ConsoleEvent&) = delete;
  ConsoleEvent& operator=(const ConsoleEvent&) = delete;

  static bool
  InitIds(JSContext* cx, ConsoleEventAtoms* atomsCache);

public:
  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastConsoleEvent : public ConsoleEvent
{
  inline FastConsoleEvent()
    : ConsoleEvent(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ConsoleInstance_Binding {

  typedef mozilla::dom::ConsoleInstance NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::ConsoleInstance* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::ConsoleInstance,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::ConsoleInstance,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::ConsoleInstance,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace ConsoleInstance_Binding



namespace console_Binding {

  typedef mozilla::dom::Console NativeType;

  static const bool IS_NATIVE_CONSOLE = true;
  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::console,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::console,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace console_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_ConsoleBinding_h
