/* THIS FILE IS AUTOGENERATED FROM WebGPU.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_WebGPUBinding_h
#define mozilla_dom_WebGPUBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/webgpu/BindGroupLayout.h"
#include "mozilla/webgpu/Buffer.h"
#include "mozilla/webgpu/Device.h"
#include "mozilla/webgpu/QuerySet.h"
#include "mozilla/webgpu/ShaderModule.h"
#include "mozilla/webgpu/Texture.h"
#include "mozilla/webgpu/TextureView.h"

namespace mozilla {

namespace dom {

class DoubleSequenceOrGPUColorDict;
struct GPUBindGroupDescriptorAtoms;
struct GPUBindGroupEntry;
struct GPUBindGroupEntryAtoms;
struct GPUBindGroupLayoutDescriptorAtoms;
struct GPUBindGroupLayoutEntry;
struct GPUBindGroupLayoutEntryAtoms;
struct GPUBlendComponent;
struct GPUBlendComponentAtoms;
struct GPUBlendState;
struct GPUBlendStateAtoms;
struct GPUBufferBindingAtoms;
struct GPUBufferBindingLayout;
struct GPUBufferBindingLayoutAtoms;
struct GPUBufferDescriptorAtoms;
class GPUBufferUsage;
struct GPUCanvasConfigurationAtoms;
struct GPUColorDictAtoms;
struct GPUColorTargetState;
struct GPUColorTargetStateAtoms;
class GPUColorWrite;
struct GPUComputePipelineDescriptorAtoms;
struct GPUDepthStencilState;
struct GPUDepthStencilStateAtoms;
struct GPUDeviceDescriptorAtoms;
struct GPUExtent3DDictAtoms;
struct GPUFragmentState;
struct GPUFragmentStateAtoms;
struct GPUImageBitmapCopyViewAtoms;
struct GPUImageCopyBufferAtoms;
struct GPUImageCopyExternalImageAtoms;
struct GPUImageCopyTextureAtoms;
struct GPUImageCopyTextureTaggedAtoms;
struct GPUImageDataLayoutAtoms;
class GPUMapMode;
struct GPUMultisampleState;
struct GPUMultisampleStateAtoms;
struct GPUObjectDescriptorBaseAtoms;
struct GPUOrigin2DDictAtoms;
struct GPUOrigin3DDictAtoms;
struct GPUPipelineDescriptorBaseAtoms;
struct GPUPipelineLayoutDescriptorAtoms;
class GPUPipelineLayoutOrGPUAutoLayoutMode;
struct GPUPrimitiveState;
struct GPUPrimitiveStateAtoms;
struct GPUProgrammableStage;
struct GPUProgrammableStageAtoms;
struct GPUQuerySetDescriptorAtoms;
struct GPURenderBundleEncoderDescriptorAtoms;
struct GPURenderPassColorAttachment;
struct GPURenderPassColorAttachmentAtoms;
struct GPURenderPassDepthStencilAttachment;
struct GPURenderPassDepthStencilAttachmentAtoms;
struct GPURenderPassDescriptorAtoms;
struct GPURenderPassLayoutAtoms;
struct GPURenderPipelineDescriptorAtoms;
struct GPURequestAdapterOptionsAtoms;
struct GPUSamplerBindingLayout;
struct GPUSamplerBindingLayoutAtoms;
struct GPUSamplerDescriptorAtoms;
class GPUSamplerOrGPUTextureViewOrGPUBufferBinding;
struct GPUShaderModuleDescriptorAtoms;
class GPUShaderStage;
struct GPUStencilFaceState;
struct GPUStencilFaceStateAtoms;
struct GPUStorageTextureBindingLayout;
struct GPUStorageTextureBindingLayoutAtoms;
struct GPUTextureBindingLayout;
struct GPUTextureBindingLayoutAtoms;
struct GPUTextureDescriptorAtoms;
class GPUTextureUsage;
struct GPUTextureViewDescriptorAtoms;
struct GPUVertexAttribute;
struct GPUVertexAttributeAtoms;
struct GPUVertexBufferLayout;
struct GPUVertexBufferLayoutAtoms;
struct GPUVertexState;
struct GPUVertexStateAtoms;
class HTMLCanvasElement;
class ImageBitmap;
class ImageBitmapOrHTMLCanvasElementOrOffscreenCanvas;
struct NativePropertyHooks;
class OffscreenCanvas;
class OwningDoubleSequenceOrGPUColorDict;
class OwningGPUOutOfMemoryErrorOrGPUValidationError;
class OwningGPUPipelineLayoutOrGPUAutoLayoutMode;
class OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding;
class OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas;
class OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict;
class OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict;
class OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict;
class ProtoAndIfaceCache;
class RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict;
class RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict;
class RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict;

} // namespace dom

namespace webgpu {

class Adapter;
class AdapterInfo;
class BindGroup;
class BindGroupLayout;
class Buffer;
class CanvasContext;
class CommandBuffer;
class CommandEncoder;
class CompilationInfo;
class CompilationMessage;
class ComputePassEncoder;
class ComputePipeline;
class Device;
class DeviceLostInfo;
class Instance;
class OutOfMemoryError;
class PipelineLayout;
class QuerySet;
class Queue;
class RenderBundle;
class RenderBundleEncoder;
class RenderPassEncoder;
class RenderPipeline;
class Sampler;
class ShaderModule;
class SupportedFeatures;
class SupportedLimits;
class Texture;
class TextureView;
class ValidationError;

} // namespace webgpu

} // namespace mozilla

namespace mozilla::dom {

enum class GPUPowerPreference : uint8_t {
  Low_power,
  High_performance,
  EndGuard_
};

namespace GPUPowerPreferenceValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUPowerPreference::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUPowerPreference stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUPowerPreferenceValues

bool
ToJSValue(JSContext* aCx, GPUPowerPreference aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUFeatureName : uint8_t {
  Depth_clip_control,
  Depth24unorm_stencil8,
  Depth32float_stencil8,
  Pipeline_statistics_query,
  Texture_compression_bc,
  Texture_compression_etc2,
  Texture_compression_astc,
  Timestamp_query,
  Indirect_first_instance,
  EndGuard_
};

namespace GPUFeatureNameValues {
extern const EnumEntry strings[10];

static constexpr size_t Count = 9;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUFeatureName::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUFeatureName stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUFeatureNameValues

bool
ToJSValue(JSContext* aCx, GPUFeatureName aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBufferMapState : uint8_t {
  Unmapped,
  Pending,
  Mapped,
  EndGuard_
};

namespace GPUBufferMapStateValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUBufferMapState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUBufferMapState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUBufferMapStateValues

bool
ToJSValue(JSContext* aCx, GPUBufferMapState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureDimension : uint8_t {
  _1d,
  _2d,
  _3d,
  EndGuard_
};

namespace GPUTextureDimensionValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureDimension::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUTextureDimension stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUTextureDimensionValues

bool
ToJSValue(JSContext* aCx, GPUTextureDimension aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureComponentType : uint8_t {
  Float,
  Sint,
  Uint,
  Depth_comparison,
  EndGuard_
};

namespace GPUTextureComponentTypeValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureComponentType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUTextureComponentType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUTextureComponentTypeValues

bool
ToJSValue(JSContext* aCx, GPUTextureComponentType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureViewDimension : uint8_t {
  _1d,
  _2d,
  _2d_array,
  Cube,
  Cube_array,
  _3d,
  EndGuard_
};

namespace GPUTextureViewDimensionValues {
extern const EnumEntry strings[7];

static constexpr size_t Count = 6;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureViewDimension::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUTextureViewDimension stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUTextureViewDimensionValues

bool
ToJSValue(JSContext* aCx, GPUTextureViewDimension aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureAspect : uint8_t {
  All,
  Stencil_only,
  Depth_only,
  EndGuard_
};

namespace GPUTextureAspectValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureAspect::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUTextureAspect stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUTextureAspectValues

bool
ToJSValue(JSContext* aCx, GPUTextureAspect aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureFormat : uint8_t {
  R8unorm,
  R8snorm,
  R8uint,
  R8sint,
  R16uint,
  R16sint,
  R16float,
  Rg8unorm,
  Rg8snorm,
  Rg8uint,
  Rg8sint,
  R32uint,
  R32sint,
  R32float,
  Rg16uint,
  Rg16sint,
  Rg16float,
  Rgba8unorm,
  Rgba8unorm_srgb,
  Rgba8snorm,
  Rgba8uint,
  Rgba8sint,
  Bgra8unorm,
  Bgra8unorm_srgb,
  Rgb9e5ufloat,
  Rgb10a2unorm,
  Rg11b10float,
  Rg32uint,
  Rg32sint,
  Rg32float,
  Rgba16uint,
  Rgba16sint,
  Rgba16float,
  Rgba32uint,
  Rgba32sint,
  Rgba32float,
  Depth24plus,
  Depth24plus_stencil8,
  Depth32float,
  Depth32float_stencil8,
  Bc1_rgba_unorm,
  Bc1_rgba_unorm_srgb,
  Bc2_rgba_unorm,
  Bc2_rgba_unorm_srgb,
  Bc3_rgba_unorm,
  Bc3_rgba_unorm_srgb,
  Bc4_r_unorm,
  Bc4_r_snorm,
  Bc5_rg_unorm,
  Bc5_rg_snorm,
  Bc6h_rgb_ufloat,
  Bc6h_rgb_float,
  Bc7_rgba_unorm,
  Bc7_rgba_unorm_srgb,
  EndGuard_
};

namespace GPUTextureFormatValues {
extern const EnumEntry strings[55];

static constexpr size_t Count = 54;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureFormat::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUTextureFormat stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUTextureFormatValues

bool
ToJSValue(JSContext* aCx, GPUTextureFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUAddressMode : uint8_t {
  Clamp_to_edge,
  Repeat,
  Mirror_repeat,
  EndGuard_
};

namespace GPUAddressModeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUAddressMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUAddressMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUAddressModeValues

bool
ToJSValue(JSContext* aCx, GPUAddressMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUFilterMode : uint8_t {
  Nearest,
  Linear,
  EndGuard_
};

namespace GPUFilterModeValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUFilterMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUFilterMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUFilterModeValues

bool
ToJSValue(JSContext* aCx, GPUFilterMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUCompareFunction : uint8_t {
  Never,
  Less,
  Equal,
  Less_equal,
  Greater,
  Not_equal,
  Greater_equal,
  Always,
  EndGuard_
};

namespace GPUCompareFunctionValues {
extern const EnumEntry strings[9];

static constexpr size_t Count = 8;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUCompareFunction::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUCompareFunction stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUCompareFunctionValues

bool
ToJSValue(JSContext* aCx, GPUCompareFunction aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBufferBindingType : uint8_t {
  Uniform,
  Storage,
  Read_only_storage,
  EndGuard_
};

namespace GPUBufferBindingTypeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUBufferBindingType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUBufferBindingType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUBufferBindingTypeValues

bool
ToJSValue(JSContext* aCx, GPUBufferBindingType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUSamplerBindingType : uint8_t {
  Filtering,
  Non_filtering,
  Comparison,
  EndGuard_
};

namespace GPUSamplerBindingTypeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUSamplerBindingType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUSamplerBindingType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUSamplerBindingTypeValues

bool
ToJSValue(JSContext* aCx, GPUSamplerBindingType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureSampleType : uint8_t {
  Float,
  Unfilterable_float,
  Depth,
  Sint,
  Uint,
  EndGuard_
};

namespace GPUTextureSampleTypeValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureSampleType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUTextureSampleType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUTextureSampleTypeValues

bool
ToJSValue(JSContext* aCx, GPUTextureSampleType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUStorageTextureAccess : uint8_t {
  Write_only,
  EndGuard_
};

namespace GPUStorageTextureAccessValues {
extern const EnumEntry strings[2];

static constexpr size_t Count = 1;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUStorageTextureAccess::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUStorageTextureAccess stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUStorageTextureAccessValues

bool
ToJSValue(JSContext* aCx, GPUStorageTextureAccess aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUCompilationMessageType : uint8_t {
  Error,
  Warning,
  Info,
  EndGuard_
};

namespace GPUCompilationMessageTypeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUCompilationMessageType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUCompilationMessageType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUCompilationMessageTypeValues

bool
ToJSValue(JSContext* aCx, GPUCompilationMessageType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUAutoLayoutMode : uint8_t {
  Auto,
  EndGuard_
};

namespace GPUAutoLayoutModeValues {
extern const EnumEntry strings[2];

static constexpr size_t Count = 1;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUAutoLayoutMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUAutoLayoutMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUAutoLayoutModeValues

bool
ToJSValue(JSContext* aCx, GPUAutoLayoutMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUPrimitiveTopology : uint8_t {
  Point_list,
  Line_list,
  Line_strip,
  Triangle_list,
  Triangle_strip,
  EndGuard_
};

namespace GPUPrimitiveTopologyValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUPrimitiveTopology::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUPrimitiveTopology stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUPrimitiveTopologyValues

bool
ToJSValue(JSContext* aCx, GPUPrimitiveTopology aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUFrontFace : uint8_t {
  Ccw,
  Cw,
  EndGuard_
};

namespace GPUFrontFaceValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUFrontFace::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUFrontFace stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUFrontFaceValues

bool
ToJSValue(JSContext* aCx, GPUFrontFace aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUCullMode : uint8_t {
  None,
  Front,
  Back,
  EndGuard_
};

namespace GPUCullModeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUCullMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUCullMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUCullModeValues

bool
ToJSValue(JSContext* aCx, GPUCullMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBlendFactor : uint8_t {
  Zero,
  One,
  Src,
  One_minus_src,
  Src_alpha,
  One_minus_src_alpha,
  Dst,
  One_minus_dst,
  Dst_alpha,
  One_minus_dst_alpha,
  Src_alpha_saturated,
  Constant,
  One_minus_constant,
  EndGuard_
};

namespace GPUBlendFactorValues {
extern const EnumEntry strings[14];

static constexpr size_t Count = 13;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUBlendFactor::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUBlendFactor stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUBlendFactorValues

bool
ToJSValue(JSContext* aCx, GPUBlendFactor aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBlendOperation : uint8_t {
  Add,
  Subtract,
  Reverse_subtract,
  Min,
  Max,
  EndGuard_
};

namespace GPUBlendOperationValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUBlendOperation::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUBlendOperation stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUBlendOperationValues

bool
ToJSValue(JSContext* aCx, GPUBlendOperation aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUStencilOperation : uint8_t {
  Keep,
  Zero,
  Replace,
  Invert,
  Increment_clamp,
  Decrement_clamp,
  Increment_wrap,
  Decrement_wrap,
  EndGuard_
};

namespace GPUStencilOperationValues {
extern const EnumEntry strings[9];

static constexpr size_t Count = 8;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUStencilOperation::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUStencilOperation stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUStencilOperationValues

bool
ToJSValue(JSContext* aCx, GPUStencilOperation aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUIndexFormat : uint8_t {
  Uint16,
  Uint32,
  EndGuard_
};

namespace GPUIndexFormatValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUIndexFormat::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUIndexFormat stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUIndexFormatValues

bool
ToJSValue(JSContext* aCx, GPUIndexFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUVertexFormat : uint8_t {
  Uint8x2,
  Uint8x4,
  Sint8x2,
  Sint8x4,
  Unorm8x2,
  Unorm8x4,
  Snorm8x2,
  Snorm8x4,
  Uint16x2,
  Uint16x4,
  Sint16x2,
  Sint16x4,
  Unorm16x2,
  Unorm16x4,
  Snorm16x2,
  Snorm16x4,
  Float16x2,
  Float16x4,
  Float32,
  Float32x2,
  Float32x3,
  Float32x4,
  Uint32,
  Uint32x2,
  Uint32x3,
  Uint32x4,
  Sint32,
  Sint32x2,
  Sint32x3,
  Sint32x4,
  EndGuard_
};

namespace GPUVertexFormatValues {
extern const EnumEntry strings[31];

static constexpr size_t Count = 30;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUVertexFormat::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUVertexFormat stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUVertexFormatValues

bool
ToJSValue(JSContext* aCx, GPUVertexFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUVertexStepMode : uint8_t {
  Vertex,
  Instance,
  EndGuard_
};

namespace GPUVertexStepModeValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUVertexStepMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUVertexStepMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUVertexStepModeValues

bool
ToJSValue(JSContext* aCx, GPUVertexStepMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPULoadOp : uint8_t {
  Load,
  Clear,
  EndGuard_
};

namespace GPULoadOpValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPULoadOp::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPULoadOp stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPULoadOpValues

bool
ToJSValue(JSContext* aCx, GPULoadOp aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUStoreOp : uint8_t {
  Store,
  Discard,
  EndGuard_
};

namespace GPUStoreOpValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUStoreOp::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUStoreOp stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUStoreOpValues

bool
ToJSValue(JSContext* aCx, GPUStoreOp aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUPipelineStatisticName : uint8_t {
  Vertex_shader_invocations,
  Clipper_invocations,
  Clipper_primitives_out,
  Fragment_shader_invocations,
  Compute_shader_invocations,
  EndGuard_
};

namespace GPUPipelineStatisticNameValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUPipelineStatisticName::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUPipelineStatisticName stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUPipelineStatisticNameValues

bool
ToJSValue(JSContext* aCx, GPUPipelineStatisticName aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUQueryType : uint8_t {
  Occlusion,
  Pipeline_statistics,
  Timestamp,
  EndGuard_
};

namespace GPUQueryTypeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUQueryType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUQueryType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUQueryTypeValues

bool
ToJSValue(JSContext* aCx, GPUQueryType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUCanvasCompositingAlphaMode : uint8_t {
  Opaque,
  Premultiplied,
  EndGuard_
};

namespace GPUCanvasCompositingAlphaModeValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUCanvasCompositingAlphaMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUCanvasCompositingAlphaMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUCanvasCompositingAlphaModeValues

bool
ToJSValue(JSContext* aCx, GPUCanvasCompositingAlphaMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUDeviceLostReason : uint8_t {
  Destroyed,
  EndGuard_
};

namespace GPUDeviceLostReasonValues {
extern const EnumEntry strings[2];

static constexpr size_t Count = 1;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUDeviceLostReason::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUDeviceLostReason stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUDeviceLostReasonValues

bool
ToJSValue(JSContext* aCx, GPUDeviceLostReason aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUErrorFilter : uint8_t {
  Out_of_memory,
  Validation,
  EndGuard_
};

namespace GPUErrorFilterValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUErrorFilter::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(GPUErrorFilter stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace GPUErrorFilterValues

bool
ToJSValue(JSContext* aCx, GPUErrorFilter aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningGPUOutOfMemoryErrorOrGPUValidationError& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningGPUPipelineLayoutOrGPUAutoLayoutMode& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningGPUOutOfMemoryErrorOrGPUValidationError& aUnion);


void
ImplCycleCollectionUnlink(OwningGPUPipelineLayoutOrGPUAutoLayoutMode& aUnion);


void
ImplCycleCollectionUnlink(OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aUnion);


void
ImplCycleCollectionUnlink(OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas& aUnion);


struct GPUBlendComponent : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUBlendFactor mDstFactor;
  MOZ_INIT_OUTSIDE_CTOR GPUBlendOperation mOperation;
  MOZ_INIT_OUTSIDE_CTOR GPUBlendFactor mSrcFactor;

  GPUBlendComponent();

  explicit inline GPUBlendComponent(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBlendComponent(GPUBlendComponent&& aOther) = default;

  explicit inline GPUBlendComponent(const GPUBlendComponent& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBlendComponent&
  operator=(const GPUBlendComponent& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBlendComponentAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBlendComponent : public GPUBlendComponent
{
  inline FastGPUBlendComponent()
    : GPUBlendComponent(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBufferBinding : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Buffer> mBuffer;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mSize;

  GPUBufferBinding();

  explicit inline GPUBufferBinding(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBufferBinding(GPUBufferBinding&& aOther) = default;

  explicit inline GPUBufferBinding(const GPUBufferBinding& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBuffer, "mBuffer", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBuffer);
  }

  GPUBufferBinding&
  operator=(const GPUBufferBinding& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBufferBindingAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBufferBinding : public GPUBufferBinding
{
  inline FastGPUBufferBinding()
    : GPUBufferBinding(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBufferBindingLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mHasDynamicOffset;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mMinBindingSize;
  MOZ_INIT_OUTSIDE_CTOR GPUBufferBindingType mType;

  GPUBufferBindingLayout();

  explicit inline GPUBufferBindingLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBufferBindingLayout(GPUBufferBindingLayout&& aOther) = default;

  explicit inline GPUBufferBindingLayout(const GPUBufferBindingLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBufferBindingLayout&
  operator=(const GPUBufferBindingLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBufferBindingLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBufferBindingLayout : public GPUBufferBindingLayout
{
  inline FastGPUBufferBindingLayout()
    : GPUBufferBindingLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUCanvasConfiguration : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUCanvasCompositingAlphaMode mCompositingAlphaMode;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Device> mDevice;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUsage;

  GPUCanvasConfiguration();

  explicit inline GPUCanvasConfiguration(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUCanvasConfiguration(GPUCanvasConfiguration&& aOther) = default;

  explicit inline GPUCanvasConfiguration(const GPUCanvasConfiguration& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mDevice, "mDevice", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mDevice);
  }

  GPUCanvasConfiguration&
  operator=(const GPUCanvasConfiguration& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUCanvasConfigurationAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUCanvasConfiguration : public GPUCanvasConfiguration
{
  inline FastGPUCanvasConfiguration()
    : GPUCanvasConfiguration(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUColorDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR double mA;
  MOZ_INIT_OUTSIDE_CTOR double mB;
  MOZ_INIT_OUTSIDE_CTOR double mG;
  MOZ_INIT_OUTSIDE_CTOR double mR;

  GPUColorDict();

  explicit inline GPUColorDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUColorDict(GPUColorDict&& aOther) = default;

  explicit inline GPUColorDict(const GPUColorDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUColorDict&
  operator=(const GPUColorDict& aOther);

  bool
  operator==(const GPUColorDict& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUColorDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUColorDict : public GPUColorDict
{
  inline FastGPUColorDict()
    : GPUColorDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUDeviceDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUFeatureName> mRequiredFeatures;
  MOZ_INIT_OUTSIDE_CTOR Optional<Record<nsString, uint64_t>> mRequiredLimits;

  GPUDeviceDescriptor();

  explicit inline GPUDeviceDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUDeviceDescriptor(GPUDeviceDescriptor&& aOther) = default;

private:
  GPUDeviceDescriptor(const GPUDeviceDescriptor&) = delete;
  GPUDeviceDescriptor& operator=(const GPUDeviceDescriptor&) = delete;

  static bool
  InitIds(JSContext* cx, GPUDeviceDescriptorAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastGPUDeviceDescriptor : public GPUDeviceDescriptor
{
  inline FastGPUDeviceDescriptor()
    : GPUDeviceDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUExtent3DDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mDepthOrArrayLayers;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mHeight;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWidth;

  GPUExtent3DDict();

  explicit inline GPUExtent3DDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUExtent3DDict(GPUExtent3DDict&& aOther) = default;

  explicit inline GPUExtent3DDict(const GPUExtent3DDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUExtent3DDict&
  operator=(const GPUExtent3DDict& aOther);

  bool
  operator==(const GPUExtent3DDict& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUExtent3DDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUExtent3DDict : public GPUExtent3DDict
{
  inline FastGPUExtent3DDict()
    : GPUExtent3DDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUImageDataLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mBytesPerRow;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mRowsPerImage;

  GPUImageDataLayout();

  explicit inline GPUImageDataLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUImageDataLayout(GPUImageDataLayout&& aOther) = default;

  explicit inline GPUImageDataLayout(const GPUImageDataLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUImageDataLayout&
  operator=(const GPUImageDataLayout& aOther);

  bool
  operator==(const GPUImageDataLayout& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUImageDataLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUImageDataLayout : public GPUImageDataLayout
{
  inline FastGPUImageDataLayout()
    : GPUImageDataLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUMultisampleState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mAlphaToCoverageEnabled;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mCount;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMask;

  GPUMultisampleState();

  explicit inline GPUMultisampleState(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUMultisampleState(GPUMultisampleState&& aOther) = default;

  explicit inline GPUMultisampleState(const GPUMultisampleState& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUMultisampleState&
  operator=(const GPUMultisampleState& aOther);

  bool
  operator==(const GPUMultisampleState& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUMultisampleStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUMultisampleState : public GPUMultisampleState
{
  inline FastGPUMultisampleState()
    : GPUMultisampleState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUObjectDescriptorBase : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mLabel;

  GPUObjectDescriptorBase();

  explicit inline GPUObjectDescriptorBase(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUObjectDescriptorBase(GPUObjectDescriptorBase&& aOther) = default;

  explicit inline GPUObjectDescriptorBase(const GPUObjectDescriptorBase& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUObjectDescriptorBase&
  operator=(const GPUObjectDescriptorBase& aOther);

  bool
  operator==(const GPUObjectDescriptorBase& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUObjectDescriptorBaseAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUObjectDescriptorBase : public GPUObjectDescriptorBase
{
  inline FastGPUObjectDescriptorBase()
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUOrigin2DDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mX;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mY;

  GPUOrigin2DDict();

  explicit inline GPUOrigin2DDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUOrigin2DDict(GPUOrigin2DDict&& aOther) = default;

  explicit inline GPUOrigin2DDict(const GPUOrigin2DDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUOrigin2DDict&
  operator=(const GPUOrigin2DDict& aOther);

  bool
  operator==(const GPUOrigin2DDict& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUOrigin2DDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUOrigin2DDict : public GPUOrigin2DDict
{
  inline FastGPUOrigin2DDict()
    : GPUOrigin2DDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUOrigin3DDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mX;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mY;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mZ;

  GPUOrigin3DDict();

  explicit inline GPUOrigin3DDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUOrigin3DDict(GPUOrigin3DDict&& aOther) = default;

  explicit inline GPUOrigin3DDict(const GPUOrigin3DDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUOrigin3DDict&
  operator=(const GPUOrigin3DDict& aOther);

  bool
  operator==(const GPUOrigin3DDict& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUOrigin3DDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUOrigin3DDict : public GPUOrigin3DDict
{
  inline FastGPUOrigin3DDict()
    : GPUOrigin3DDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class GPUOutOfMemoryErrorOrGPUValidationError
{
  enum TypeOrUninit
  {
    eUninitialized,
    eGPUOutOfMemoryError,
    eGPUValidationError
  };
public:
  enum class Type
  {
    eGPUOutOfMemoryError = TypeOrUninit::eGPUOutOfMemoryError,
    eGPUValidationError = TypeOrUninit::eGPUValidationError
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::webgpu::OutOfMemoryError> > mGPUOutOfMemoryError;
    UnionMember<NonNull<mozilla::webgpu::ValidationError> > mGPUValidationError;

  };

  TypeOrUninit mType;
  Value mValue;

  GPUOutOfMemoryErrorOrGPUValidationError(const GPUOutOfMemoryErrorOrGPUValidationError&) = delete;
  GPUOutOfMemoryErrorOrGPUValidationError& operator=(const GPUOutOfMemoryErrorOrGPUValidationError&) = delete;
public:
  explicit inline GPUOutOfMemoryErrorOrGPUValidationError()
    : mType(eUninitialized)
  {
  }

  inline ~GPUOutOfMemoryErrorOrGPUValidationError()
  {
    Uninit();
  }

  inline NonNull<mozilla::webgpu::OutOfMemoryError>&
  RawSetAsGPUOutOfMemoryError()
  {
    if (mType == eGPUOutOfMemoryError) {
      return mValue.mGPUOutOfMemoryError.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUOutOfMemoryError;
    return mValue.mGPUOutOfMemoryError.SetValue();
  }

  inline NonNull<mozilla::webgpu::OutOfMemoryError>&
  SetAsGPUOutOfMemoryError()
  {
    if (mType == eGPUOutOfMemoryError) {
      return mValue.mGPUOutOfMemoryError.Value();
    }
    Uninit();
    mType = eGPUOutOfMemoryError;
    return mValue.mGPUOutOfMemoryError.SetValue();
  }

  inline bool
  IsGPUOutOfMemoryError() const
  {
    return mType == eGPUOutOfMemoryError;
  }

  inline NonNull<mozilla::webgpu::OutOfMemoryError>&
  GetAsGPUOutOfMemoryError()
  {
    MOZ_RELEASE_ASSERT(IsGPUOutOfMemoryError(), "Wrong type!");
    return mValue.mGPUOutOfMemoryError.Value();
  }

  inline mozilla::webgpu::OutOfMemoryError&
  GetAsGPUOutOfMemoryError() const
  {
    MOZ_RELEASE_ASSERT(IsGPUOutOfMemoryError(), "Wrong type!");
    return mValue.mGPUOutOfMemoryError.Value();
  }

  inline NonNull<mozilla::webgpu::ValidationError>&
  RawSetAsGPUValidationError()
  {
    if (mType == eGPUValidationError) {
      return mValue.mGPUValidationError.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUValidationError;
    return mValue.mGPUValidationError.SetValue();
  }

  inline NonNull<mozilla::webgpu::ValidationError>&
  SetAsGPUValidationError()
  {
    if (mType == eGPUValidationError) {
      return mValue.mGPUValidationError.Value();
    }
    Uninit();
    mType = eGPUValidationError;
    return mValue.mGPUValidationError.SetValue();
  }

  inline bool
  IsGPUValidationError() const
  {
    return mType == eGPUValidationError;
  }

  inline NonNull<mozilla::webgpu::ValidationError>&
  GetAsGPUValidationError()
  {
    MOZ_RELEASE_ASSERT(IsGPUValidationError(), "Wrong type!");
    return mValue.mGPUValidationError.Value();
  }

  inline mozilla::webgpu::ValidationError&
  GetAsGPUValidationError() const
  {
    MOZ_RELEASE_ASSERT(IsGPUValidationError(), "Wrong type!");
    return mValue.mGPUValidationError.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eGPUOutOfMemoryError: {
        DestroyGPUOutOfMemoryError();
        break;
      }
      case eGPUValidationError: {
        DestroyGPUValidationError();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToGPUOutOfMemoryError(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOutOfMemoryError(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUOutOfMemoryError()
  {
    MOZ_RELEASE_ASSERT(IsGPUOutOfMemoryError(), "Wrong type!");
    mValue.mGPUOutOfMemoryError.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUValidationError(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUValidationError(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUValidationError()
  {
    MOZ_RELEASE_ASSERT(IsGPUValidationError(), "Wrong type!");
    mValue.mGPUValidationError.Destroy();
    mType = eUninitialized;
  }
};


class OwningGPUOutOfMemoryErrorOrGPUValidationError : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningGPUOutOfMemoryErrorOrGPUValidationError& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eGPUOutOfMemoryError,
    eGPUValidationError
  };
public:
  enum class Type
  {
    eGPUOutOfMemoryError = TypeOrUninit::eGPUOutOfMemoryError,
    eGPUValidationError = TypeOrUninit::eGPUValidationError
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::webgpu::OutOfMemoryError> > mGPUOutOfMemoryError;
    UnionMember<OwningNonNull<mozilla::webgpu::ValidationError> > mGPUValidationError;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningGPUOutOfMemoryErrorOrGPUValidationError()
    : mType(eUninitialized)
  {
  }

  OwningGPUOutOfMemoryErrorOrGPUValidationError(OwningGPUOutOfMemoryErrorOrGPUValidationError&& aOther);

  explicit inline OwningGPUOutOfMemoryErrorOrGPUValidationError(const OwningGPUOutOfMemoryErrorOrGPUValidationError& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningGPUOutOfMemoryErrorOrGPUValidationError()
  {
    Uninit();
  }

  OwningNonNull<mozilla::webgpu::OutOfMemoryError>&
  RawSetAsGPUOutOfMemoryError();

  OwningNonNull<mozilla::webgpu::OutOfMemoryError>&
  SetAsGPUOutOfMemoryError();

  inline bool
  IsGPUOutOfMemoryError() const
  {
    return mType == eGPUOutOfMemoryError;
  }

  inline OwningNonNull<mozilla::webgpu::OutOfMemoryError>&
  GetAsGPUOutOfMemoryError()
  {
    MOZ_RELEASE_ASSERT(IsGPUOutOfMemoryError(), "Wrong type!");
    return mValue.mGPUOutOfMemoryError.Value();
  }

  inline OwningNonNull<mozilla::webgpu::OutOfMemoryError> const &
  GetAsGPUOutOfMemoryError() const
  {
    MOZ_RELEASE_ASSERT(IsGPUOutOfMemoryError(), "Wrong type!");
    return mValue.mGPUOutOfMemoryError.Value();
  }

  OwningNonNull<mozilla::webgpu::ValidationError>&
  RawSetAsGPUValidationError();

  OwningNonNull<mozilla::webgpu::ValidationError>&
  SetAsGPUValidationError();

  inline bool
  IsGPUValidationError() const
  {
    return mType == eGPUValidationError;
  }

  inline OwningNonNull<mozilla::webgpu::ValidationError>&
  GetAsGPUValidationError()
  {
    MOZ_RELEASE_ASSERT(IsGPUValidationError(), "Wrong type!");
    return mValue.mGPUValidationError.Value();
  }

  inline OwningNonNull<mozilla::webgpu::ValidationError> const &
  GetAsGPUValidationError() const
  {
    MOZ_RELEASE_ASSERT(IsGPUValidationError(), "Wrong type!");
    return mValue.mGPUValidationError.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningGPUOutOfMemoryErrorOrGPUValidationError&
  operator=(OwningGPUOutOfMemoryErrorOrGPUValidationError&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningGPUOutOfMemoryErrorOrGPUValidationError&
  operator=(const OwningGPUOutOfMemoryErrorOrGPUValidationError& aOther);

private:
  bool
  TrySetToGPUOutOfMemoryError(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOutOfMemoryError(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUOutOfMemoryError();

  bool
  TrySetToGPUValidationError(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUValidationError(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUValidationError();
};


class GPUPipelineLayoutOrGPUAutoLayoutMode
{
  enum TypeOrUninit
  {
    eUninitialized,
    eGPUPipelineLayout,
    eGPUAutoLayoutMode
  };
public:
  enum class Type
  {
    eGPUPipelineLayout = TypeOrUninit::eGPUPipelineLayout,
    eGPUAutoLayoutMode = TypeOrUninit::eGPUAutoLayoutMode
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::webgpu::PipelineLayout> > mGPUPipelineLayout;
    UnionMember<GPUAutoLayoutMode > mGPUAutoLayoutMode;

  };

  TypeOrUninit mType;
  Value mValue;

  GPUPipelineLayoutOrGPUAutoLayoutMode(const GPUPipelineLayoutOrGPUAutoLayoutMode&) = delete;
  GPUPipelineLayoutOrGPUAutoLayoutMode& operator=(const GPUPipelineLayoutOrGPUAutoLayoutMode&) = delete;
public:
  explicit inline GPUPipelineLayoutOrGPUAutoLayoutMode()
    : mType(eUninitialized)
  {
  }

  inline ~GPUPipelineLayoutOrGPUAutoLayoutMode()
  {
    Uninit();
  }

  inline NonNull<mozilla::webgpu::PipelineLayout>&
  RawSetAsGPUPipelineLayout()
  {
    if (mType == eGPUPipelineLayout) {
      return mValue.mGPUPipelineLayout.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUPipelineLayout;
    return mValue.mGPUPipelineLayout.SetValue();
  }

  inline NonNull<mozilla::webgpu::PipelineLayout>&
  SetAsGPUPipelineLayout()
  {
    if (mType == eGPUPipelineLayout) {
      return mValue.mGPUPipelineLayout.Value();
    }
    Uninit();
    mType = eGPUPipelineLayout;
    return mValue.mGPUPipelineLayout.SetValue();
  }

  inline bool
  IsGPUPipelineLayout() const
  {
    return mType == eGPUPipelineLayout;
  }

  inline NonNull<mozilla::webgpu::PipelineLayout>&
  GetAsGPUPipelineLayout()
  {
    MOZ_RELEASE_ASSERT(IsGPUPipelineLayout(), "Wrong type!");
    return mValue.mGPUPipelineLayout.Value();
  }

  inline mozilla::webgpu::PipelineLayout&
  GetAsGPUPipelineLayout() const
  {
    MOZ_RELEASE_ASSERT(IsGPUPipelineLayout(), "Wrong type!");
    return mValue.mGPUPipelineLayout.Value();
  }

  inline GPUAutoLayoutMode&
  RawSetAsGPUAutoLayoutMode()
  {
    if (mType == eGPUAutoLayoutMode) {
      return mValue.mGPUAutoLayoutMode.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUAutoLayoutMode;
    return mValue.mGPUAutoLayoutMode.SetValue();
  }

  inline GPUAutoLayoutMode&
  SetAsGPUAutoLayoutMode()
  {
    if (mType == eGPUAutoLayoutMode) {
      return mValue.mGPUAutoLayoutMode.Value();
    }
    Uninit();
    mType = eGPUAutoLayoutMode;
    return mValue.mGPUAutoLayoutMode.SetValue();
  }

  inline bool
  IsGPUAutoLayoutMode() const
  {
    return mType == eGPUAutoLayoutMode;
  }

  inline GPUAutoLayoutMode&
  GetAsGPUAutoLayoutMode()
  {
    MOZ_RELEASE_ASSERT(IsGPUAutoLayoutMode(), "Wrong type!");
    return mValue.mGPUAutoLayoutMode.Value();
  }

  inline GPUAutoLayoutMode
  GetAsGPUAutoLayoutMode() const
  {
    MOZ_RELEASE_ASSERT(IsGPUAutoLayoutMode(), "Wrong type!");
    return mValue.mGPUAutoLayoutMode.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eGPUPipelineLayout: {
        DestroyGPUPipelineLayout();
        break;
      }
      case eGPUAutoLayoutMode: {
        DestroyGPUAutoLayoutMode();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToGPUPipelineLayout(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUPipelineLayout(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUPipelineLayout()
  {
    MOZ_RELEASE_ASSERT(IsGPUPipelineLayout(), "Wrong type!");
    mValue.mGPUPipelineLayout.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUAutoLayoutMode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUAutoLayoutMode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUAutoLayoutMode()
  {
    MOZ_RELEASE_ASSERT(IsGPUAutoLayoutMode(), "Wrong type!");
    mValue.mGPUAutoLayoutMode.Destroy();
    mType = eUninitialized;
  }
};


class OwningGPUPipelineLayoutOrGPUAutoLayoutMode : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningGPUPipelineLayoutOrGPUAutoLayoutMode& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eGPUPipelineLayout,
    eGPUAutoLayoutMode
  };
public:
  enum class Type
  {
    eGPUPipelineLayout = TypeOrUninit::eGPUPipelineLayout,
    eGPUAutoLayoutMode = TypeOrUninit::eGPUAutoLayoutMode
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::webgpu::PipelineLayout> > mGPUPipelineLayout;
    UnionMember<GPUAutoLayoutMode > mGPUAutoLayoutMode;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningGPUPipelineLayoutOrGPUAutoLayoutMode()
    : mType(eUninitialized)
  {
  }

  OwningGPUPipelineLayoutOrGPUAutoLayoutMode(OwningGPUPipelineLayoutOrGPUAutoLayoutMode&& aOther);

  explicit inline OwningGPUPipelineLayoutOrGPUAutoLayoutMode(const OwningGPUPipelineLayoutOrGPUAutoLayoutMode& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningGPUPipelineLayoutOrGPUAutoLayoutMode()
  {
    Uninit();
  }

  OwningNonNull<mozilla::webgpu::PipelineLayout>&
  RawSetAsGPUPipelineLayout();

  OwningNonNull<mozilla::webgpu::PipelineLayout>&
  SetAsGPUPipelineLayout();

  inline bool
  IsGPUPipelineLayout() const
  {
    return mType == eGPUPipelineLayout;
  }

  inline OwningNonNull<mozilla::webgpu::PipelineLayout>&
  GetAsGPUPipelineLayout()
  {
    MOZ_RELEASE_ASSERT(IsGPUPipelineLayout(), "Wrong type!");
    return mValue.mGPUPipelineLayout.Value();
  }

  inline OwningNonNull<mozilla::webgpu::PipelineLayout> const &
  GetAsGPUPipelineLayout() const
  {
    MOZ_RELEASE_ASSERT(IsGPUPipelineLayout(), "Wrong type!");
    return mValue.mGPUPipelineLayout.Value();
  }

  GPUAutoLayoutMode&
  RawSetAsGPUAutoLayoutMode();

  GPUAutoLayoutMode&
  SetAsGPUAutoLayoutMode();

  inline bool
  IsGPUAutoLayoutMode() const
  {
    return mType == eGPUAutoLayoutMode;
  }

  inline GPUAutoLayoutMode&
  GetAsGPUAutoLayoutMode()
  {
    MOZ_RELEASE_ASSERT(IsGPUAutoLayoutMode(), "Wrong type!");
    return mValue.mGPUAutoLayoutMode.Value();
  }

  inline GPUAutoLayoutMode const &
  GetAsGPUAutoLayoutMode() const
  {
    MOZ_RELEASE_ASSERT(IsGPUAutoLayoutMode(), "Wrong type!");
    return mValue.mGPUAutoLayoutMode.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningGPUPipelineLayoutOrGPUAutoLayoutMode&
  operator=(OwningGPUPipelineLayoutOrGPUAutoLayoutMode&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningGPUPipelineLayoutOrGPUAutoLayoutMode&
  operator=(const OwningGPUPipelineLayoutOrGPUAutoLayoutMode& aOther);

private:
  bool
  TrySetToGPUPipelineLayout(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUPipelineLayout(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUPipelineLayout();

  bool
  TrySetToGPUAutoLayoutMode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUAutoLayoutMode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUAutoLayoutMode();
};


struct GPUPrimitiveState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mClampDepth;
  MOZ_INIT_OUTSIDE_CTOR GPUCullMode mCullMode;
  MOZ_INIT_OUTSIDE_CTOR GPUFrontFace mFrontFace;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUIndexFormat> mStripIndexFormat;
  MOZ_INIT_OUTSIDE_CTOR GPUPrimitiveTopology mTopology;

  GPUPrimitiveState();

  explicit inline GPUPrimitiveState(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUPrimitiveState(GPUPrimitiveState&& aOther) = default;

  explicit inline GPUPrimitiveState(const GPUPrimitiveState& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUPrimitiveState&
  operator=(const GPUPrimitiveState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUPrimitiveStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUPrimitiveState : public GPUPrimitiveState
{
  inline FastGPUPrimitiveState()
    : GPUPrimitiveState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUProgrammableStage : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mEntryPoint;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::ShaderModule> mModule;

  GPUProgrammableStage();

  explicit inline GPUProgrammableStage(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUProgrammableStage(GPUProgrammableStage&& aOther) = default;

  explicit inline GPUProgrammableStage(const GPUProgrammableStage& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mModule, "mModule", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mModule);
  }

  GPUProgrammableStage&
  operator=(const GPUProgrammableStage& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUProgrammableStageAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUProgrammableStage : public GPUProgrammableStage
{
  inline FastGPUProgrammableStage()
    : GPUProgrammableStage(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassDepthStencilAttachment : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<float> mDepthClearValue;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPULoadOp> mDepthLoadOp;
  MOZ_INIT_OUTSIDE_CTOR bool mDepthReadOnly;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUStoreOp> mDepthStoreOp;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStencilClearValue;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPULoadOp> mStencilLoadOp;
  MOZ_INIT_OUTSIDE_CTOR bool mStencilReadOnly;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUStoreOp> mStencilStoreOp;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::TextureView> mView;

  GPURenderPassDepthStencilAttachment();

  explicit inline GPURenderPassDepthStencilAttachment(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPassDepthStencilAttachment(GPURenderPassDepthStencilAttachment&& aOther) = default;

  explicit inline GPURenderPassDepthStencilAttachment(const GPURenderPassDepthStencilAttachment& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mView, "mView", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mView);
  }

  GPURenderPassDepthStencilAttachment&
  operator=(const GPURenderPassDepthStencilAttachment& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassDepthStencilAttachmentAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassDepthStencilAttachment : public GPURenderPassDepthStencilAttachment
{
  inline FastGPURenderPassDepthStencilAttachment()
    : GPURenderPassDepthStencilAttachment(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURequestAdapterOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mForceFallbackAdapter;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUPowerPreference> mPowerPreference;

  GPURequestAdapterOptions();

  explicit inline GPURequestAdapterOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURequestAdapterOptions(GPURequestAdapterOptions&& aOther) = default;

  explicit inline GPURequestAdapterOptions(const GPURequestAdapterOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURequestAdapterOptions&
  operator=(const GPURequestAdapterOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURequestAdapterOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURequestAdapterOptions : public GPURequestAdapterOptions
{
  inline FastGPURequestAdapterOptions()
    : GPURequestAdapterOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUSamplerBindingLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUSamplerBindingType mType;

  GPUSamplerBindingLayout();

  explicit inline GPUSamplerBindingLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUSamplerBindingLayout(GPUSamplerBindingLayout&& aOther) = default;

  explicit inline GPUSamplerBindingLayout(const GPUSamplerBindingLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUSamplerBindingLayout&
  operator=(const GPUSamplerBindingLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUSamplerBindingLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUSamplerBindingLayout : public GPUSamplerBindingLayout
{
  inline FastGPUSamplerBindingLayout()
    : GPUSamplerBindingLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUStencilFaceState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUCompareFunction mCompare;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilOperation mDepthFailOp;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilOperation mFailOp;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilOperation mPassOp;

  GPUStencilFaceState();

  explicit inline GPUStencilFaceState(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUStencilFaceState(GPUStencilFaceState&& aOther) = default;

  explicit inline GPUStencilFaceState(const GPUStencilFaceState& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUStencilFaceState&
  operator=(const GPUStencilFaceState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUStencilFaceStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUStencilFaceState : public GPUStencilFaceState
{
  inline FastGPUStencilFaceState()
    : GPUStencilFaceState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUStorageTextureBindingLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUStorageTextureAccess mAccess;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureViewDimension mViewDimension;

  GPUStorageTextureBindingLayout();

  explicit inline GPUStorageTextureBindingLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUStorageTextureBindingLayout(GPUStorageTextureBindingLayout&& aOther) = default;

  explicit inline GPUStorageTextureBindingLayout(const GPUStorageTextureBindingLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUStorageTextureBindingLayout&
  operator=(const GPUStorageTextureBindingLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUStorageTextureBindingLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUStorageTextureBindingLayout : public GPUStorageTextureBindingLayout
{
  inline FastGPUStorageTextureBindingLayout()
    : GPUStorageTextureBindingLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTextureBindingLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mMultisampled;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureSampleType mSampleType;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureViewDimension mViewDimension;

  GPUTextureBindingLayout();

  explicit inline GPUTextureBindingLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUTextureBindingLayout(GPUTextureBindingLayout&& aOther) = default;

  explicit inline GPUTextureBindingLayout(const GPUTextureBindingLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUTextureBindingLayout&
  operator=(const GPUTextureBindingLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTextureBindingLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTextureBindingLayout : public GPUTextureBindingLayout
{
  inline FastGPUTextureBindingLayout()
    : GPUTextureBindingLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUVertexAttribute : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUVertexFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mShaderLocation;

  GPUVertexAttribute();

  explicit inline GPUVertexAttribute(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUVertexAttribute(GPUVertexAttribute&& aOther) = default;

  explicit inline GPUVertexAttribute(const GPUVertexAttribute& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUVertexAttribute&
  operator=(const GPUVertexAttribute& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUVertexAttributeAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUVertexAttribute : public GPUVertexAttribute
{
  inline FastGPUVertexAttribute()
    : GPUVertexAttribute(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ImageBitmapOrHTMLCanvasElementOrOffscreenCanvas
{
  enum TypeOrUninit
  {
    eUninitialized,
    eImageBitmap,
    eHTMLCanvasElement,
    eOffscreenCanvas
  };
public:
  enum class Type
  {
    eImageBitmap = TypeOrUninit::eImageBitmap,
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::ImageBitmap> > mImageBitmap;
    UnionMember<NonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<NonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;

  };

  TypeOrUninit mType;
  Value mValue;

  ImageBitmapOrHTMLCanvasElementOrOffscreenCanvas(const ImageBitmapOrHTMLCanvasElementOrOffscreenCanvas&) = delete;
  ImageBitmapOrHTMLCanvasElementOrOffscreenCanvas& operator=(const ImageBitmapOrHTMLCanvasElementOrOffscreenCanvas&) = delete;
public:
  explicit inline ImageBitmapOrHTMLCanvasElementOrOffscreenCanvas()
    : mType(eUninitialized)
  {
  }

  inline ~ImageBitmapOrHTMLCanvasElementOrOffscreenCanvas()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    Uninit();
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline mozilla::dom::ImageBitmap&
  GetAsImageBitmap() const
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    Uninit();
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline mozilla::dom::HTMLCanvasElement&
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    Uninit();
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline mozilla::dom::OffscreenCanvas&
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eImageBitmap: {
        DestroyImageBitmap();
        break;
      }
      case eHTMLCanvasElement: {
        DestroyHTMLCanvasElement();
        break;
      }
      case eOffscreenCanvas: {
        DestroyOffscreenCanvas();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    mValue.mImageBitmap.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    mValue.mHTMLCanvasElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    mValue.mOffscreenCanvas.Destroy();
    mType = eUninitialized;
  }
};


class OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eImageBitmap,
    eHTMLCanvasElement,
    eOffscreenCanvas
  };
public:
  enum class Type
  {
    eImageBitmap = TypeOrUninit::eImageBitmap,
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::ImageBitmap> > mImageBitmap;
    UnionMember<OwningNonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<OwningNonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas()
    : mType(eUninitialized)
  {
  }

  OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas(OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas&& aOther);

  explicit inline OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas(const OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap();

  OwningNonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap();

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap> const &
  GetAsImageBitmap() const
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement();

  OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement();

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement> const &
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  OwningNonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas();

  OwningNonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas();

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas> const &
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas&
  operator=(OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas&
  operator=(const OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas& aOther);

private:
  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageBitmap();

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLCanvasElement();

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyOffscreenCanvas();
};


class DoubleSequenceOrGPUColorDict
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDoubleSequence,
    eGPUColorDict
  };
public:
  enum class Type
  {
    eDoubleSequence = TypeOrUninit::eDoubleSequence,
    eGPUColorDict = TypeOrUninit::eGPUColorDict
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<double> > mDoubleSequence;
    UnionMember<binding_detail::FastGPUColorDict > mGPUColorDict;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleSequenceOrGPUColorDict(const DoubleSequenceOrGPUColorDict&) = delete;
  DoubleSequenceOrGPUColorDict& operator=(const DoubleSequenceOrGPUColorDict&) = delete;
public:
  explicit inline DoubleSequenceOrGPUColorDict()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleSequenceOrGPUColorDict()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<double>&
  RawSetAsDoubleSequence()
  {
    if (mType == eDoubleSequence) {
      return mValue.mDoubleSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDoubleSequence;
    return mValue.mDoubleSequence.SetValue();
  }

  inline binding_detail::AutoSequence<double>&
  SetAsDoubleSequence()
  {
    if (mType == eDoubleSequence) {
      return mValue.mDoubleSequence.Value();
    }
    Uninit();
    mType = eDoubleSequence;
    return mValue.mDoubleSequence.SetValue();
  }

  inline bool
  IsDoubleSequence() const
  {
    return mType == eDoubleSequence;
  }

  inline binding_detail::AutoSequence<double>&
  GetAsDoubleSequence()
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline const Sequence<double>&
  GetAsDoubleSequence() const
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline binding_detail::FastGPUColorDict&
  RawSetAsGPUColorDict()
  {
    if (mType == eGPUColorDict) {
      return mValue.mGPUColorDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUColorDict;
    return mValue.mGPUColorDict.SetValue();
  }

  inline binding_detail::FastGPUColorDict&
  SetAsGPUColorDict()
  {
    if (mType == eGPUColorDict) {
      return mValue.mGPUColorDict.Value();
    }
    Uninit();
    mType = eGPUColorDict;
    return mValue.mGPUColorDict.SetValue();
  }

  inline bool
  IsGPUColorDict() const
  {
    return mType == eGPUColorDict;
  }

  inline binding_detail::FastGPUColorDict&
  GetAsGPUColorDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  inline const GPUColorDict&
  GetAsGPUColorDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDoubleSequence: {
        DestroyDoubleSequence();
        break;
      }
      case eGPUColorDict: {
        DestroyGPUColorDict();
        break;
      }
    }
  }

private:
  bool
  TrySetToDoubleSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDoubleSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDoubleSequence()
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    mValue.mDoubleSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUColorDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUColorDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUColorDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUColorDict(), "Wrong type!");
    mValue.mGPUColorDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningDoubleSequenceOrGPUColorDict : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDoubleSequence,
    eGPUColorDict
  };
public:
  enum class Type
  {
    eDoubleSequence = TypeOrUninit::eDoubleSequence,
    eGPUColorDict = TypeOrUninit::eGPUColorDict
  };

private:
  union Value
  {
    UnionMember<Sequence<double> > mDoubleSequence;
    UnionMember<GPUColorDict > mGPUColorDict;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleSequenceOrGPUColorDict()
    : mType(eUninitialized)
  {
  }

  OwningDoubleSequenceOrGPUColorDict(OwningDoubleSequenceOrGPUColorDict&& aOther);

  explicit inline OwningDoubleSequenceOrGPUColorDict(const OwningDoubleSequenceOrGPUColorDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleSequenceOrGPUColorDict()
  {
    Uninit();
  }

  Sequence<double>&
  RawSetAsDoubleSequence();

  Sequence<double>&
  SetAsDoubleSequence();

  inline bool
  IsDoubleSequence() const
  {
    return mType == eDoubleSequence;
  }

  inline Sequence<double>&
  GetAsDoubleSequence()
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline Sequence<double> const &
  GetAsDoubleSequence() const
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  GPUColorDict&
  RawSetAsGPUColorDict();

  GPUColorDict&
  SetAsGPUColorDict();

  inline bool
  IsGPUColorDict() const
  {
    return mType == eGPUColorDict;
  }

  inline GPUColorDict&
  GetAsGPUColorDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  inline GPUColorDict const &
  GetAsGPUColorDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningDoubleSequenceOrGPUColorDict&
  operator=(OwningDoubleSequenceOrGPUColorDict&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleSequenceOrGPUColorDict&
  operator=(const OwningDoubleSequenceOrGPUColorDict& aOther);

private:
  bool
  TrySetToDoubleSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDoubleSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDoubleSequence();

  bool
  TrySetToGPUColorDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUColorDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUColorDict();
};


struct GPUBindGroupLayoutEntry : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBinding;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUBufferBindingLayout> mBuffer;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUSamplerBindingLayout> mSampler;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUStorageTextureBindingLayout> mStorageTexture;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureBindingLayout> mTexture;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mVisibility;

  GPUBindGroupLayoutEntry();

  explicit inline GPUBindGroupLayoutEntry(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBindGroupLayoutEntry(GPUBindGroupLayoutEntry&& aOther) = default;

  explicit inline GPUBindGroupLayoutEntry(const GPUBindGroupLayoutEntry& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBindGroupLayoutEntry&
  operator=(const GPUBindGroupLayoutEntry& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupLayoutEntryAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupLayoutEntry : public GPUBindGroupLayoutEntry
{
  inline FastGPUBindGroupLayoutEntry()
    : GPUBindGroupLayoutEntry(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBlendState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUBlendComponent mAlpha;
  MOZ_INIT_OUTSIDE_CTOR GPUBlendComponent mColor;

  GPUBlendState();

  explicit inline GPUBlendState(const FastDictionaryInitializer& )
    : mAlpha(FastDictionaryInitializer()),
      mColor(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBlendState(GPUBlendState&& aOther) = default;

  explicit inline GPUBlendState(const GPUBlendState& aOther)
    : mAlpha(FastDictionaryInitializer()),
      mColor(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBlendState&
  operator=(const GPUBlendState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBlendStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBlendState : public GPUBlendState
{
  inline FastGPUBlendState()
    : GPUBlendState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBufferDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mMappedAtCreation;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mSize;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUsage;

  GPUBufferDescriptor();

  explicit inline GPUBufferDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBufferDescriptor(GPUBufferDescriptor&& aOther) = default;

  explicit inline GPUBufferDescriptor(const GPUBufferDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBufferDescriptor&
  operator=(const GPUBufferDescriptor& aOther);

  bool
  operator==(const GPUBufferDescriptor& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUBufferDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBufferDescriptor : public GPUBufferDescriptor
{
  inline FastGPUBufferDescriptor()
    : GPUBufferDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUCommandBufferDescriptor : public GPUObjectDescriptorBase
{
  GPUCommandBufferDescriptor();

  explicit inline GPUCommandBufferDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUCommandBufferDescriptor(GPUCommandBufferDescriptor&& aOther) = default;

  explicit inline GPUCommandBufferDescriptor(const GPUCommandBufferDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUCommandBufferDescriptor&
  operator=(const GPUCommandBufferDescriptor& aOther);

  bool
  operator==(const GPUCommandBufferDescriptor& aOther) const;
};

namespace binding_detail {
struct FastGPUCommandBufferDescriptor : public GPUCommandBufferDescriptor
{
  inline FastGPUCommandBufferDescriptor()
    : GPUCommandBufferDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUCommandEncoderDescriptor : public GPUObjectDescriptorBase
{
  GPUCommandEncoderDescriptor();

  explicit inline GPUCommandEncoderDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUCommandEncoderDescriptor(GPUCommandEncoderDescriptor&& aOther) = default;

  explicit inline GPUCommandEncoderDescriptor(const GPUCommandEncoderDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUCommandEncoderDescriptor&
  operator=(const GPUCommandEncoderDescriptor& aOther);

  bool
  operator==(const GPUCommandEncoderDescriptor& aOther) const;
};

namespace binding_detail {
struct FastGPUCommandEncoderDescriptor : public GPUCommandEncoderDescriptor
{
  inline FastGPUCommandEncoderDescriptor()
    : GPUCommandEncoderDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUComputePassDescriptor : public GPUObjectDescriptorBase
{
  GPUComputePassDescriptor();

  explicit inline GPUComputePassDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUComputePassDescriptor(GPUComputePassDescriptor&& aOther) = default;

  explicit inline GPUComputePassDescriptor(const GPUComputePassDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUComputePassDescriptor&
  operator=(const GPUComputePassDescriptor& aOther);

  bool
  operator==(const GPUComputePassDescriptor& aOther) const;
};

namespace binding_detail {
struct FastGPUComputePassDescriptor : public GPUComputePassDescriptor
{
  inline FastGPUComputePassDescriptor()
    : GPUComputePassDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUDepthStencilState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR int32_t mDepthBias;
  MOZ_INIT_OUTSIDE_CTOR float mDepthBiasClamp;
  MOZ_INIT_OUTSIDE_CTOR float mDepthBiasSlopeScale;
  MOZ_INIT_OUTSIDE_CTOR GPUCompareFunction mDepthCompare;
  MOZ_INIT_OUTSIDE_CTOR bool mDepthWriteEnabled;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilFaceState mStencilBack;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilFaceState mStencilFront;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStencilReadMask;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStencilWriteMask;

  GPUDepthStencilState();

  explicit inline GPUDepthStencilState(const FastDictionaryInitializer& )
    : mStencilBack(FastDictionaryInitializer()),
      mStencilFront(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUDepthStencilState(GPUDepthStencilState&& aOther) = default;

  explicit inline GPUDepthStencilState(const GPUDepthStencilState& aOther)
    : mStencilBack(FastDictionaryInitializer()),
      mStencilFront(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUDepthStencilState&
  operator=(const GPUDepthStencilState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUDepthStencilStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUDepthStencilState : public GPUDepthStencilState
{
  inline FastGPUDepthStencilState()
    : GPUDepthStencilState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUImageCopyBuffer : public GPUImageDataLayout
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Buffer> mBuffer;

  GPUImageCopyBuffer();

  explicit inline GPUImageCopyBuffer(const FastDictionaryInitializer& )
    : GPUImageDataLayout(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUImageCopyBuffer(GPUImageCopyBuffer&& aOther) = default;

  explicit inline GPUImageCopyBuffer(const GPUImageCopyBuffer& aOther)
    : GPUImageDataLayout(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBuffer, "mBuffer", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBuffer);
  }

  GPUImageCopyBuffer&
  operator=(const GPUImageCopyBuffer& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUImageCopyBufferAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUImageCopyBuffer : public GPUImageCopyBuffer
{
  inline FastGPUImageCopyBuffer()
    : GPUImageCopyBuffer(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUPipelineDescriptorBase : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningGPUPipelineLayoutOrGPUAutoLayoutMode mLayout;

  GPUPipelineDescriptorBase();

  explicit inline GPUPipelineDescriptorBase(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUPipelineDescriptorBase(GPUPipelineDescriptorBase&& aOther) = default;

  explicit inline GPUPipelineDescriptorBase(const GPUPipelineDescriptorBase& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mLayout, "mLayout", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mLayout);
  }

  GPUPipelineDescriptorBase&
  operator=(const GPUPipelineDescriptorBase& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUPipelineDescriptorBaseAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUPipelineDescriptorBase : public GPUPipelineDescriptorBase
{
  inline FastGPUPipelineDescriptorBase()
    : GPUPipelineDescriptorBase(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUPipelineLayoutDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<OwningNonNull<mozilla::webgpu::BindGroupLayout>> mBindGroupLayouts;

  GPUPipelineLayoutDescriptor();

  explicit inline GPUPipelineLayoutDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUPipelineLayoutDescriptor(GPUPipelineLayoutDescriptor&& aOther) = default;

  explicit inline GPUPipelineLayoutDescriptor(const GPUPipelineLayoutDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBindGroupLayouts, "mBindGroupLayouts", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBindGroupLayouts);
  }

  GPUPipelineLayoutDescriptor&
  operator=(const GPUPipelineLayoutDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUPipelineLayoutDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUPipelineLayoutDescriptor : public GPUPipelineLayoutDescriptor
{
  inline FastGPUPipelineLayoutDescriptor()
    : GPUPipelineLayoutDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUQuerySetDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mCount;
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUPipelineStatisticName> mPipelineStatistics;
  MOZ_INIT_OUTSIDE_CTOR GPUQueryType mType;

  GPUQuerySetDescriptor();

  explicit inline GPUQuerySetDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUQuerySetDescriptor(GPUQuerySetDescriptor&& aOther) = default;

  explicit inline GPUQuerySetDescriptor(const GPUQuerySetDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUQuerySetDescriptor&
  operator=(const GPUQuerySetDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUQuerySetDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUQuerySetDescriptor : public GPUQuerySetDescriptor
{
  inline FastGPUQuerySetDescriptor()
    : GPUQuerySetDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderBundleDescriptor : public GPUObjectDescriptorBase
{
  GPURenderBundleDescriptor();

  explicit inline GPURenderBundleDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderBundleDescriptor(GPURenderBundleDescriptor&& aOther) = default;

  explicit inline GPURenderBundleDescriptor(const GPURenderBundleDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURenderBundleDescriptor&
  operator=(const GPURenderBundleDescriptor& aOther);

  bool
  operator==(const GPURenderBundleDescriptor& aOther) const;
};

namespace binding_detail {
struct FastGPURenderBundleDescriptor : public GPURenderBundleDescriptor
{
  inline FastGPURenderBundleDescriptor()
    : GPURenderBundleDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassLayout : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUTextureFormat> mColorFormats;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureFormat> mDepthStencilFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSampleCount;

  GPURenderPassLayout();

  explicit inline GPURenderPassLayout(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPassLayout(GPURenderPassLayout&& aOther) = default;

  explicit inline GPURenderPassLayout(const GPURenderPassLayout& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURenderPassLayout&
  operator=(const GPURenderPassLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassLayout : public GPURenderPassLayout
{
  inline FastGPURenderPassLayout()
    : GPURenderPassLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUSamplerDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUAddressMode mAddressModeU;
  MOZ_INIT_OUTSIDE_CTOR GPUAddressMode mAddressModeV;
  MOZ_INIT_OUTSIDE_CTOR GPUAddressMode mAddressModeW;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUCompareFunction> mCompare;
  MOZ_INIT_OUTSIDE_CTOR float mLodMaxClamp;
  MOZ_INIT_OUTSIDE_CTOR float mLodMinClamp;
  MOZ_INIT_OUTSIDE_CTOR GPUFilterMode mMagFilter;
  MOZ_INIT_OUTSIDE_CTOR uint16_t mMaxAnisotropy;
  MOZ_INIT_OUTSIDE_CTOR GPUFilterMode mMinFilter;
  MOZ_INIT_OUTSIDE_CTOR GPUFilterMode mMipmapFilter;

  GPUSamplerDescriptor();

  explicit inline GPUSamplerDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUSamplerDescriptor(GPUSamplerDescriptor&& aOther) = default;

  explicit inline GPUSamplerDescriptor(const GPUSamplerDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUSamplerDescriptor&
  operator=(const GPUSamplerDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUSamplerDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUSamplerDescriptor : public GPUSamplerDescriptor
{
  inline FastGPUSamplerDescriptor()
    : GPUSamplerDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class GPUSamplerOrGPUTextureViewOrGPUBufferBinding
{
  enum TypeOrUninit
  {
    eUninitialized,
    eGPUSampler,
    eGPUTextureView,
    eGPUBufferBinding
  };
public:
  enum class Type
  {
    eGPUSampler = TypeOrUninit::eGPUSampler,
    eGPUTextureView = TypeOrUninit::eGPUTextureView,
    eGPUBufferBinding = TypeOrUninit::eGPUBufferBinding
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::webgpu::Sampler> > mGPUSampler;
    UnionMember<NonNull<mozilla::webgpu::TextureView> > mGPUTextureView;
    UnionMember<binding_detail::FastGPUBufferBinding > mGPUBufferBinding;

  };

  TypeOrUninit mType;
  Value mValue;

  GPUSamplerOrGPUTextureViewOrGPUBufferBinding(const GPUSamplerOrGPUTextureViewOrGPUBufferBinding&) = delete;
  GPUSamplerOrGPUTextureViewOrGPUBufferBinding& operator=(const GPUSamplerOrGPUTextureViewOrGPUBufferBinding&) = delete;
public:
  explicit inline GPUSamplerOrGPUTextureViewOrGPUBufferBinding()
    : mType(eUninitialized)
  {
  }

  inline ~GPUSamplerOrGPUTextureViewOrGPUBufferBinding()
  {
    Uninit();
  }

  inline NonNull<mozilla::webgpu::Sampler>&
  RawSetAsGPUSampler()
  {
    if (mType == eGPUSampler) {
      return mValue.mGPUSampler.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUSampler;
    return mValue.mGPUSampler.SetValue();
  }

  inline NonNull<mozilla::webgpu::Sampler>&
  SetAsGPUSampler()
  {
    if (mType == eGPUSampler) {
      return mValue.mGPUSampler.Value();
    }
    Uninit();
    mType = eGPUSampler;
    return mValue.mGPUSampler.SetValue();
  }

  inline bool
  IsGPUSampler() const
  {
    return mType == eGPUSampler;
  }

  inline NonNull<mozilla::webgpu::Sampler>&
  GetAsGPUSampler()
  {
    MOZ_RELEASE_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  inline mozilla::webgpu::Sampler&
  GetAsGPUSampler() const
  {
    MOZ_RELEASE_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  inline NonNull<mozilla::webgpu::TextureView>&
  RawSetAsGPUTextureView()
  {
    if (mType == eGPUTextureView) {
      return mValue.mGPUTextureView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUTextureView;
    return mValue.mGPUTextureView.SetValue();
  }

  inline NonNull<mozilla::webgpu::TextureView>&
  SetAsGPUTextureView()
  {
    if (mType == eGPUTextureView) {
      return mValue.mGPUTextureView.Value();
    }
    Uninit();
    mType = eGPUTextureView;
    return mValue.mGPUTextureView.SetValue();
  }

  inline bool
  IsGPUTextureView() const
  {
    return mType == eGPUTextureView;
  }

  inline NonNull<mozilla::webgpu::TextureView>&
  GetAsGPUTextureView()
  {
    MOZ_RELEASE_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  inline mozilla::webgpu::TextureView&
  GetAsGPUTextureView() const
  {
    MOZ_RELEASE_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  inline binding_detail::FastGPUBufferBinding&
  RawSetAsGPUBufferBinding()
  {
    if (mType == eGPUBufferBinding) {
      return mValue.mGPUBufferBinding.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUBufferBinding;
    return mValue.mGPUBufferBinding.SetValue();
  }

  inline binding_detail::FastGPUBufferBinding&
  SetAsGPUBufferBinding()
  {
    if (mType == eGPUBufferBinding) {
      return mValue.mGPUBufferBinding.Value();
    }
    Uninit();
    mType = eGPUBufferBinding;
    return mValue.mGPUBufferBinding.SetValue();
  }

  inline bool
  IsGPUBufferBinding() const
  {
    return mType == eGPUBufferBinding;
  }

  inline binding_detail::FastGPUBufferBinding&
  GetAsGPUBufferBinding()
  {
    MOZ_RELEASE_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  inline const GPUBufferBinding&
  GetAsGPUBufferBinding() const
  {
    MOZ_RELEASE_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eGPUSampler: {
        DestroyGPUSampler();
        break;
      }
      case eGPUTextureView: {
        DestroyGPUTextureView();
        break;
      }
      case eGPUBufferBinding: {
        DestroyGPUBufferBinding();
        break;
      }
    }
  }

private:
  bool
  TrySetToGPUSampler(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUSampler(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUSampler()
  {
    MOZ_RELEASE_ASSERT(IsGPUSampler(), "Wrong type!");
    mValue.mGPUSampler.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUTextureView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUTextureView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUTextureView()
  {
    MOZ_RELEASE_ASSERT(IsGPUTextureView(), "Wrong type!");
    mValue.mGPUTextureView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUBufferBinding(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUBufferBinding(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUBufferBinding()
  {
    MOZ_RELEASE_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    mValue.mGPUBufferBinding.Destroy();
    mType = eUninitialized;
  }
};


class OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eGPUSampler,
    eGPUTextureView,
    eGPUBufferBinding
  };
public:
  enum class Type
  {
    eGPUSampler = TypeOrUninit::eGPUSampler,
    eGPUTextureView = TypeOrUninit::eGPUTextureView,
    eGPUBufferBinding = TypeOrUninit::eGPUBufferBinding
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::webgpu::Sampler> > mGPUSampler;
    UnionMember<OwningNonNull<mozilla::webgpu::TextureView> > mGPUTextureView;
    UnionMember<GPUBufferBinding > mGPUBufferBinding;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding()
    : mType(eUninitialized)
  {
  }

  OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding(OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding&& aOther);

  explicit inline OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding(const OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding()
  {
    Uninit();
  }

  OwningNonNull<mozilla::webgpu::Sampler>&
  RawSetAsGPUSampler();

  OwningNonNull<mozilla::webgpu::Sampler>&
  SetAsGPUSampler();

  inline bool
  IsGPUSampler() const
  {
    return mType == eGPUSampler;
  }

  inline OwningNonNull<mozilla::webgpu::Sampler>&
  GetAsGPUSampler()
  {
    MOZ_RELEASE_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  inline OwningNonNull<mozilla::webgpu::Sampler> const &
  GetAsGPUSampler() const
  {
    MOZ_RELEASE_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  OwningNonNull<mozilla::webgpu::TextureView>&
  RawSetAsGPUTextureView();

  OwningNonNull<mozilla::webgpu::TextureView>&
  SetAsGPUTextureView();

  inline bool
  IsGPUTextureView() const
  {
    return mType == eGPUTextureView;
  }

  inline OwningNonNull<mozilla::webgpu::TextureView>&
  GetAsGPUTextureView()
  {
    MOZ_RELEASE_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  inline OwningNonNull<mozilla::webgpu::TextureView> const &
  GetAsGPUTextureView() const
  {
    MOZ_RELEASE_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  GPUBufferBinding&
  RawSetAsGPUBufferBinding();

  GPUBufferBinding&
  SetAsGPUBufferBinding();

  inline bool
  IsGPUBufferBinding() const
  {
    return mType == eGPUBufferBinding;
  }

  inline GPUBufferBinding&
  GetAsGPUBufferBinding()
  {
    MOZ_RELEASE_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  inline GPUBufferBinding const &
  GetAsGPUBufferBinding() const
  {
    MOZ_RELEASE_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding&
  operator=(OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding&
  operator=(const OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aOther);

private:
  bool
  TrySetToGPUSampler(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUSampler(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUSampler();

  bool
  TrySetToGPUTextureView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUTextureView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUTextureView();

  bool
  TrySetToGPUBufferBinding(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUBufferBinding(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUBufferBinding();
};


struct GPUShaderModuleDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR nsCString mCode;
  MOZ_INIT_OUTSIDE_CTOR Optional<JSObject*> mSourceMap;

  GPUShaderModuleDescriptor();

  explicit inline GPUShaderModuleDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUShaderModuleDescriptor(GPUShaderModuleDescriptor&& aOther) = default;

private:
  GPUShaderModuleDescriptor(const GPUShaderModuleDescriptor&) = delete;
  GPUShaderModuleDescriptor& operator=(const GPUShaderModuleDescriptor&) = delete;

  static bool
  InitIds(JSContext* cx, GPUShaderModuleDescriptorAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastGPUShaderModuleDescriptor : public GPUShaderModuleDescriptor
{
  inline FastGPUShaderModuleDescriptor()
    : GPUShaderModuleDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTextureViewDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mArrayLayerCount;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureAspect mAspect;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBaseArrayLayer;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBaseMipLevel;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureViewDimension> mDimension;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureFormat> mFormat;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mMipLevelCount;

  GPUTextureViewDescriptor();

  explicit inline GPUTextureViewDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUTextureViewDescriptor(GPUTextureViewDescriptor&& aOther) = default;

  explicit inline GPUTextureViewDescriptor(const GPUTextureViewDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUTextureViewDescriptor&
  operator=(const GPUTextureViewDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTextureViewDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTextureViewDescriptor : public GPUTextureViewDescriptor
{
  inline FastGPUTextureViewDescriptor()
    : GPUTextureViewDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUVertexBufferLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mArrayStride;
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUVertexAttribute> mAttributes;
  MOZ_INIT_OUTSIDE_CTOR GPUVertexStepMode mStepMode;

  GPUVertexBufferLayout();

  explicit inline GPUVertexBufferLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUVertexBufferLayout(GPUVertexBufferLayout&& aOther) = default;

  explicit inline GPUVertexBufferLayout(const GPUVertexBufferLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUVertexBufferLayout&
  operator=(const GPUVertexBufferLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUVertexBufferLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUVertexBufferLayout : public GPUVertexBufferLayout
{
  inline FastGPUVertexBufferLayout()
    : GPUVertexBufferLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUExtent3DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUExtent3DDict = TypeOrUninit::eGPUExtent3DDict
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<binding_detail::FastGPUExtent3DDict > mGPUExtent3DDict;

  };

  TypeOrUninit mType;
  Value mValue;

  RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict(const RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&) = delete;
  RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict& operator=(const RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&) = delete;
public:
  explicit inline RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict()
    : mType(eUninitialized)
  {
  }

  inline ~RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    Uninit();
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline binding_detail::AutoSequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline const Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline binding_detail::FastGPUExtent3DDict&
  RawSetAsGPUExtent3DDict()
  {
    if (mType == eGPUExtent3DDict) {
      return mValue.mGPUExtent3DDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUExtent3DDict;
    return mValue.mGPUExtent3DDict.SetValue();
  }

  inline binding_detail::FastGPUExtent3DDict&
  SetAsGPUExtent3DDict()
  {
    if (mType == eGPUExtent3DDict) {
      return mValue.mGPUExtent3DDict.Value();
    }
    Uninit();
    mType = eGPUExtent3DDict;
    return mValue.mGPUExtent3DDict.SetValue();
  }

  inline bool
  IsGPUExtent3DDict() const
  {
    return mType == eGPUExtent3DDict;
  }

  inline binding_detail::FastGPUExtent3DDict&
  GetAsGPUExtent3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  inline const GPUExtent3DDict&
  GetAsGPUExtent3DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRangeEnforcedUnsignedLongSequence: {
        DestroyRangeEnforcedUnsignedLongSequence();
        break;
      }
      case eGPUExtent3DDict: {
        DestroyGPUExtent3DDict();
        break;
      }
    }
  }

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    mValue.mRangeEnforcedUnsignedLongSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUExtent3DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUExtent3DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUExtent3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    mValue.mGPUExtent3DDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUExtent3DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUExtent3DDict = TypeOrUninit::eGPUExtent3DDict
  };

private:
  union Value
  {
    UnionMember<Sequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<GPUExtent3DDict > mGPUExtent3DDict;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict()
    : mType(eUninitialized)
  {
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict(OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&& aOther);

  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict(const OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict()
  {
    Uninit();
  }

  Sequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence();

  Sequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence();

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline Sequence<uint32_t> const &
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  GPUExtent3DDict&
  RawSetAsGPUExtent3DDict();

  GPUExtent3DDict&
  SetAsGPUExtent3DDict();

  inline bool
  IsGPUExtent3DDict() const
  {
    return mType == eGPUExtent3DDict;
  }

  inline GPUExtent3DDict&
  GetAsGPUExtent3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  inline GPUExtent3DDict const &
  GetAsGPUExtent3DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&
  operator=(OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&
  operator=(const OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict& aOther);

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyRangeEnforcedUnsignedLongSequence();

  bool
  TrySetToGPUExtent3DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUExtent3DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUExtent3DDict();
};


class RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin2DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin2DDict = TypeOrUninit::eGPUOrigin2DDict
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<binding_detail::FastGPUOrigin2DDict > mGPUOrigin2DDict;

  };

  TypeOrUninit mType;
  Value mValue;

  RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict(const RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&) = delete;
  RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict& operator=(const RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&) = delete;
public:
  explicit inline RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict()
    : mType(eUninitialized)
  {
  }

  inline ~RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    Uninit();
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline binding_detail::AutoSequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline const Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline binding_detail::FastGPUOrigin2DDict&
  RawSetAsGPUOrigin2DDict()
  {
    if (mType == eGPUOrigin2DDict) {
      return mValue.mGPUOrigin2DDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUOrigin2DDict;
    return mValue.mGPUOrigin2DDict.SetValue();
  }

  inline binding_detail::FastGPUOrigin2DDict&
  SetAsGPUOrigin2DDict()
  {
    if (mType == eGPUOrigin2DDict) {
      return mValue.mGPUOrigin2DDict.Value();
    }
    Uninit();
    mType = eGPUOrigin2DDict;
    return mValue.mGPUOrigin2DDict.SetValue();
  }

  inline bool
  IsGPUOrigin2DDict() const
  {
    return mType == eGPUOrigin2DDict;
  }

  inline binding_detail::FastGPUOrigin2DDict&
  GetAsGPUOrigin2DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  inline const GPUOrigin2DDict&
  GetAsGPUOrigin2DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRangeEnforcedUnsignedLongSequence: {
        DestroyRangeEnforcedUnsignedLongSequence();
        break;
      }
      case eGPUOrigin2DDict: {
        DestroyGPUOrigin2DDict();
        break;
      }
    }
  }

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    mValue.mRangeEnforcedUnsignedLongSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUOrigin2DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOrigin2DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUOrigin2DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    mValue.mGPUOrigin2DDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin2DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin2DDict = TypeOrUninit::eGPUOrigin2DDict
  };

private:
  union Value
  {
    UnionMember<Sequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<GPUOrigin2DDict > mGPUOrigin2DDict;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict()
    : mType(eUninitialized)
  {
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict(OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&& aOther);

  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict(const OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict()
  {
    Uninit();
  }

  Sequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence();

  Sequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence();

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline Sequence<uint32_t> const &
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  GPUOrigin2DDict&
  RawSetAsGPUOrigin2DDict();

  GPUOrigin2DDict&
  SetAsGPUOrigin2DDict();

  inline bool
  IsGPUOrigin2DDict() const
  {
    return mType == eGPUOrigin2DDict;
  }

  inline GPUOrigin2DDict&
  GetAsGPUOrigin2DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  inline GPUOrigin2DDict const &
  GetAsGPUOrigin2DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&
  operator=(OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&
  operator=(const OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict& aOther);

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyRangeEnforcedUnsignedLongSequence();

  bool
  TrySetToGPUOrigin2DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOrigin2DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUOrigin2DDict();
};


class RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin3DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin3DDict = TypeOrUninit::eGPUOrigin3DDict
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<binding_detail::FastGPUOrigin3DDict > mGPUOrigin3DDict;

  };

  TypeOrUninit mType;
  Value mValue;

  RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict(const RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&) = delete;
  RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict& operator=(const RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&) = delete;
public:
  explicit inline RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict()
    : mType(eUninitialized)
  {
  }

  inline ~RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    Uninit();
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline binding_detail::AutoSequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline const Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline binding_detail::FastGPUOrigin3DDict&
  RawSetAsGPUOrigin3DDict()
  {
    if (mType == eGPUOrigin3DDict) {
      return mValue.mGPUOrigin3DDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUOrigin3DDict;
    return mValue.mGPUOrigin3DDict.SetValue();
  }

  inline binding_detail::FastGPUOrigin3DDict&
  SetAsGPUOrigin3DDict()
  {
    if (mType == eGPUOrigin3DDict) {
      return mValue.mGPUOrigin3DDict.Value();
    }
    Uninit();
    mType = eGPUOrigin3DDict;
    return mValue.mGPUOrigin3DDict.SetValue();
  }

  inline bool
  IsGPUOrigin3DDict() const
  {
    return mType == eGPUOrigin3DDict;
  }

  inline binding_detail::FastGPUOrigin3DDict&
  GetAsGPUOrigin3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  inline const GPUOrigin3DDict&
  GetAsGPUOrigin3DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRangeEnforcedUnsignedLongSequence: {
        DestroyRangeEnforcedUnsignedLongSequence();
        break;
      }
      case eGPUOrigin3DDict: {
        DestroyGPUOrigin3DDict();
        break;
      }
    }
  }

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    mValue.mRangeEnforcedUnsignedLongSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUOrigin3DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOrigin3DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUOrigin3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    mValue.mGPUOrigin3DDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin3DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin3DDict = TypeOrUninit::eGPUOrigin3DDict
  };

private:
  union Value
  {
    UnionMember<Sequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<GPUOrigin3DDict > mGPUOrigin3DDict;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict()
    : mType(eUninitialized)
  {
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict(OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&& aOther);

  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict(const OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict()
  {
    Uninit();
  }

  Sequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence();

  Sequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence();

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline Sequence<uint32_t> const &
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  GPUOrigin3DDict&
  RawSetAsGPUOrigin3DDict();

  GPUOrigin3DDict&
  SetAsGPUOrigin3DDict();

  inline bool
  IsGPUOrigin3DDict() const
  {
    return mType == eGPUOrigin3DDict;
  }

  inline GPUOrigin3DDict&
  GetAsGPUOrigin3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  inline GPUOrigin3DDict const &
  GetAsGPUOrigin3DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&
  operator=(OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&
  operator=(const OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict& aOther);

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyRangeEnforcedUnsignedLongSequence();

  bool
  TrySetToGPUOrigin3DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOrigin3DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUOrigin3DDict();
};


struct GPUBindGroupEntry : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBinding;
  MOZ_INIT_OUTSIDE_CTOR OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding mResource;

  GPUBindGroupEntry();

  explicit inline GPUBindGroupEntry(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBindGroupEntry(GPUBindGroupEntry&& aOther) = default;

  explicit inline GPUBindGroupEntry(const GPUBindGroupEntry& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mResource, "mResource", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mResource);
  }

  GPUBindGroupEntry&
  operator=(const GPUBindGroupEntry& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupEntryAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupEntry : public GPUBindGroupEntry
{
  inline FastGPUBindGroupEntry()
    : GPUBindGroupEntry(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBindGroupLayoutDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUBindGroupLayoutEntry> mEntries;

  GPUBindGroupLayoutDescriptor();

  explicit inline GPUBindGroupLayoutDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBindGroupLayoutDescriptor(GPUBindGroupLayoutDescriptor&& aOther) = default;

  explicit inline GPUBindGroupLayoutDescriptor(const GPUBindGroupLayoutDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBindGroupLayoutDescriptor&
  operator=(const GPUBindGroupLayoutDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupLayoutDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupLayoutDescriptor : public GPUBindGroupLayoutDescriptor
{
  inline FastGPUBindGroupLayoutDescriptor()
    : GPUBindGroupLayoutDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUColorTargetState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUBlendState> mBlend;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWriteMask;

  GPUColorTargetState();

  explicit inline GPUColorTargetState(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUColorTargetState(GPUColorTargetState&& aOther) = default;

  explicit inline GPUColorTargetState(const GPUColorTargetState& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUColorTargetState&
  operator=(const GPUColorTargetState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUColorTargetStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUColorTargetState : public GPUColorTargetState
{
  inline FastGPUColorTargetState()
    : GPUColorTargetState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUComputePipelineDescriptor : public GPUPipelineDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUProgrammableStage mCompute;

  GPUComputePipelineDescriptor();

  explicit inline GPUComputePipelineDescriptor(const FastDictionaryInitializer& )
    : GPUPipelineDescriptorBase(FastDictionaryInitializer()),
      mCompute(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUComputePipelineDescriptor(GPUComputePipelineDescriptor&& aOther) = default;

  explicit inline GPUComputePipelineDescriptor(const GPUComputePipelineDescriptor& aOther)
    : GPUPipelineDescriptorBase(FastDictionaryInitializer()),
      mCompute(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUPipelineDescriptorBase::TraverseForCC(aCallback, aFlags);
    ImplCycleCollectionTraverse(aCallback, mCompute, "mCompute", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUPipelineDescriptorBase::UnlinkForCC();
    ImplCycleCollectionUnlink(mCompute);
  }

  GPUComputePipelineDescriptor&
  operator=(const GPUComputePipelineDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUComputePipelineDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUComputePipelineDescriptor : public GPUComputePipelineDescriptor
{
  inline FastGPUComputePipelineDescriptor()
    : GPUComputePipelineDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUImageBitmapCopyView : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict> mOrigin;

  GPUImageBitmapCopyView();

  explicit inline GPUImageBitmapCopyView(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUImageBitmapCopyView(GPUImageBitmapCopyView&& aOther) = default;

  explicit inline GPUImageBitmapCopyView(const GPUImageBitmapCopyView& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUImageBitmapCopyView&
  operator=(const GPUImageBitmapCopyView& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUImageBitmapCopyViewAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUImageBitmapCopyView : public GPUImageBitmapCopyView
{
  inline FastGPUImageBitmapCopyView()
    : GPUImageBitmapCopyView(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUImageCopyExternalImage : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mFlipY;
  MOZ_INIT_OUTSIDE_CTOR OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict mOrigin;
  MOZ_INIT_OUTSIDE_CTOR OwningImageBitmapOrHTMLCanvasElementOrOffscreenCanvas mSource;

  GPUImageCopyExternalImage();

  explicit inline GPUImageCopyExternalImage(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUImageCopyExternalImage(GPUImageCopyExternalImage&& aOther) = default;

  explicit inline GPUImageCopyExternalImage(const GPUImageCopyExternalImage& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mSource, "mSource", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mSource);
  }

  GPUImageCopyExternalImage&
  operator=(const GPUImageCopyExternalImage& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUImageCopyExternalImageAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUImageCopyExternalImage : public GPUImageCopyExternalImage
{
  inline FastGPUImageCopyExternalImage()
    : GPUImageCopyExternalImage(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUImageCopyTexture : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUTextureAspect mAspect;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMipLevel;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict> mOrigin;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Texture> mTexture;

  GPUImageCopyTexture();

  explicit inline GPUImageCopyTexture(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUImageCopyTexture(GPUImageCopyTexture&& aOther) = default;

  explicit inline GPUImageCopyTexture(const GPUImageCopyTexture& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mTexture, "mTexture", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mTexture);
  }

  GPUImageCopyTexture&
  operator=(const GPUImageCopyTexture& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUImageCopyTextureAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUImageCopyTexture : public GPUImageCopyTexture
{
  inline FastGPUImageCopyTexture()
    : GPUImageCopyTexture(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderBundleEncoderDescriptor : public GPURenderPassLayout
{
  MOZ_INIT_OUTSIDE_CTOR bool mDepthReadOnly;
  MOZ_INIT_OUTSIDE_CTOR bool mStencilReadOnly;

  GPURenderBundleEncoderDescriptor();

  explicit inline GPURenderBundleEncoderDescriptor(const FastDictionaryInitializer& )
    : GPURenderPassLayout(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderBundleEncoderDescriptor(GPURenderBundleEncoderDescriptor&& aOther) = default;

  explicit inline GPURenderBundleEncoderDescriptor(const GPURenderBundleEncoderDescriptor& aOther)
    : GPURenderPassLayout(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURenderBundleEncoderDescriptor&
  operator=(const GPURenderBundleEncoderDescriptor& aOther);

  bool
  operator==(const GPURenderBundleEncoderDescriptor& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPURenderBundleEncoderDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderBundleEncoderDescriptor : public GPURenderBundleEncoderDescriptor
{
  inline FastGPURenderBundleEncoderDescriptor()
    : GPURenderBundleEncoderDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassColorAttachment : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningDoubleSequenceOrGPUColorDict> mClearValue;
  MOZ_INIT_OUTSIDE_CTOR GPULoadOp mLoadOp;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<mozilla::webgpu::TextureView>> mResolveTarget;
  MOZ_INIT_OUTSIDE_CTOR GPUStoreOp mStoreOp;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::TextureView> mView;

  GPURenderPassColorAttachment();

  explicit inline GPURenderPassColorAttachment(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPassColorAttachment(GPURenderPassColorAttachment&& aOther) = default;

  explicit inline GPURenderPassColorAttachment(const GPURenderPassColorAttachment& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mResolveTarget, "mResolveTarget", aFlags);
    ImplCycleCollectionTraverse(aCallback, mView, "mView", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mResolveTarget);
    ImplCycleCollectionUnlink(mView);
  }

  GPURenderPassColorAttachment&
  operator=(const GPURenderPassColorAttachment& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassColorAttachmentAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassColorAttachment : public GPURenderPassColorAttachment
{
  inline FastGPURenderPassColorAttachment()
    : GPURenderPassColorAttachment(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTextureDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUTextureDimension mDimension;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMipLevelCount;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSampleCount;
  MOZ_INIT_OUTSIDE_CTOR OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict mSize;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUsage;

  GPUTextureDescriptor();

  explicit inline GPUTextureDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUTextureDescriptor(GPUTextureDescriptor&& aOther) = default;

  explicit inline GPUTextureDescriptor(const GPUTextureDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUTextureDescriptor&
  operator=(const GPUTextureDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTextureDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTextureDescriptor : public GPUTextureDescriptor
{
  inline FastGPUTextureDescriptor()
    : GPUTextureDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUVertexState : public GPUProgrammableStage
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<Nullable<GPUVertexBufferLayout>> mBuffers;

  GPUVertexState();

  explicit inline GPUVertexState(const FastDictionaryInitializer& )
    : GPUProgrammableStage(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUVertexState(GPUVertexState&& aOther) = default;

  explicit inline GPUVertexState(const GPUVertexState& aOther)
    : GPUProgrammableStage(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUProgrammableStage::TraverseForCC(aCallback, aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUProgrammableStage::UnlinkForCC();
  }

  GPUVertexState&
  operator=(const GPUVertexState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUVertexStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUVertexState : public GPUVertexState
{
  inline FastGPUVertexState()
    : GPUVertexState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBindGroupDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUBindGroupEntry> mEntries;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::BindGroupLayout> mLayout;

  GPUBindGroupDescriptor();

  explicit inline GPUBindGroupDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBindGroupDescriptor(GPUBindGroupDescriptor&& aOther) = default;

  explicit inline GPUBindGroupDescriptor(const GPUBindGroupDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mEntries, "mEntries", aFlags);
    ImplCycleCollectionTraverse(aCallback, mLayout, "mLayout", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mEntries);
    ImplCycleCollectionUnlink(mLayout);
  }

  GPUBindGroupDescriptor&
  operator=(const GPUBindGroupDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupDescriptor : public GPUBindGroupDescriptor
{
  inline FastGPUBindGroupDescriptor()
    : GPUBindGroupDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUFragmentState : public GPUProgrammableStage
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUColorTargetState> mTargets;

  GPUFragmentState();

  explicit inline GPUFragmentState(const FastDictionaryInitializer& )
    : GPUProgrammableStage(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUFragmentState(GPUFragmentState&& aOther) = default;

  explicit inline GPUFragmentState(const GPUFragmentState& aOther)
    : GPUProgrammableStage(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUProgrammableStage::TraverseForCC(aCallback, aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUProgrammableStage::UnlinkForCC();
  }

  GPUFragmentState&
  operator=(const GPUFragmentState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUFragmentStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUFragmentState : public GPUFragmentState
{
  inline FastGPUFragmentState()
    : GPUFragmentState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUImageCopyTextureTagged : public GPUImageCopyTexture
{
  MOZ_INIT_OUTSIDE_CTOR bool mPremultipliedAlpha;

  GPUImageCopyTextureTagged();

  explicit inline GPUImageCopyTextureTagged(const FastDictionaryInitializer& )
    : GPUImageCopyTexture(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUImageCopyTextureTagged(GPUImageCopyTextureTagged&& aOther) = default;

  explicit inline GPUImageCopyTextureTagged(const GPUImageCopyTextureTagged& aOther)
    : GPUImageCopyTexture(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUImageCopyTexture::TraverseForCC(aCallback, aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUImageCopyTexture::UnlinkForCC();
  }

  GPUImageCopyTextureTagged&
  operator=(const GPUImageCopyTextureTagged& aOther);

  bool
  operator==(const GPUImageCopyTextureTagged& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUImageCopyTextureTaggedAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUImageCopyTextureTagged : public GPUImageCopyTextureTagged
{
  inline FastGPUImageCopyTextureTagged()
    : GPUImageCopyTextureTagged(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPURenderPassColorAttachment> mColorAttachments;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPURenderPassDepthStencilAttachment> mDepthStencilAttachment;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<mozilla::webgpu::QuerySet>> mOcclusionQuerySet;

  GPURenderPassDescriptor();

  explicit inline GPURenderPassDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPassDescriptor(GPURenderPassDescriptor&& aOther) = default;

  explicit inline GPURenderPassDescriptor(const GPURenderPassDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mColorAttachments, "mColorAttachments", aFlags);
    ImplCycleCollectionTraverse(aCallback, mDepthStencilAttachment, "mDepthStencilAttachment", aFlags);
    ImplCycleCollectionTraverse(aCallback, mOcclusionQuerySet, "mOcclusionQuerySet", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mColorAttachments);
    ImplCycleCollectionUnlink(mDepthStencilAttachment);
    ImplCycleCollectionUnlink(mOcclusionQuerySet);
  }

  GPURenderPassDescriptor&
  operator=(const GPURenderPassDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassDescriptor : public GPURenderPassDescriptor
{
  inline FastGPURenderPassDescriptor()
    : GPURenderPassDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPipelineDescriptor : public GPUPipelineDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUDepthStencilState> mDepthStencil;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUFragmentState> mFragment;
  MOZ_INIT_OUTSIDE_CTOR GPUMultisampleState mMultisample;
  MOZ_INIT_OUTSIDE_CTOR GPUPrimitiveState mPrimitive;
  MOZ_INIT_OUTSIDE_CTOR GPUVertexState mVertex;

  GPURenderPipelineDescriptor();

  explicit inline GPURenderPipelineDescriptor(const FastDictionaryInitializer& )
    : GPUPipelineDescriptorBase(FastDictionaryInitializer()),
      mMultisample(FastDictionaryInitializer()),
      mPrimitive(FastDictionaryInitializer()),
      mVertex(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPipelineDescriptor(GPURenderPipelineDescriptor&& aOther) = default;

  explicit inline GPURenderPipelineDescriptor(const GPURenderPipelineDescriptor& aOther)
    : GPUPipelineDescriptorBase(FastDictionaryInitializer()),
      mMultisample(FastDictionaryInitializer()),
      mPrimitive(FastDictionaryInitializer()),
      mVertex(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUPipelineDescriptorBase::TraverseForCC(aCallback, aFlags);
    ImplCycleCollectionTraverse(aCallback, mFragment, "mFragment", aFlags);
    ImplCycleCollectionTraverse(aCallback, mVertex, "mVertex", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUPipelineDescriptorBase::UnlinkForCC();
    ImplCycleCollectionUnlink(mFragment);
    ImplCycleCollectionUnlink(mVertex);
  }

  GPURenderPipelineDescriptor&
  operator=(const GPURenderPipelineDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPipelineDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPipelineDescriptor : public GPURenderPipelineDescriptor
{
  inline FastGPURenderPipelineDescriptor()
    : GPURenderPipelineDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace GPU_Binding {

  typedef mozilla::webgpu::Instance NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Instance* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPU,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPU,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPU,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPU_Binding



namespace GPUAdapter_Binding {

  typedef mozilla::webgpu::Adapter NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Adapter* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUAdapter,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUAdapter,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUAdapter,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUAdapter_Binding



namespace GPUAdapterInfo_Binding {

  typedef mozilla::webgpu::AdapterInfo NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::AdapterInfo* aObject, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUAdapterInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUAdapterInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUAdapterInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUAdapterInfo_Binding



namespace GPUBindGroup_Binding {

  typedef mozilla::webgpu::BindGroup NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::BindGroup* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUBindGroup,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBindGroup,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBindGroup,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUBindGroup_Binding



namespace GPUBindGroupLayout_Binding {

  typedef mozilla::webgpu::BindGroupLayout NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::BindGroupLayout* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUBindGroupLayout,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBindGroupLayout,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBindGroupLayout,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUBindGroupLayout_Binding



namespace GPUBuffer_Binding {

  typedef mozilla::webgpu::Buffer NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Buffer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUBuffer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBuffer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBuffer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUBuffer_Binding



namespace GPUBufferUsage_Binding {

  typedef mozilla::dom::GPUBufferUsage NativeType;

  static const uint32_t MAP_READ = 1;
  static const uint32_t MAP_WRITE = 2;
  static const uint32_t COPY_SRC = 4;
  static const uint32_t COPY_DST = 8;
  static const uint32_t INDEX = 16;
  static const uint32_t VERTEX = 32;
  static const uint32_t UNIFORM = 64;
  static const uint32_t STORAGE = 128;
  static const uint32_t INDIRECT = 256;
  static const uint32_t QUERY_RESOLVE = 512;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBufferUsage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBufferUsage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUBufferUsage_Binding



namespace GPUCanvasContext_Binding {

  typedef mozilla::webgpu::CanvasContext NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CanvasContext* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUCanvasContext,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCanvasContext,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCanvasContext,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUCanvasContext_Binding



namespace GPUColorWrite_Binding {

  typedef mozilla::dom::GPUColorWrite NativeType;

  static const uint32_t RED = 1;
  static const uint32_t GREEN = 2;
  static const uint32_t BLUE = 4;
  static const uint32_t ALPHA = 8;
  static const uint32_t ALL = 15;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUColorWrite,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUColorWrite,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUColorWrite_Binding



namespace GPUCommandBuffer_Binding {

  typedef mozilla::webgpu::CommandBuffer NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CommandBuffer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUCommandBuffer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCommandBuffer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCommandBuffer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUCommandBuffer_Binding



namespace GPUCommandEncoder_Binding {

  typedef mozilla::webgpu::CommandEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CommandEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUCommandEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCommandEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCommandEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUCommandEncoder_Binding



namespace GPUCompilationInfo_Binding {

  typedef mozilla::webgpu::CompilationInfo NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CompilationInfo* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedMessagesValue(mozilla::webgpu::CompilationInfo* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUCompilationInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCompilationInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCompilationInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUCompilationInfo_Binding



namespace GPUCompilationMessage_Binding {

  typedef mozilla::webgpu::CompilationMessage NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CompilationMessage* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUCompilationMessage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCompilationMessage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCompilationMessage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUCompilationMessage_Binding



namespace GPUComputePassEncoder_Binding {

  typedef mozilla::webgpu::ComputePassEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ComputePassEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUComputePassEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUComputePassEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUComputePassEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUComputePassEncoder_Binding



namespace GPUComputePipeline_Binding {

  typedef mozilla::webgpu::ComputePipeline NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ComputePipeline* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUComputePipeline,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUComputePipeline,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUComputePipeline,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUComputePipeline_Binding



namespace GPUDevice_Binding {

  typedef mozilla::webgpu::Device NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Device* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUDevice,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUDevice,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUDevice,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUDevice_Binding



namespace GPUDeviceLostInfo_Binding {

  typedef mozilla::webgpu::DeviceLostInfo NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::DeviceLostInfo* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUDeviceLostInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUDeviceLostInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUDeviceLostInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUDeviceLostInfo_Binding



namespace GPUMapMode_Binding {

  typedef mozilla::dom::GPUMapMode NativeType;

  static const uint32_t READ = 1;
  static const uint32_t WRITE = 2;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUMapMode,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUMapMode,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUMapMode_Binding



namespace GPUOutOfMemoryError_Binding {

  typedef mozilla::webgpu::OutOfMemoryError NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::OutOfMemoryError* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUOutOfMemoryError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUOutOfMemoryError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUOutOfMemoryError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUOutOfMemoryError_Binding



namespace GPUPipelineLayout_Binding {

  typedef mozilla::webgpu::PipelineLayout NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::PipelineLayout* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUPipelineLayout,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUPipelineLayout,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUPipelineLayout,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUPipelineLayout_Binding



namespace GPUQuerySet_Binding {

  typedef mozilla::webgpu::QuerySet NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::QuerySet* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUQuerySet,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUQuerySet,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUQuerySet,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUQuerySet_Binding



namespace GPUQueue_Binding {

  typedef mozilla::webgpu::Queue NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Queue* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUQueue,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUQueue,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUQueue,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUQueue_Binding



namespace GPURenderBundle_Binding {

  typedef mozilla::webgpu::RenderBundle NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderBundle* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPURenderBundle,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderBundle,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderBundle,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPURenderBundle_Binding



namespace GPURenderBundleEncoder_Binding {

  typedef mozilla::webgpu::RenderBundleEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderBundleEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPURenderBundleEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderBundleEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderBundleEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPURenderBundleEncoder_Binding



namespace GPURenderPassEncoder_Binding {

  typedef mozilla::webgpu::RenderPassEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderPassEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPURenderPassEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderPassEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderPassEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPURenderPassEncoder_Binding



namespace GPURenderPipeline_Binding {

  typedef mozilla::webgpu::RenderPipeline NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderPipeline* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPURenderPipeline,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderPipeline,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderPipeline,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPURenderPipeline_Binding



namespace GPUSampler_Binding {

  typedef mozilla::webgpu::Sampler NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Sampler* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUSampler,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSampler,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSampler,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUSampler_Binding



namespace GPUShaderModule_Binding {

  typedef mozilla::webgpu::ShaderModule NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ShaderModule* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUShaderModule,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUShaderModule,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUShaderModule,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUShaderModule_Binding



namespace GPUShaderStage_Binding {

  typedef mozilla::dom::GPUShaderStage NativeType;

  static const uint32_t VERTEX = 1;
  static const uint32_t FRAGMENT = 2;
  static const uint32_t COMPUTE = 4;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUShaderStage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUShaderStage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUShaderStage_Binding



namespace GPUSupportedFeatures_Binding {

  typedef mozilla::webgpu::SupportedFeatures NativeType;

  namespace SetlikeHelpers {
  void
  Clear(mozilla::webgpu::SupportedFeatures* self, ErrorResult& aRv);
  bool
  Delete(mozilla::webgpu::SupportedFeatures* self, const nsAString& aKey, ErrorResult& aRv);
  bool
  Has(mozilla::webgpu::SupportedFeatures* self, const nsAString& aKey, ErrorResult& aRv);
  void
  Add(mozilla::webgpu::SupportedFeatures* self, const nsAString& aKey, ErrorResult& aRv);
  } // namespace SetlikeHelpers

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::SupportedFeatures* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUSupportedFeatures,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSupportedFeatures,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSupportedFeatures,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUSupportedFeatures_Binding



namespace GPUSupportedLimits_Binding {

  typedef mozilla::webgpu::SupportedLimits NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::SupportedLimits* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUSupportedLimits,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSupportedLimits,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSupportedLimits,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUSupportedLimits_Binding



namespace GPUTexture_Binding {

  typedef mozilla::webgpu::Texture NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Texture* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUTexture,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTexture,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTexture,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUTexture_Binding



namespace GPUTextureUsage_Binding {

  typedef mozilla::dom::GPUTextureUsage NativeType;

  static const uint32_t COPY_SRC = 1;
  static const uint32_t COPY_DST = 2;
  static const uint32_t TEXTURE_BINDING = 4;
  static const uint32_t STORAGE_BINDING = 8;
  static const uint32_t RENDER_ATTACHMENT = 16;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTextureUsage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTextureUsage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUTextureUsage_Binding



namespace GPUTextureView_Binding {

  typedef mozilla::webgpu::TextureView NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::TextureView* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUTextureView,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTextureView,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTextureView,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUTextureView_Binding



namespace GPUValidationError_Binding {

  typedef mozilla::webgpu::ValidationError NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ValidationError* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUValidationError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUValidationError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUValidationError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUValidationError_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_WebGPUBinding_h
