// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanFirefoxviewMetrics_h
#define mozilla_GleanFirefoxviewMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace firefoxview {
  /**
   * generated from firefoxview.cumulative_searches
   */
  enum class CumulativeSearchesLabel: uint16_t {
    eRecentbrowsing = 0,
    eOpentabs = 1,
    eRecentlyclosed = 2,
    eHistory = 3,
    eSyncedtabs = 4,
    e__Other__,
  };
  /**
   * Cumulative no. of searches performed before selecting a resulting tab.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram FIREFOX_VIEW_CUMULATIVE_SEARCHES.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, CumulativeSearchesLabel> cumulative_searches(309);
}

namespace firefoxview_next {
  /**
   * generated from firefoxview_next.browser_context_menu_tabs
   */
  struct BrowserContextMenuTabsExtra {
    mozilla::Maybe<nsCString> menuAction;
    mozilla::Maybe<nsCString> page;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (menuAction) {
        extraKeys.AppendElement()->AssignASCII("menu_action");
        extraValues.EmplaceBack(menuAction.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a browser context menu selection is made in Firefox View This event was generated to correspond to the Legacy Telemetry event firefoxview_next.browser_context_menu#tabs.
   */
  constexpr impl::EventMetric<BrowserContextMenuTabsExtra> browser_context_menu_tabs(310);

  /**
   * generated from firefoxview_next.card_collapsed_card_container
   */
  struct CardCollapsedCardContainerExtra {
    mozilla::Maybe<nsCString> dataType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (dataType) {
        extraKeys.AppendElement()->AssignASCII("data_type");
        extraValues.EmplaceBack(dataType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a card-container is collapsed on the 'Recent browsing' page This event was generated to correspond to the Legacy Telemetry event firefoxview_next.card_collapsed#card_container.
   */
  constexpr impl::EventMetric<CardCollapsedCardContainerExtra> card_collapsed_card_container(311);

  /**
   * generated from firefoxview_next.card_expanded_card_container
   */
  struct CardExpandedCardContainerExtra {
    mozilla::Maybe<nsCString> dataType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (dataType) {
        extraKeys.AppendElement()->AssignASCII("data_type");
        extraValues.EmplaceBack(dataType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a card-container is expanded on the 'Recent browsing' page This event was generated to correspond to the Legacy Telemetry event firefoxview_next.card_expanded#card_container.
   */
  constexpr impl::EventMetric<CardExpandedCardContainerExtra> card_expanded_card_container(312);

  /**
   * generated from firefoxview_next.change_page_navigation
   */
  struct ChangePageNavigationExtra {
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the page/view is changed in Firefox View This event was generated to correspond to the Legacy Telemetry event firefoxview_next.change_page#navigation.
   */
  constexpr impl::EventMetric<ChangePageNavigationExtra> change_page_navigation(313);

  /**
   * generated from firefoxview_next.close_open_tab_tabs
   */
  /**
   * Recorded when a tab is closed via the close button on an open tab row. This event was generated to correspond to the Legacy Telemetry event firefoxview_next.close_open_tab#tabs.
   */
  constexpr impl::EventMetric<NoExtraKeys> close_open_tab_tabs(314);

  /**
   * generated from firefoxview_next.context_menu_tabs
   */
  struct ContextMenuTabsExtra {
    mozilla::Maybe<nsCString> dataType;
    mozilla::Maybe<nsCString> menuAction;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (dataType) {
        extraKeys.AppendElement()->AssignASCII("data_type");
        extraValues.EmplaceBack(dataType.value());
      }
      if (menuAction) {
        extraKeys.AppendElement()->AssignASCII("menu_action");
        extraValues.EmplaceBack(menuAction.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a context menu selection is made in Firefox View This event was generated to correspond to the Legacy Telemetry event firefoxview_next.context_menu#tabs.
   */
  constexpr impl::EventMetric<ContextMenuTabsExtra> context_menu_tabs(315);

  /**
   * generated from firefoxview_next.dismiss_closed_tab_tabs
   */
  struct DismissClosedTabTabsExtra {
    mozilla::Maybe<nsCString> delta;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<uint32_t> position;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (delta) {
        extraKeys.AppendElement()->AssignASCII("delta");
        extraValues.EmplaceBack(delta.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a recently closed tab is dismissed This event was generated to correspond to the Legacy Telemetry event firefoxview_next.dismiss_closed_tab#tabs.
   */
  constexpr impl::EventMetric<DismissClosedTabTabsExtra> dismiss_closed_tab_tabs(316);

  /**
   * generated from firefoxview_next.entered_firefoxview
   */
  struct EnteredFirefoxviewExtra {
    mozilla::Maybe<nsCString> page;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the Firefox View tab is selected This event was generated to correspond to the Legacy Telemetry event firefoxview_next.entered#firefoxview.
   */
  constexpr impl::EventMetric<EnteredFirefoxviewExtra> entered_firefoxview(317);

  /**
   * generated from firefoxview_next.fxa_continue_sync
   */
  /**
   * Recorded when button to sign in or sign up is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.fxa_continue#sync.
   */
  constexpr impl::EventMetric<NoExtraKeys> fxa_continue_sync(318);

  /**
   * generated from firefoxview_next.fxa_mobile_sync
   */
  struct FxaMobileSyncExtra {
    mozilla::Maybe<bool> hasDevices;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasDevices) {
        extraKeys.AppendElement()->AssignASCII("has_devices");
        extraValues.AppendElement()->AssignASCII(hasDevices.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the 'Try Firefox for mobile' button is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.fxa_mobile#sync.
   */
  constexpr impl::EventMetric<FxaMobileSyncExtra> fxa_mobile_sync(319);

  /**
   * generated from firefoxview_next.history_visits
   */
  /**
   * Recorded when a history tab is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.history#visits.
   */
  constexpr impl::EventMetric<NoExtraKeys> history_visits(320);

  /**
   * generated from firefoxview_next.open_tab_tabs
   */
  struct OpenTabTabsExtra {
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<nsCString> window;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (window) {
        extraKeys.AppendElement()->AssignASCII("window");
        extraValues.EmplaceBack(window.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when an open tab is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.open_tab#tabs.
   */
  constexpr impl::EventMetric<OpenTabTabsExtra> open_tab_tabs(321);

  /**
   * generated from firefoxview_next.recently_closed_tabs
   */
  struct RecentlyClosedTabsExtra {
    mozilla::Maybe<nsCString> delta;
    mozilla::Maybe<nsCString> page;
    mozilla::Maybe<uint32_t> position;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (delta) {
        extraKeys.AppendElement()->AssignASCII("delta");
        extraValues.EmplaceBack(delta.value());
      }
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      if (position) {
        extraKeys.AppendElement()->AssignASCII("position");
        extraValues.AppendElement()->AppendInt(position.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a recently closed tab is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.recently_closed#tabs.
   */
  constexpr impl::EventMetric<RecentlyClosedTabsExtra> recently_closed_tabs(322);

  /**
   * generated from firefoxview_next.search_initiated_search
   */
  struct SearchInitiatedSearchExtra {
    mozilla::Maybe<nsCString> page;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when search is initiated and from what page. This event was generated to correspond to the Legacy Telemetry event firefoxview_next.search_initiated#search.
   */
  constexpr impl::EventMetric<SearchInitiatedSearchExtra> search_initiated_search(323);

  /**
   * generated from firefoxview_next.search_show_all_showallbutton
   */
  struct SearchShowAllShowallbuttonExtra {
    mozilla::Maybe<nsCString> section;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (section) {
        extraKeys.AppendElement()->AssignASCII("section");
        extraValues.EmplaceBack(section.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the show all button is clicked to show more search results. This event was generated to correspond to the Legacy Telemetry event firefoxview_next.search_show_all#showallbutton.
   */
  constexpr impl::EventMetric<SearchShowAllShowallbuttonExtra> search_show_all_showallbutton(324);

  /**
   * generated from firefoxview_next.show_all_history_tabs
   */
  /**
   * Recorded when the 'Show all history' button is clicked on the History page in Firefox View This event was generated to correspond to the Legacy Telemetry event firefoxview_next.show_all_history#tabs.
   */
  constexpr impl::EventMetric<NoExtraKeys> show_all_history_tabs(325);

  /**
   * generated from firefoxview_next.sort_history_tabs
   */
  struct SortHistoryTabsExtra {
    mozilla::Maybe<nsCString> searchStart;
    mozilla::Maybe<nsCString> sortType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (searchStart) {
        extraKeys.AppendElement()->AssignASCII("search_start");
        extraValues.EmplaceBack(searchStart.value());
      }
      if (sortType) {
        extraKeys.AppendElement()->AssignASCII("sort_type");
        extraValues.EmplaceBack(sortType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the sort option is changed for History in Firefox View This event was generated to correspond to the Legacy Telemetry event firefoxview_next.sort_history#tabs.
   */
  constexpr impl::EventMetric<SortHistoryTabsExtra> sort_history_tabs(326);

  /**
   * generated from firefoxview_next.synced_tabs_tabs
   */
  struct SyncedTabsTabsExtra {
    mozilla::Maybe<nsCString> page;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (page) {
        extraKeys.AppendElement()->AssignASCII("page");
        extraValues.EmplaceBack(page.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a synced tab is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.synced_tabs#tabs.
   */
  constexpr impl::EventMetric<SyncedTabsTabsExtra> synced_tabs_tabs(327);

  /**
   * generated from firefoxview_next.tab_selected_toolbarbutton
   */
  /**
   * Recorded when the Firefox View tab is clicked This event was generated to correspond to the Legacy Telemetry event firefoxview_next.tab_selected#toolbarbutton.
   */
  constexpr impl::EventMetric<NoExtraKeys> tab_selected_toolbarbutton(328);
}

} // namespace mozilla::glean

#endif // mozilla_GleanFirefoxviewMetrics_h
