// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanFormautofillMetrics_h
#define mozilla_GleanFormautofillMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace address {
  /**
   * generated from address.add_manage
   */
  struct AddManageExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for address autofill preferences management UI. This event was generated to correspond to the Legacy Telemetry event address.add#manage.
   */
  constexpr impl::EventMetric<AddManageExtra> add_manage(4758);

  /**
   * generated from address.cancel_capture_doorhanger
   */
  struct CancelCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.cancel#capture_doorhanger.
   */
  constexpr impl::EventMetric<CancelCaptureDoorhangerExtra> cancel_capture_doorhanger(4759);

  /**
   * generated from address.cancel_edit_doorhanger
   */
  struct CancelEditDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.cancel#edit_doorhanger.
   */
  constexpr impl::EventMetric<CancelEditDoorhangerExtra> cancel_edit_doorhanger(4760);

  /**
   * generated from address.cancel_update_doorhanger
   */
  struct CancelUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.cancel#update_doorhanger.
   */
  constexpr impl::EventMetric<CancelUpdateDoorhangerExtra> cancel_update_doorhanger(4761);

  /**
   * generated from address.cleared_address_form
   */
  struct ClearedAddressFormExtra {
    mozilla::Maybe<nsCString> fieldName;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fieldName) {
        extraKeys.AppendElement()->AssignASCII("field_name");
        extraValues.EmplaceBack(fieldName.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a form is cleared. Using field_name to record the field that triggers this event
   * This event was generated to correspond to the Legacy Telemetry event address.cleared#address_form.
   */
  constexpr impl::EventMetric<ClearedAddressFormExtra> cleared_address_form(4762);

  /**
   * generated from address.delete_manage
   */
  struct DeleteManageExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for address autofill preferences management UI. This event was generated to correspond to the Legacy Telemetry event address.delete#manage.
   */
  constexpr impl::EventMetric<DeleteManageExtra> delete_manage(4763);

  /**
   * generated from address.detected_address_form
   */
  struct DetectedAddressFormExtra {
    mozilla::Maybe<nsCString> addressLevel1;
    mozilla::Maybe<nsCString> addressLevel2;
    mozilla::Maybe<nsCString> addressLine1;
    mozilla::Maybe<nsCString> addressLine2;
    mozilla::Maybe<nsCString> addressLine3;
    mozilla::Maybe<nsCString> country;
    mozilla::Maybe<nsCString> postalCode;
    mozilla::Maybe<nsCString> streetAddress;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addressLevel1) {
        extraKeys.AppendElement()->AssignASCII("address_level1");
        extraValues.EmplaceBack(addressLevel1.value());
      }
      if (addressLevel2) {
        extraKeys.AppendElement()->AssignASCII("address_level2");
        extraValues.EmplaceBack(addressLevel2.value());
      }
      if (addressLine1) {
        extraKeys.AppendElement()->AssignASCII("address_line1");
        extraValues.EmplaceBack(addressLine1.value());
      }
      if (addressLine2) {
        extraKeys.AppendElement()->AssignASCII("address_line2");
        extraValues.EmplaceBack(addressLine2.value());
      }
      if (addressLine3) {
        extraKeys.AppendElement()->AssignASCII("address_line3");
        extraValues.EmplaceBack(addressLine3.value());
      }
      if (country) {
        extraKeys.AppendElement()->AssignASCII("country");
        extraValues.EmplaceBack(country.value());
      }
      if (postalCode) {
        extraKeys.AppendElement()->AssignASCII("postal_code");
        extraValues.EmplaceBack(postalCode.value());
      }
      if (streetAddress) {
        extraKeys.AppendElement()->AssignASCII("street_address");
        extraValues.EmplaceBack(streetAddress.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a form is recognized as an address form. The possible values in the extra_keys are "true", "false", or 0. When the value is "true", the field is identified via autocomplete attribute. When the value is "false", the field is not detected in the form. When the value is an 0, then the field is identified by regexp-based heuristic.
   * This event was generated to correspond to the Legacy Telemetry event address.detected#address_form.
   */
  constexpr impl::EventMetric<DetectedAddressFormExtra> detected_address_form(4764);

  /**
   * generated from address.detected_address_form_ext
   */
  struct DetectedAddressFormExtExtra {
    mozilla::Maybe<nsCString> additionalName;
    mozilla::Maybe<nsCString> email;
    mozilla::Maybe<nsCString> familyName;
    mozilla::Maybe<nsCString> givenName;
    mozilla::Maybe<nsCString> name;
    mozilla::Maybe<nsCString> organization;
    mozilla::Maybe<nsCString> tel;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (additionalName) {
        extraKeys.AppendElement()->AssignASCII("additional_name");
        extraValues.EmplaceBack(additionalName.value());
      }
      if (email) {
        extraKeys.AppendElement()->AssignASCII("email");
        extraValues.EmplaceBack(email.value());
      }
      if (familyName) {
        extraKeys.AppendElement()->AssignASCII("family_name");
        extraValues.EmplaceBack(familyName.value());
      }
      if (givenName) {
        extraKeys.AppendElement()->AssignASCII("given_name");
        extraValues.EmplaceBack(givenName.value());
      }
      if (name) {
        extraKeys.AppendElement()->AssignASCII("name");
        extraValues.EmplaceBack(name.value());
      }
      if (organization) {
        extraKeys.AppendElement()->AssignASCII("organization");
        extraValues.EmplaceBack(organization.value());
      }
      if (tel) {
        extraKeys.AppendElement()->AssignASCII("tel");
        extraValues.EmplaceBack(tel.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Address has too many fields so we cannot cover them all in the above `address_form` telemetry This telemetry is used to record address fields that are not listed in `address_form` This event was generated to correspond to the Legacy Telemetry event address.detected#address_form_ext.
   */
  constexpr impl::EventMetric<DetectedAddressFormExtExtra> detected_address_form_ext(4765);

  /**
   * generated from address.disable_capture_doorhanger
   */
  struct DisableCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.disable#capture_doorhanger.
   */
  constexpr impl::EventMetric<DisableCaptureDoorhangerExtra> disable_capture_doorhanger(4766);

  /**
   * generated from address.disable_edit_doorhanger
   */
  struct DisableEditDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.disable#edit_doorhanger.
   */
  constexpr impl::EventMetric<DisableEditDoorhangerExtra> disable_edit_doorhanger(4767);

  /**
   * generated from address.disable_update_doorhanger
   */
  struct DisableUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.disable#update_doorhanger.
   */
  constexpr impl::EventMetric<DisableUpdateDoorhangerExtra> disable_update_doorhanger(4768);

  /**
   * generated from address.edit_manage
   */
  struct EditManageExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for address autofill preferences management UI. This event was generated to correspond to the Legacy Telemetry event address.edit#manage.
   */
  constexpr impl::EventMetric<EditManageExtra> edit_manage(4769);

  /**
   * generated from address.filled_address_form
   */
  struct FilledAddressFormExtra {
    mozilla::Maybe<nsCString> addressLevel1;
    mozilla::Maybe<nsCString> addressLevel2;
    mozilla::Maybe<nsCString> addressLine1;
    mozilla::Maybe<nsCString> addressLine2;
    mozilla::Maybe<nsCString> addressLine3;
    mozilla::Maybe<nsCString> country;
    mozilla::Maybe<nsCString> postalCode;
    mozilla::Maybe<nsCString> streetAddress;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addressLevel1) {
        extraKeys.AppendElement()->AssignASCII("address_level1");
        extraValues.EmplaceBack(addressLevel1.value());
      }
      if (addressLevel2) {
        extraKeys.AppendElement()->AssignASCII("address_level2");
        extraValues.EmplaceBack(addressLevel2.value());
      }
      if (addressLine1) {
        extraKeys.AppendElement()->AssignASCII("address_line1");
        extraValues.EmplaceBack(addressLine1.value());
      }
      if (addressLine2) {
        extraKeys.AppendElement()->AssignASCII("address_line2");
        extraValues.EmplaceBack(addressLine2.value());
      }
      if (addressLine3) {
        extraKeys.AppendElement()->AssignASCII("address_line3");
        extraValues.EmplaceBack(addressLine3.value());
      }
      if (country) {
        extraKeys.AppendElement()->AssignASCII("country");
        extraValues.EmplaceBack(country.value());
      }
      if (postalCode) {
        extraKeys.AppendElement()->AssignASCII("postal_code");
        extraValues.EmplaceBack(postalCode.value());
      }
      if (streetAddress) {
        extraKeys.AppendElement()->AssignASCII("street_address");
        extraValues.EmplaceBack(streetAddress.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a form is autofiled. Possible values are `filled`, `not_filled`, `user_filled` or `unavailable`.
   * This event was generated to correspond to the Legacy Telemetry event address.filled#address_form.
   */
  constexpr impl::EventMetric<FilledAddressFormExtra> filled_address_form(4770);

  /**
   * generated from address.filled_address_form_ext
   */
  struct FilledAddressFormExtExtra {
    mozilla::Maybe<nsCString> additionalName;
    mozilla::Maybe<nsCString> email;
    mozilla::Maybe<nsCString> familyName;
    mozilla::Maybe<nsCString> givenName;
    mozilla::Maybe<nsCString> name;
    mozilla::Maybe<nsCString> organization;
    mozilla::Maybe<nsCString> tel;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (additionalName) {
        extraKeys.AppendElement()->AssignASCII("additional_name");
        extraValues.EmplaceBack(additionalName.value());
      }
      if (email) {
        extraKeys.AppendElement()->AssignASCII("email");
        extraValues.EmplaceBack(email.value());
      }
      if (familyName) {
        extraKeys.AppendElement()->AssignASCII("family_name");
        extraValues.EmplaceBack(familyName.value());
      }
      if (givenName) {
        extraKeys.AppendElement()->AssignASCII("given_name");
        extraValues.EmplaceBack(givenName.value());
      }
      if (name) {
        extraKeys.AppendElement()->AssignASCII("name");
        extraValues.EmplaceBack(name.value());
      }
      if (organization) {
        extraKeys.AppendElement()->AssignASCII("organization");
        extraValues.EmplaceBack(organization.value());
      }
      if (tel) {
        extraKeys.AppendElement()->AssignASCII("tel");
        extraValues.EmplaceBack(tel.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Address has too many fields so we cannot cover them all in the above `address_form` telemetry This telemetry is used to record address fields that are not listed in `address_form` This event was generated to correspond to the Legacy Telemetry event address.filled#address_form_ext.
   */
  constexpr impl::EventMetric<FilledAddressFormExtExtra> filled_address_form_ext(4771);

  /**
   * generated from address.filled_modified_address_form
   */
  struct FilledModifiedAddressFormExtra {
    mozilla::Maybe<nsCString> addressLevel1;
    mozilla::Maybe<nsCString> addressLevel2;
    mozilla::Maybe<nsCString> addressLine1;
    mozilla::Maybe<nsCString> addressLine2;
    mozilla::Maybe<nsCString> addressLine3;
    mozilla::Maybe<nsCString> country;
    mozilla::Maybe<nsCString> fieldName;
    mozilla::Maybe<nsCString> postalCode;
    mozilla::Maybe<nsCString> streetAddress;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addressLevel1) {
        extraKeys.AppendElement()->AssignASCII("address_level1");
        extraValues.EmplaceBack(addressLevel1.value());
      }
      if (addressLevel2) {
        extraKeys.AppendElement()->AssignASCII("address_level2");
        extraValues.EmplaceBack(addressLevel2.value());
      }
      if (addressLine1) {
        extraKeys.AppendElement()->AssignASCII("address_line1");
        extraValues.EmplaceBack(addressLine1.value());
      }
      if (addressLine2) {
        extraKeys.AppendElement()->AssignASCII("address_line2");
        extraValues.EmplaceBack(addressLine2.value());
      }
      if (addressLine3) {
        extraKeys.AppendElement()->AssignASCII("address_line3");
        extraValues.EmplaceBack(addressLine3.value());
      }
      if (country) {
        extraKeys.AppendElement()->AssignASCII("country");
        extraValues.EmplaceBack(country.value());
      }
      if (fieldName) {
        extraKeys.AppendElement()->AssignASCII("field_name");
        extraValues.EmplaceBack(fieldName.value());
      }
      if (postalCode) {
        extraKeys.AppendElement()->AssignASCII("postal_code");
        extraValues.EmplaceBack(postalCode.value());
      }
      if (streetAddress) {
        extraKeys.AppendElement()->AssignASCII("street_address");
        extraValues.EmplaceBack(streetAddress.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a field is autofilled and then modified by the user. Using field_name to record the field that triggers this event.
   * This event was generated to correspond to the Legacy Telemetry event address.filled_modified#address_form.
   */
  constexpr impl::EventMetric<FilledModifiedAddressFormExtra> filled_modified_address_form(4772);

  /**
   * generated from address.filled_on_fields_update_address_form
   */
  struct FilledOnFieldsUpdateAddressFormExtra {
    mozilla::Maybe<nsCString> additionalName;
    mozilla::Maybe<nsCString> addressLevel1;
    mozilla::Maybe<nsCString> addressLevel2;
    mozilla::Maybe<nsCString> addressLine1;
    mozilla::Maybe<nsCString> addressLine2;
    mozilla::Maybe<nsCString> addressLine3;
    mozilla::Maybe<nsCString> country;
    mozilla::Maybe<nsCString> email;
    mozilla::Maybe<nsCString> familyName;
    mozilla::Maybe<nsCString> givenName;
    mozilla::Maybe<nsCString> name;
    mozilla::Maybe<nsCString> organization;
    mozilla::Maybe<nsCString> postalCode;
    mozilla::Maybe<nsCString> streetAddress;
    mozilla::Maybe<nsCString> tel;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (additionalName) {
        extraKeys.AppendElement()->AssignASCII("additional_name");
        extraValues.EmplaceBack(additionalName.value());
      }
      if (addressLevel1) {
        extraKeys.AppendElement()->AssignASCII("address_level1");
        extraValues.EmplaceBack(addressLevel1.value());
      }
      if (addressLevel2) {
        extraKeys.AppendElement()->AssignASCII("address_level2");
        extraValues.EmplaceBack(addressLevel2.value());
      }
      if (addressLine1) {
        extraKeys.AppendElement()->AssignASCII("address_line1");
        extraValues.EmplaceBack(addressLine1.value());
      }
      if (addressLine2) {
        extraKeys.AppendElement()->AssignASCII("address_line2");
        extraValues.EmplaceBack(addressLine2.value());
      }
      if (addressLine3) {
        extraKeys.AppendElement()->AssignASCII("address_line3");
        extraValues.EmplaceBack(addressLine3.value());
      }
      if (country) {
        extraKeys.AppendElement()->AssignASCII("country");
        extraValues.EmplaceBack(country.value());
      }
      if (email) {
        extraKeys.AppendElement()->AssignASCII("email");
        extraValues.EmplaceBack(email.value());
      }
      if (familyName) {
        extraKeys.AppendElement()->AssignASCII("family_name");
        extraValues.EmplaceBack(familyName.value());
      }
      if (givenName) {
        extraKeys.AppendElement()->AssignASCII("given_name");
        extraValues.EmplaceBack(givenName.value());
      }
      if (name) {
        extraKeys.AppendElement()->AssignASCII("name");
        extraValues.EmplaceBack(name.value());
      }
      if (organization) {
        extraKeys.AppendElement()->AssignASCII("organization");
        extraValues.EmplaceBack(organization.value());
      }
      if (postalCode) {
        extraKeys.AppendElement()->AssignASCII("postal_code");
        extraValues.EmplaceBack(postalCode.value());
      }
      if (streetAddress) {
        extraKeys.AppendElement()->AssignASCII("street_address");
        extraValues.EmplaceBack(streetAddress.value());
      }
      if (tel) {
        extraKeys.AppendElement()->AssignASCII("tel");
        extraValues.EmplaceBack(tel.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a previous autofill action for the address form causes an immediate fields update which triggers another autofill action including for the new/updated fields. Possible values are `filled`, `filled_on_fields_update`, `user_filled` or `unavailable`. Unlike the other address form interaction events, this doesn't need a `address_form` and `address_form_ext` event because it's only collected in Glean (not mirror to Legacy).
   */
  constexpr impl::EventMetric<FilledOnFieldsUpdateAddressFormExtra> filled_on_fields_update_address_form(4773);

  /**
   * generated from address.learn_more_capture_doorhanger
   */
  struct LearnMoreCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.learn_more#capture_doorhanger.
   */
  constexpr impl::EventMetric<LearnMoreCaptureDoorhangerExtra> learn_more_capture_doorhanger(4774);

  /**
   * generated from address.learn_more_edit_doorhanger
   */
  struct LearnMoreEditDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.learn_more#edit_doorhanger.
   */
  constexpr impl::EventMetric<LearnMoreEditDoorhangerExtra> learn_more_edit_doorhanger(4775);

  /**
   * generated from address.learn_more_update_doorhanger
   */
  struct LearnMoreUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.learn_more#update_doorhanger.
   */
  constexpr impl::EventMetric<LearnMoreUpdateDoorhangerExtra> learn_more_update_doorhanger(4776);

  /**
   * generated from address.popup_shown_address_form
   */
  struct PopupShownAddressFormExtra {
    mozilla::Maybe<nsCString> fieldName;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fieldName) {
        extraKeys.AppendElement()->AssignASCII("field_name");
        extraValues.EmplaceBack(fieldName.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when autofill popup is shown. Using field_name to record the field that triggers this event.
   * This event was generated to correspond to the Legacy Telemetry event address.popup_shown#address_form.
   */
  constexpr impl::EventMetric<PopupShownAddressFormExtra> popup_shown_address_form(4777);

  /**
   * generated from address.pref_capture_doorhanger
   */
  struct PrefCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.pref#capture_doorhanger.
   */
  constexpr impl::EventMetric<PrefCaptureDoorhangerExtra> pref_capture_doorhanger(4778);

  /**
   * generated from address.pref_edit_doorhanger
   */
  struct PrefEditDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.pref#edit_doorhanger.
   */
  constexpr impl::EventMetric<PrefEditDoorhangerExtra> pref_edit_doorhanger(4779);

  /**
   * generated from address.pref_update_doorhanger
   */
  struct PrefUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.pref#update_doorhanger.
   */
  constexpr impl::EventMetric<PrefUpdateDoorhangerExtra> pref_update_doorhanger(4780);

  /**
   * generated from address.save_capture_doorhanger
   */
  struct SaveCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.save#capture_doorhanger.
   */
  constexpr impl::EventMetric<SaveCaptureDoorhangerExtra> save_capture_doorhanger(4781);

  /**
   * generated from address.save_edit_doorhanger
   */
  struct SaveEditDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.save#edit_doorhanger.
   */
  constexpr impl::EventMetric<SaveEditDoorhangerExtra> save_edit_doorhanger(4782);

  /**
   * generated from address.save_update_doorhanger
   */
  struct SaveUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.save#update_doorhanger.
   */
  constexpr impl::EventMetric<SaveUpdateDoorhangerExtra> save_update_doorhanger(4783);

  /**
   * generated from address.show_capture_doorhanger
   */
  struct ShowCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.show#capture_doorhanger.
   */
  constexpr impl::EventMetric<ShowCaptureDoorhangerExtra> show_capture_doorhanger(4784);

  /**
   * generated from address.show_edit_doorhanger
   */
  struct ShowEditDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.show#edit_doorhanger.
   */
  constexpr impl::EventMetric<ShowEditDoorhangerExtra> show_edit_doorhanger(4785);

  /**
   * generated from address.show_entry_manage
   */
  struct ShowEntryManageExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for address autofill preferences management UI. This event was generated to correspond to the Legacy Telemetry event address.show_entry#manage.
   */
  constexpr impl::EventMetric<ShowEntryManageExtra> show_entry_manage(4786);

  /**
   * generated from address.show_manage
   */
  struct ShowManageExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for address autofill preferences management UI. This event was generated to correspond to the Legacy Telemetry event address.show#manage.
   */
  constexpr impl::EventMetric<ShowManageExtra> show_manage(4787);

  /**
   * generated from address.show_update_doorhanger
   */
  struct ShowUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.show#update_doorhanger.
   */
  constexpr impl::EventMetric<ShowUpdateDoorhangerExtra> show_update_doorhanger(4788);

  /**
   * generated from address.submitted_address_form
   */
  struct SubmittedAddressFormExtra {
    mozilla::Maybe<nsCString> addressLevel1;
    mozilla::Maybe<nsCString> addressLevel2;
    mozilla::Maybe<nsCString> addressLine1;
    mozilla::Maybe<nsCString> addressLine2;
    mozilla::Maybe<nsCString> addressLine3;
    mozilla::Maybe<nsCString> country;
    mozilla::Maybe<nsCString> postalCode;
    mozilla::Maybe<nsCString> streetAddress;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addressLevel1) {
        extraKeys.AppendElement()->AssignASCII("address_level1");
        extraValues.EmplaceBack(addressLevel1.value());
      }
      if (addressLevel2) {
        extraKeys.AppendElement()->AssignASCII("address_level2");
        extraValues.EmplaceBack(addressLevel2.value());
      }
      if (addressLine1) {
        extraKeys.AppendElement()->AssignASCII("address_line1");
        extraValues.EmplaceBack(addressLine1.value());
      }
      if (addressLine2) {
        extraKeys.AppendElement()->AssignASCII("address_line2");
        extraValues.EmplaceBack(addressLine2.value());
      }
      if (addressLine3) {
        extraKeys.AppendElement()->AssignASCII("address_line3");
        extraValues.EmplaceBack(addressLine3.value());
      }
      if (country) {
        extraKeys.AppendElement()->AssignASCII("country");
        extraValues.EmplaceBack(country.value());
      }
      if (postalCode) {
        extraKeys.AppendElement()->AssignASCII("postal_code");
        extraValues.EmplaceBack(postalCode.value());
      }
      if (streetAddress) {
        extraKeys.AppendElement()->AssignASCII("street_address");
        extraValues.EmplaceBack(streetAddress.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a form is submitted. Possible values are `autofilled`, `not_filled`, `user_filled` or `unavailable`.
   * This event was generated to correspond to the Legacy Telemetry event address.submitted#address_form.
   */
  constexpr impl::EventMetric<SubmittedAddressFormExtra> submitted_address_form(4789);

  /**
   * generated from address.submitted_address_form_ext
   */
  struct SubmittedAddressFormExtExtra {
    mozilla::Maybe<nsCString> additionalName;
    mozilla::Maybe<nsCString> email;
    mozilla::Maybe<nsCString> familyName;
    mozilla::Maybe<nsCString> givenName;
    mozilla::Maybe<nsCString> name;
    mozilla::Maybe<nsCString> organization;
    mozilla::Maybe<nsCString> tel;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (additionalName) {
        extraKeys.AppendElement()->AssignASCII("additional_name");
        extraValues.EmplaceBack(additionalName.value());
      }
      if (email) {
        extraKeys.AppendElement()->AssignASCII("email");
        extraValues.EmplaceBack(email.value());
      }
      if (familyName) {
        extraKeys.AppendElement()->AssignASCII("family_name");
        extraValues.EmplaceBack(familyName.value());
      }
      if (givenName) {
        extraKeys.AppendElement()->AssignASCII("given_name");
        extraValues.EmplaceBack(givenName.value());
      }
      if (name) {
        extraKeys.AppendElement()->AssignASCII("name");
        extraValues.EmplaceBack(name.value());
      }
      if (organization) {
        extraKeys.AppendElement()->AssignASCII("organization");
        extraValues.EmplaceBack(organization.value());
      }
      if (tel) {
        extraKeys.AppendElement()->AssignASCII("tel");
        extraValues.EmplaceBack(tel.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Address has too many fields so we cannot cover them all in the above `address_form` telemetry This telemetry is used to record address fields that are not listed in `address_form` This event was generated to correspond to the Legacy Telemetry event address.submitted#address_form_ext.
   */
  constexpr impl::EventMetric<SubmittedAddressFormExtExtra> submitted_address_form_ext(4790);

  /**
   * generated from address.update_capture_doorhanger
   */
  struct UpdateCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.update#capture_doorhanger.
   */
  constexpr impl::EventMetric<UpdateCaptureDoorhangerExtra> update_capture_doorhanger(4791);

  /**
   * generated from address.update_edit_doorhanger
   */
  struct UpdateEditDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.update#edit_doorhanger.
   */
  constexpr impl::EventMetric<UpdateEditDoorhangerExtra> update_edit_doorhanger(4792);

  /**
   * generated from address.update_update_doorhanger
   */
  struct UpdateUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser address autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event address.update#update_doorhanger.
   */
  constexpr impl::EventMetric<UpdateUpdateDoorhangerExtra> update_update_doorhanger(4793);
}

namespace creditcard {
  /**
   * generated from creditcard.add_manage
   */
  struct AddManageExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for credit card autofill preferences management UI. This event was generated to correspond to the Legacy Telemetry event creditcard.add#manage.
   */
  constexpr impl::EventMetric<AddManageExtra> add_manage(4794);

  /**
   * generated from creditcard.cancel_capture_doorhanger
   */
  struct CancelCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser credit card autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event creditcard.cancel#capture_doorhanger.
   */
  constexpr impl::EventMetric<CancelCaptureDoorhangerExtra> cancel_capture_doorhanger(4795);

  /**
   * generated from creditcard.cancel_update_doorhanger
   */
  struct CancelUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser credit card autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event creditcard.cancel#update_doorhanger.
   */
  constexpr impl::EventMetric<CancelUpdateDoorhangerExtra> cancel_update_doorhanger(4796);

  /**
   * generated from creditcard.cleared_cc_form_v2
   */
  struct ClearedCcFormV2Extra {
    mozilla::Maybe<nsCString> ccExp;
    mozilla::Maybe<nsCString> ccExpMonth;
    mozilla::Maybe<nsCString> ccExpYear;
    mozilla::Maybe<nsCString> ccName;
    mozilla::Maybe<nsCString> ccNumber;
    mozilla::Maybe<nsCString> ccType;
    mozilla::Maybe<nsCString> fieldName;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (ccExp) {
        extraKeys.AppendElement()->AssignASCII("cc_exp");
        extraValues.EmplaceBack(ccExp.value());
      }
      if (ccExpMonth) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_month");
        extraValues.EmplaceBack(ccExpMonth.value());
      }
      if (ccExpYear) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_year");
        extraValues.EmplaceBack(ccExpYear.value());
      }
      if (ccName) {
        extraKeys.AppendElement()->AssignASCII("cc_name");
        extraValues.EmplaceBack(ccName.value());
      }
      if (ccNumber) {
        extraKeys.AppendElement()->AssignASCII("cc_number");
        extraValues.EmplaceBack(ccNumber.value());
      }
      if (ccType) {
        extraKeys.AppendElement()->AssignASCII("cc_type");
        extraValues.EmplaceBack(ccType.value());
      }
      if (fieldName) {
        extraKeys.AppendElement()->AssignASCII("field_name");
        extraValues.EmplaceBack(fieldName.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a form is cleared. Using field_name to record the field that triggers this event.
   * This event was generated to correspond to the Legacy Telemetry event creditcard.cleared#cc_form_v2.
   */
  constexpr impl::EventMetric<ClearedCcFormV2Extra> cleared_cc_form_v2(4797);

  /**
   * generated from creditcard.delete_manage
   */
  struct DeleteManageExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for credit card autofill preferences management UI. This event was generated to correspond to the Legacy Telemetry event creditcard.delete#manage.
   */
  constexpr impl::EventMetric<DeleteManageExtra> delete_manage(4798);

  /**
   * generated from creditcard.detected_cc_form_v2
   */
  struct DetectedCcFormV2Extra {
    mozilla::Maybe<nsCString> ccExp;
    mozilla::Maybe<nsCString> ccExpMonth;
    mozilla::Maybe<nsCString> ccExpYear;
    mozilla::Maybe<nsCString> ccName;
    mozilla::Maybe<nsCString> ccNumber;
    mozilla::Maybe<nsCString> ccType;
    mozilla::Maybe<nsCString> fieldName;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (ccExp) {
        extraKeys.AppendElement()->AssignASCII("cc_exp");
        extraValues.EmplaceBack(ccExp.value());
      }
      if (ccExpMonth) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_month");
        extraValues.EmplaceBack(ccExpMonth.value());
      }
      if (ccExpYear) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_year");
        extraValues.EmplaceBack(ccExpYear.value());
      }
      if (ccName) {
        extraKeys.AppendElement()->AssignASCII("cc_name");
        extraValues.EmplaceBack(ccName.value());
      }
      if (ccNumber) {
        extraKeys.AppendElement()->AssignASCII("cc_number");
        extraValues.EmplaceBack(ccNumber.value());
      }
      if (ccType) {
        extraKeys.AppendElement()->AssignASCII("cc_type");
        extraValues.EmplaceBack(ccType.value());
      }
      if (fieldName) {
        extraKeys.AppendElement()->AssignASCII("field_name");
        extraValues.EmplaceBack(fieldName.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a form is recognized as a credit card form. The possible value of cc_* in extra_keys are "true", "false", or an integer between 0-100. When the value is "true", the field is identified via autocomplete attribute. When the value is "false", the field is not detected in the form. When the value is an integer greater than 0, the value indicates the confidence value from fathom (normalized to 0-100). When the value is an 0, then the field is identified by regexp-based heuristic.
   * This event was generated to correspond to the Legacy Telemetry event creditcard.detected#cc_form_v2.
   */
  constexpr impl::EventMetric<DetectedCcFormV2Extra> detected_cc_form_v2(4799);

  /**
   * generated from creditcard.detected_cc_number_fields_count
   */
  enum class DetectedCcNumberFieldsCountLabel: uint16_t {
    eCcNumberFields1 = 0,
    eCcNumberFields2 = 1,
    eCcNumberFields3 = 2,
    eCcNumberFields4 = 3,
    eCcNumberFieldsOther = 4,
    e__Other__,
  };
  /**
   * The count of detected input fields that a website plans on splitting the cc number digits across
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DetectedCcNumberFieldsCountLabel> detected_cc_number_fields_count(4800);

  /**
   * generated from creditcard.disable_capture_doorhanger
   */
  struct DisableCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser credit card autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event creditcard.disable#capture_doorhanger.
   */
  constexpr impl::EventMetric<DisableCaptureDoorhangerExtra> disable_capture_doorhanger(4801);

  /**
   * generated from creditcard.disable_update_doorhanger
   */
  struct DisableUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser credit card autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event creditcard.disable#update_doorhanger.
   */
  constexpr impl::EventMetric<DisableUpdateDoorhangerExtra> disable_update_doorhanger(4802);

  /**
   * generated from creditcard.edit_manage
   */
  struct EditManageExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for credit card autofill preferences management UI. This event was generated to correspond to the Legacy Telemetry event creditcard.edit#manage.
   */
  constexpr impl::EventMetric<EditManageExtra> edit_manage(4803);

  /**
   * generated from creditcard.filled_cc_form_v2
   */
  struct FilledCcFormV2Extra {
    mozilla::Maybe<nsCString> ccExp;
    mozilla::Maybe<nsCString> ccExpMonth;
    mozilla::Maybe<nsCString> ccExpYear;
    mozilla::Maybe<nsCString> ccName;
    mozilla::Maybe<nsCString> ccNumber;
    mozilla::Maybe<nsCString> ccType;
    mozilla::Maybe<nsCString> fieldName;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (ccExp) {
        extraKeys.AppendElement()->AssignASCII("cc_exp");
        extraValues.EmplaceBack(ccExp.value());
      }
      if (ccExpMonth) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_month");
        extraValues.EmplaceBack(ccExpMonth.value());
      }
      if (ccExpYear) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_year");
        extraValues.EmplaceBack(ccExpYear.value());
      }
      if (ccName) {
        extraKeys.AppendElement()->AssignASCII("cc_name");
        extraValues.EmplaceBack(ccName.value());
      }
      if (ccNumber) {
        extraKeys.AppendElement()->AssignASCII("cc_number");
        extraValues.EmplaceBack(ccNumber.value());
      }
      if (ccType) {
        extraKeys.AppendElement()->AssignASCII("cc_type");
        extraValues.EmplaceBack(ccType.value());
      }
      if (fieldName) {
        extraKeys.AppendElement()->AssignASCII("field_name");
        extraValues.EmplaceBack(fieldName.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a form is autofiled. Possible values are `filled`, `not_filled`, `user_filled` or `unavailable`.
   * This event was generated to correspond to the Legacy Telemetry event creditcard.filled#cc_form_v2.
   */
  constexpr impl::EventMetric<FilledCcFormV2Extra> filled_cc_form_v2(4804);

  /**
   * generated from creditcard.filled_modified_cc_form_v2
   */
  struct FilledModifiedCcFormV2Extra {
    mozilla::Maybe<nsCString> ccExp;
    mozilla::Maybe<nsCString> ccExpMonth;
    mozilla::Maybe<nsCString> ccExpYear;
    mozilla::Maybe<nsCString> ccName;
    mozilla::Maybe<nsCString> ccNumber;
    mozilla::Maybe<nsCString> ccType;
    mozilla::Maybe<nsCString> fieldName;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (ccExp) {
        extraKeys.AppendElement()->AssignASCII("cc_exp");
        extraValues.EmplaceBack(ccExp.value());
      }
      if (ccExpMonth) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_month");
        extraValues.EmplaceBack(ccExpMonth.value());
      }
      if (ccExpYear) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_year");
        extraValues.EmplaceBack(ccExpYear.value());
      }
      if (ccName) {
        extraKeys.AppendElement()->AssignASCII("cc_name");
        extraValues.EmplaceBack(ccName.value());
      }
      if (ccNumber) {
        extraKeys.AppendElement()->AssignASCII("cc_number");
        extraValues.EmplaceBack(ccNumber.value());
      }
      if (ccType) {
        extraKeys.AppendElement()->AssignASCII("cc_type");
        extraValues.EmplaceBack(ccType.value());
      }
      if (fieldName) {
        extraKeys.AppendElement()->AssignASCII("field_name");
        extraValues.EmplaceBack(fieldName.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a field is autofilled and then modified by the user. Using field_name to record the field that triggers this event.
   * This event was generated to correspond to the Legacy Telemetry event creditcard.filled_modified#cc_form_v2.
   */
  constexpr impl::EventMetric<FilledModifiedCcFormV2Extra> filled_modified_cc_form_v2(4805);

  /**
   * generated from creditcard.filled_on_fields_update_cc_form_v2
   */
  struct FilledOnFieldsUpdateCcFormV2Extra {
    mozilla::Maybe<nsCString> ccExp;
    mozilla::Maybe<nsCString> ccExpMonth;
    mozilla::Maybe<nsCString> ccExpYear;
    mozilla::Maybe<nsCString> ccName;
    mozilla::Maybe<nsCString> ccNumber;
    mozilla::Maybe<nsCString> ccType;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (ccExp) {
        extraKeys.AppendElement()->AssignASCII("cc_exp");
        extraValues.EmplaceBack(ccExp.value());
      }
      if (ccExpMonth) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_month");
        extraValues.EmplaceBack(ccExpMonth.value());
      }
      if (ccExpYear) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_year");
        extraValues.EmplaceBack(ccExpYear.value());
      }
      if (ccName) {
        extraKeys.AppendElement()->AssignASCII("cc_name");
        extraValues.EmplaceBack(ccName.value());
      }
      if (ccNumber) {
        extraKeys.AppendElement()->AssignASCII("cc_number");
        extraValues.EmplaceBack(ccNumber.value());
      }
      if (ccType) {
        extraKeys.AppendElement()->AssignASCII("cc_type");
        extraValues.EmplaceBack(ccType.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a previous autofill action for the credit card form causes an immediate fields update which triggers another autofill action including for the new/updated fields. Possible values are `filled`, `filled_on_fields_update`, `user_filled` or `unavailable`.
   */
  constexpr impl::EventMetric<FilledOnFieldsUpdateCcFormV2Extra> filled_on_fields_update_cc_form_v2(4806);

  /**
   * generated from creditcard.os_keystore_decrypt
   */
  struct OsKeystoreDecryptExtra {
    mozilla::Maybe<nsCString> errorresult;
    mozilla::Maybe<bool> isdecryptsuccess;
    mozilla::Maybe<nsCString> trigger;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorresult) {
        extraKeys.AppendElement()->AssignASCII("errorResult");
        extraValues.EmplaceBack(errorresult.value());
      }
      if (isdecryptsuccess) {
        extraKeys.AppendElement()->AssignASCII("isDecryptSuccess");
        extraValues.AppendElement()->AssignASCII(isdecryptsuccess.value() ? "true" : "false");
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Captures the result of the OS Keystore decryption, which user interaction triggered the OS Keystore, and any error messages upon failure.
   */
  constexpr impl::EventMetric<OsKeystoreDecryptExtra> os_keystore_decrypt(4807);

  /**
   * generated from creditcard.popup_shown_cc_form_v2
   */
  struct PopupShownCcFormV2Extra {
    mozilla::Maybe<nsCString> ccExp;
    mozilla::Maybe<nsCString> ccExpMonth;
    mozilla::Maybe<nsCString> ccExpYear;
    mozilla::Maybe<nsCString> ccName;
    mozilla::Maybe<nsCString> ccNumber;
    mozilla::Maybe<nsCString> ccType;
    mozilla::Maybe<nsCString> fieldName;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (ccExp) {
        extraKeys.AppendElement()->AssignASCII("cc_exp");
        extraValues.EmplaceBack(ccExp.value());
      }
      if (ccExpMonth) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_month");
        extraValues.EmplaceBack(ccExpMonth.value());
      }
      if (ccExpYear) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_year");
        extraValues.EmplaceBack(ccExpYear.value());
      }
      if (ccName) {
        extraKeys.AppendElement()->AssignASCII("cc_name");
        extraValues.EmplaceBack(ccName.value());
      }
      if (ccNumber) {
        extraKeys.AppendElement()->AssignASCII("cc_number");
        extraValues.EmplaceBack(ccNumber.value());
      }
      if (ccType) {
        extraKeys.AppendElement()->AssignASCII("cc_type");
        extraValues.EmplaceBack(ccType.value());
      }
      if (fieldName) {
        extraKeys.AppendElement()->AssignASCII("field_name");
        extraValues.EmplaceBack(fieldName.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when autofill popup is shown. Using field_name to record the field that triggers this event.
   * This event was generated to correspond to the Legacy Telemetry event creditcard.popup_shown#cc_form_v2.
   */
  constexpr impl::EventMetric<PopupShownCcFormV2Extra> popup_shown_cc_form_v2(4808);

  /**
   * generated from creditcard.save_capture_doorhanger
   */
  struct SaveCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser credit card autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event creditcard.save#capture_doorhanger.
   */
  constexpr impl::EventMetric<SaveCaptureDoorhangerExtra> save_capture_doorhanger(4809);

  /**
   * generated from creditcard.save_update_doorhanger
   */
  struct SaveUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser credit card autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event creditcard.save#update_doorhanger.
   */
  constexpr impl::EventMetric<SaveUpdateDoorhangerExtra> save_update_doorhanger(4810);

  /**
   * generated from creditcard.show_capture_doorhanger
   */
  struct ShowCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser credit card autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event creditcard.show#capture_doorhanger.
   */
  constexpr impl::EventMetric<ShowCaptureDoorhangerExtra> show_capture_doorhanger(4811);

  /**
   * generated from creditcard.show_entry_manage
   */
  struct ShowEntryManageExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for credit card autofill preferences management UI. This event was generated to correspond to the Legacy Telemetry event creditcard.show_entry#manage.
   */
  constexpr impl::EventMetric<ShowEntryManageExtra> show_entry_manage(4812);

  /**
   * generated from creditcard.show_manage
   */
  struct ShowManageExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for credit card autofill preferences management UI. This event was generated to correspond to the Legacy Telemetry event creditcard.show#manage.
   */
  constexpr impl::EventMetric<ShowManageExtra> show_manage(4813);

  /**
   * generated from creditcard.show_update_doorhanger
   */
  struct ShowUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser credit card autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event creditcard.show#update_doorhanger.
   */
  constexpr impl::EventMetric<ShowUpdateDoorhangerExtra> show_update_doorhanger(4814);

  /**
   * generated from creditcard.submitted_cc_form_v2
   */
  struct SubmittedCcFormV2Extra {
    mozilla::Maybe<nsCString> ccExp;
    mozilla::Maybe<nsCString> ccExpMonth;
    mozilla::Maybe<nsCString> ccExpYear;
    mozilla::Maybe<nsCString> ccName;
    mozilla::Maybe<nsCString> ccNumber;
    mozilla::Maybe<nsCString> ccType;
    mozilla::Maybe<nsCString> fieldName;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (ccExp) {
        extraKeys.AppendElement()->AssignASCII("cc_exp");
        extraValues.EmplaceBack(ccExp.value());
      }
      if (ccExpMonth) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_month");
        extraValues.EmplaceBack(ccExpMonth.value());
      }
      if (ccExpYear) {
        extraKeys.AppendElement()->AssignASCII("cc_exp_year");
        extraValues.EmplaceBack(ccExpYear.value());
      }
      if (ccName) {
        extraKeys.AppendElement()->AssignASCII("cc_name");
        extraValues.EmplaceBack(ccName.value());
      }
      if (ccNumber) {
        extraKeys.AppendElement()->AssignASCII("cc_number");
        extraValues.EmplaceBack(ccNumber.value());
      }
      if (ccType) {
        extraKeys.AppendElement()->AssignASCII("cc_type");
        extraValues.EmplaceBack(ccType.value());
      }
      if (fieldName) {
        extraKeys.AppendElement()->AssignASCII("field_name");
        extraValues.EmplaceBack(fieldName.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a form is submitted. Possible values are `autofilled`, `user_filled` or `unavailable`.
   * This event was generated to correspond to the Legacy Telemetry event creditcard.submitted#cc_form_v2.
   */
  constexpr impl::EventMetric<SubmittedCcFormV2Extra> submitted_cc_form_v2(4815);

  /**
   * generated from creditcard.update_capture_doorhanger
   */
  struct UpdateCaptureDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser credit card autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event creditcard.update#capture_doorhanger.
   */
  constexpr impl::EventMetric<UpdateCaptureDoorhangerExtra> update_capture_doorhanger(4816);

  /**
   * generated from creditcard.update_update_doorhanger
   */
  struct UpdateUpdateDoorhangerExtra {
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interactions for the browser credit card autofill doorhanger. This event was generated to correspond to the Legacy Telemetry event creditcard.update#update_doorhanger.
   */
  constexpr impl::EventMetric<UpdateUpdateDoorhangerExtra> update_update_doorhanger(4817);
}

namespace formautofill {
  /**
   * generated from formautofill.availability
   * A boolean sent once per session to represent whether the formautofill is available in the build This metric was generated to correspond to the Legacy Telemetry scalar formautofill.availability.
   */
  constexpr impl::BooleanMetric availability(4818);

  /**
   * generated from formautofill.form_submission_heuristic
   */
  enum class FormSubmissionHeuristicLabel: uint16_t {
    eFormSubmitEvent = 0,
    eFormRemovalAfterFetch = 1,
    ePageNavigation = 2,
    eIframePagehide = 3,
    e__Other__,
  };
  /**
   * The heuristic that detected the form submission.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FormSubmissionHeuristicLabel> form_submission_heuristic(4819);

  /**
   * generated from formautofill.iframe_layout_detection
   */
  struct IframeLayoutDetectionExtra {
    mozilla::Maybe<nsCString> category;
    mozilla::Maybe<nsCString> crossOrigin;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> iframe;
    mozilla::Maybe<uint32_t> iframeCount;
    mozilla::Maybe<nsCString> mainFrame;
    mozilla::Maybe<nsCString> sandboxed;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (category) {
        extraKeys.AppendElement()->AssignASCII("category");
        extraValues.EmplaceBack(category.value());
      }
      if (crossOrigin) {
        extraKeys.AppendElement()->AssignASCII("cross_origin");
        extraValues.EmplaceBack(crossOrigin.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (iframe) {
        extraKeys.AppendElement()->AssignASCII("iframe");
        extraValues.EmplaceBack(iframe.value());
      }
      if (iframeCount) {
        extraKeys.AppendElement()->AssignASCII("iframe_count");
        extraValues.AppendElement()->AppendInt(iframeCount.value());
      }
      if (mainFrame) {
        extraKeys.AppendElement()->AssignASCII("main_frame");
        extraValues.EmplaceBack(mainFrame.value());
      }
      if (sandboxed) {
        extraKeys.AppendElement()->AssignASCII("sandboxed");
        extraValues.EmplaceBack(sandboxed.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record the number of iframe in a form and what fields are in an iframe when a form is detected
   */
  constexpr impl::EventMetric<IframeLayoutDetectionExtra> iframe_layout_detection(4820);

  /**
   * generated from formautofill.os_auth_enabled
   * Check at startup whether OS Authentication has been enabled for credit cards.
   */
  constexpr impl::BooleanMetric os_auth_enabled(4821);

  /**
   * generated from formautofill.prompt_shown_os_reauth
   */
  struct PromptShownOsReauthExtra {
    mozilla::Maybe<nsCString> result;
    mozilla::Maybe<nsCString> trigger;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (result) {
        extraKeys.AppendElement()->AssignASCII("result");
        extraValues.EmplaceBack(result.value());
      }
      if (trigger) {
        extraKeys.AppendElement()->AssignASCII("trigger");
        extraValues.EmplaceBack(trigger.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Captures the method of user interaction initiating the prompt and the result of the prompt. Possible triggers include:
   *   "autofill" when a user attempts to autofill a payment method.
   *   "edit" when a user edits a login in about:preferences
   *   "toggle_pref_os_auth" when a user toggles "Autofill / Require device sign in" in about:preferences
   * Possible results include:
   *   "success" should be used when the user is shown the OS Auth prompt and successfully authenticates.
   *   "fail_user_canceled" should be used when the user cancels the authentication prompt. The user may or may not have provided an incorrect password before cancelling.
   *   "fail_error" should be used when an unexpected exception is encountered.
   */
  constexpr impl::EventMetric<PromptShownOsReauthExtra> prompt_shown_os_reauth(4822);

  /**
   * generated from formautofill.require_os_reauth_toggle
   */
  struct RequireOsReauthToggleExtra {
    mozilla::Maybe<bool> toggleState;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (toggleState) {
        extraKeys.AppendElement()->AssignASCII("toggle_state");
        extraValues.AppendElement()->AssignASCII(toggleState.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Toggle states include:
   *   True means the OS Auth preference is enabled.
   *   False means it is disabled.
   */
  constexpr impl::EventMetric<RequireOsReauthToggleExtra> require_os_reauth_toggle(4823);
}

namespace formautofill_addresses {
  /**
   * generated from formautofill.addresses.autofill_profiles_count
   * Count at store time how many address autofill profiles user has. This metric was generated to correspond to the Legacy Telemetry scalar formautofill.addresses.autofill_profiles_count.
   */
  constexpr impl::QuantityMetric autofill_profiles_count(4824);
}

namespace formautofill_creditcards {
  /**
   * generated from formautofill.creditcards.autofill_profiles_count
   * Count at store time how many credit card autofill profiles the user has.
   */
  constexpr impl::QuantityMetric autofill_profiles_count(4825);
}

} // namespace mozilla::glean

#endif // mozilla_GleanFormautofillMetrics_h
