// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanPrintingMetrics_h
#define mozilla_GleanPrintingMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace printing {
  /**
   * generated from printing.dialog_opened_via_preview_tm
   * A counter incremented every time a user opens the system print dialog from the print preview interface. This metric was generated to correspond to the Legacy Telemetry scalar printing.dialog_opened_via_preview_tm.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> dialog_opened_via_preview_tm(5246);

  /**
   * generated from printing.dialog_via_preview_cancelled_tm
   * A counter incremented every time a user cancels a system print dialog that they opened from the print preview interface. This metric was generated to correspond to the Legacy Telemetry scalar printing.dialog_via_preview_cancelled_tm.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> dialog_via_preview_cancelled_tm(5247);

  /**
   * generated from printing.error
   */
  enum class ErrorLabel: uint16_t {
    eGfxPrinterNoPrinterAvailable = 0,
    eGfxPrinterNameNotFound = 1,
    eGfxPrinterCouldNotOpenFile = 2,
    eGfxPrinterStartdoc = 3,
    eGfxPrinterEnddoc = 4,
    eGfxPrinterStartpage = 5,
    eGfxPrinterDocIsBusy = 6,
    eAbort = 7,
    eNotAvailable = 8,
    eNotImplemented = 9,
    eOutOfMemory = 10,
    eUnexpected = 11,
    eFailure = 12,
    eFallbackPaperList = 13,
    eLastUsedPrinter = 14,
    ePaperMargins = 15,
    ePrintDestinations = 16,
    ePrintPreview = 17,
    ePrinterList = 18,
    ePrinterProperties = 19,
    ePrinterSettings = 20,
    eUnwriteableMargin = 21,
    e__Other__,
  };
  /**
   * A counter incremented every time the user encounters an error printing. The result is split into keys which represent the values of error codes related to printing. Possible values are listed in 'keys'. "FAILURE" is a catch-all code for an error we don't recognize. This metric was generated to correspond to the Legacy Telemetry scalar printing.error.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ErrorLabel> error(5248);

  /**
   * generated from printing.preview_cancelled_tm
   * A counter incremented every time a user exits print preview without printing. This metric was generated to correspond to the Legacy Telemetry scalar printing.preview_cancelled_tm.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> preview_cancelled_tm(5249);

  /**
   * generated from printing.preview_opened_tm
   * A counter incremented every time a user opens print preview. This metric was generated to correspond to the Legacy Telemetry scalar printing.preview_opened_tm.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> preview_opened_tm(5250);

  /**
   * generated from printing.settings_changed
   * A count of how many times the user changed a setting in print preview, broken down per setting. This metric was generated to correspond to the Legacy Telemetry scalar printing.settings_changed.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> settings_changed(5251);

  /**
   * generated from printing.silent_print
   * A counter incremented every time a silent print (a print without a print settings dialog being opened) is initiated.  This happens when extensions invoke ExtensionAPI.tabs.saveAsPDF, for example, or when the print.always_print_silent pref is set. This metric was generated to correspond to the Legacy Telemetry scalar printing.silent_print.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> silent_print(5252);

  /**
   * generated from printing.target_type
   */
  enum class TargetTypeLabel: uint16_t {
    ePdfFile = 0,
    ePdfUnknown = 1,
    eXpsFile = 2,
    eUnknown = 3,
    e__Other__,
  };
  /**
   * A counter incremented every time the user prints to a certain target type.  The 'pdf_unknown' count is for printers with names that we don't know about/check for, but that have 'pdf' in their name, and is mainly a sanity check that we're not missing significant counts in 'pdf_file'. For the most part, the 'unknown' count will be prints to a physical printer, but we can't know for sure since third party drivers could also be print to file drivers that we don't otherwise catch in the other counts. This metric was generated to correspond to the Legacy Telemetry scalar printing.target_type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TargetTypeLabel> target_type(5253);
}

} // namespace mozilla::glean

#endif // mozilla_GleanPrintingMetrics_h
